/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.DirectDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DebugDamageCommand
extends CommandBase {
    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (!(sender instanceof EntityPlayer)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            EnumPlayerPart[] parts = EnumPlayerPart.values();
            ArrayList<String> values = new ArrayList<String>(parts.length);
            for (EnumPlayerPart part : parts) {
                values.add(part.toString());
            }
            values.add("ALL");
            return DebugDamageCommand.func_175762_a((String[])args, values);
        }
        if (args.length == 3) {
            ArrayList<String> values = new ArrayList<String>(2);
            values.add("true");
            values.add("false");
            return values;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public String func_71517_b() {
        return "damagePlayerPart";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return "/damage [part] [damage] (invoke debuffs)";
        }
        return "Only usable by players";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length != 2 && args.length != 3) {
            throw new CommandException("Missing arguments. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        try {
            float damage = Float.parseFloat(args[1]);
            boolean debuff = true;
            if (args.length == 3) {
                debuff = Boolean.parseBoolean(args[2]);
            }
            if (args[0].equalsIgnoreCase("ALL")) {
                for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
                    DebugDamageCommand.damage(part, damage, debuff, (EntityPlayer)sender);
                }
            } else {
                EnumPlayerPart part = EnumPlayerPart.valueOf(args[0].toUpperCase(Locale.ENGLISH));
                DebugDamageCommand.damage(part, damage, debuff, (EntityPlayer)sender);
            }
            if (sender instanceof EntityPlayerMP && !(sender instanceof FakePlayer)) {
                FirstAid.NETWORKING.sendTo((IMessage)new MessageSyncDamageModel((AbstractPlayerDamageModel)Objects.requireNonNull(((EntityPlayer)sender).getCapability(CapabilityExtendedHealthSystem.INSTANCE, null)), false), (EntityPlayerMP)sender);
            }
        }
        catch (RuntimeException e) {
            throw new CommandException(e.toString(), new Object[0]);
        }
    }

    private static void damage(EnumPlayerPart part, float damage, boolean debuff, EntityPlayer player) {
        if (damage == 0.0f) {
            return;
        }
        AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
        if (damage > 0.0f) {
            DamageDistribution.handleDamageTaken(new DirectDamageDistribution(part, debuff), damageModel, damage, player, DamageSource.field_76380_i, false, false);
        } else {
            damageModel.getFromEnum(part).heal(-damage, player, debuff);
        }
    }
}

