/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUpdatePart
implements IMessage {
    private byte id;
    private int maxHealth;
    private float absorption;
    private float currentHealth;

    public MessageUpdatePart() {
    }

    public MessageUpdatePart(AbstractDamageablePart part) {
        this.id = part.part.id;
        this.maxHealth = part.getMaxHealth();
        this.absorption = part.getAbsorption();
        this.currentHealth = part.currentHealth;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readByte();
        this.maxHealth = buf.readInt();
        this.absorption = buf.readFloat();
        this.currentHealth = buf.readFloat();
        this.validate();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.id);
        buf.writeInt(this.maxHealth);
        buf.writeFloat(this.absorption);
        buf.writeFloat(this.currentHealth);
        this.validate();
    }

    private void validate() {
        if (this.currentHealth < 0.0f) {
            throw new RuntimeException("Negative currentHealth!");
        }
        if (this.absorption < 0.0f) {
            throw new RuntimeException("Negative absorption!");
        }
        if (this.maxHealth < 0) {
            throw new RuntimeException("Negative maxHealth!");
        }
        if (EnumPlayerPart.fromID((int)this.id).id != this.id) {
            throw new RuntimeException("Wrong player mapping!");
        }
    }

    public static class Handler
    implements IMessageHandler<MessageUpdatePart, IMessage> {
        public IMessage onMessage(MessageUpdatePart message, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                AbstractDamageablePart damageablePart = ((AbstractPlayerDamageModel)Objects.requireNonNull(mc.field_71439_g.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null))).getFromEnum(EnumPlayerPart.fromID(message.id));
                damageablePart.setMaxHealth(message.maxHealth);
                damageablePart.setAbsorption(message.absorption);
                damageablePart.currentHealth = message.currentHealth;
            });
            return null;
        }
    }
}

