/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.CommandContainer;

public abstract class PregenCommand {
    public static final CompleterHelper helper = new CompleterHelper();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String[] getArgumentDescriptions();

    public abstract int getRequiredParameterCount();

    public abstract Map<String, String> getExamples();

    public abstract void execute(CommandContainer var1, String[] var2);

    public abstract List<String> getAutoCompleteOption(String[] var1, int var2, int var3);

    public void throwErrors(CommandContainer container, int currentLength) {
        if (currentLength >= this.getRequiredParameterCount()) {
            return;
        }
        String[] parameters = this.getArgumentDescriptions();
        container.sendChatMessage("Error Missing following Arugments: ");
        for (int i = currentLength; i < parameters.length; ++i) {
            container.sendChatMessage("[Index: " + i + "]: " + parameters[i]);
        }
    }

    public static List<String> getBestMatch(String[] inputArgs, CompleterHelper.ICompleter complete) {
        return PregenCommand.getBestMatch(inputArgs, complete.getCompleter());
    }

    public static List<String> getBestMatch(String[] inputArgs, String ... possibleCompletions) {
        return PregenCommand.getBestMatch(inputArgs, Arrays.asList(possibleCompletions));
    }

    public static List<String> getBestMatch(String[] inputArgs, Collection<String> possibleCompletions) {
        String lastArgument = inputArgs[inputArgs.length - 1];
        ArrayList<String> results = new ArrayList<String>();
        for (String entry : possibleCompletions) {
            if (!entry.regionMatches(true, 0, lastArgument, 0, lastArgument.length())) continue;
            results.add(entry);
        }
        return results;
    }

    public static String getArg(String[] args, int layer) {
        if (args.length > layer) {
            return args[layer];
        }
        return null;
    }
}

