/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.gen;

import java.util.ArrayList;
import java.util.List;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.storage.PregenTask;

public class StartRegionSubCommand
extends BasePregenCommand {
    public StartRegionSubCommand() {
        super(4);
        this.addDescription(0, "Region File X: The X Position in Chunks of the Region File (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(1, "Region File Z: The Z Position in Chunks of the Region File (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "(Optional) Dimension: The Dimension the Generation should happen in. (It Autoloads dimension if they are unloaded)");
        this.addDescription(3, "(Optional) Processing Rule: Which type of Generation it should use.");
        this.addSuggestion("startregion 20 20", "Generates everything at the Region File 0 0 at the dimension the sender is in");
    }

    @Override
    public String getName() {
        return "startregion";
    }

    @Override
    public String getDescription() {
        return "Generates a full RegionFile";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            FilePos center = StartRegionSubCommand.getChunkPos(args[0], args[1], container.getPlayerPos()).toChunkFile();
            int dimension = StartRegionSubCommand.getDimension(container, StartRegionSubCommand.getArg(args, 2));
            int postRule = StartRegionSubCommand.getProcessRule(StartRegionSubCommand.getArg(args, 3));
            if (!StartRegionSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            PregenTask task = new PregenTask(2, dimension, center.x * 32, center.z * 32, center.x * 32 + 32, center.z * 32 + 32, postRule);
            if (container.onProcessStarted(task)) {
                container.sendChatMessage("Pregenerator already running. Adding Task to the TaskStorage");
                return;
            }
            container.getProcessor().startTask(task);
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0 || commandIndex == 1) {
            return StartRegionSubCommand.getBestMatch(args, "0", "~", "b0");
        }
        if (commandIndex == 2) {
            return StartRegionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 3) {
            return StartRegionSubCommand.getBestMatch(args, CompleterHelper.GEN_PROCESS);
        }
        return new ArrayList<String>();
    }
}

