/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.info;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.RegionFileHelper;

public class ShowChunkFileSubCommand
extends BasePregenCommand {
    public ShowChunkFileSubCommand() {
        super(3);
        this.addDescription(0, "Chunk X: The X Position of the Chunk that the file you want to check with. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(1, "Chunk Z: The Z Position of the Chunk that the file you want to check with. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "(Optional) Dimension: The Dimension the Generation should be in (Auto Loads Dimensions)");
        this.addSuggestion("ShowChunkFile 0 0 1", "Shows the Region File 0.0.mca in the End");
    }

    @Override
    public String getName() {
        return "ShowChunkFile";
    }

    @Override
    public String getDescription() {
        return "Shows a Detailed info about the ChunkSaveFile";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            FilePos position = ShowChunkFileSubCommand.getChunkPos(args[0], args[1], container.getPlayerPos()).toChunkFile();
            int dimension = ShowChunkFileSubCommand.getDimension(container, ShowChunkFileSubCommand.getArg(args, 2));
            if (!ShowChunkFileSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            File file = new File(container.getWorld(dimension).getChunkSaveLocation(), "region");
            if (!file.exists()) {
                container.sendChatMessage("Region Folder for Dimension " + dimension + " doesn't exist");
                return;
            }
            File regionFile = new File(file, "r." + position.x + "." + position.z + ".mca");
            if (!regionFile.exists()) {
                container.sendChatMessage("Region File [" + position + "] doesn't Exist");
                return;
            }
            RegionFileHelper helper = new RegionFileHelper(regionFile);
            try {
                helper.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long length = regionFile.length();
            long kb = length / 1024L;
            long mb = kb / 1024L;
            container.sendChatMessage("RegionFile [" + position + "] contains " + helper.getInstalledChunks().size() + " / 1024 Chunks and is " + mb + "MB (" + kb + "KB) big");
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0 || commandIndex == 1) {
            return ShowChunkFileSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 2) {
            return ShowChunkFileSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }
}

