/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import java.util.LinkedList;

public class ChunkTimer {
    LinkedList<Long> timers = new LinkedList();
    long totalDelta;
    long startTime;

    public void startTime() {
        this.startTime = System.nanoTime();
    }

    public void onChunkFinished() {
        long newTime = System.nanoTime();
        long delta = newTime - this.startTime;
        this.timers.add(delta);
        this.totalDelta += delta;
        if (this.timers.size() > 200) {
            this.totalDelta -= this.timers.removeFirst().longValue();
        }
        this.startTime = newTime;
    }

    public long getAverage() {
        return this.totalDelta / (long)this.timers.size();
    }

    public boolean hasValues() {
        return this.timers.size() > 0;
    }

    public void cleanUp() {
        this.startTime = 0L;
        this.totalDelta = 0L;
        this.timers.clear();
    }
}

