/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import pregenerator.impl.misc.FilePos;

public class RegionFileHelper {
    private static final byte[] EMPTY_SECTOR = new byte[4096];
    private final File fileName;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    Set<FilePos> existingChunks = new LinkedHashSet<FilePos>();

    public RegionFileHelper(File fileNameIn) {
        this.fileName = fileNameIn;
        try {
            this.dataFile = new RandomAccessFile(fileNameIn, "rw");
            if (this.dataFile.length() < 4096L) {
                this.dataFile.write(EMPTY_SECTOR);
                this.dataFile.write(EMPTY_SECTOR);
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int i = 0;
                while ((long)i < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++i;
                }
            }
            this.dataFile.seek(0L);
            for (int j1 = 0; j1 < 1024; ++j1) {
                int k;
                this.offsets[j1] = k = this.dataFile.readInt();
                if (k <= 0) continue;
                this.existingChunks.add(new FilePos(j1 % 32, j1 / 32));
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public boolean close() throws IOException {
        if (this.dataFile != null) {
            this.dataFile.close();
        }
        return this.existingChunks.size() > 0;
    }

    private boolean outOfBounds(int x, int z) {
        return x < 0 || x >= 32 || z < 0 || z >= 32;
    }

    private int getOffset(int x, int z) {
        return this.offsets[x + z * 32];
    }

    public boolean isChunkSaved(int x, int z) {
        return this.getOffset(x, z) != 0;
    }

    public void deleteChunk(int x, int z) {
        if (this.outOfBounds(x, z)) {
            return;
        }
        try {
            this.setOffset(x, z, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setOffset(int x, int z, int offset) throws IOException {
        boolean is;
        boolean was = this.offsets[x + z * 32] != 0;
        this.offsets[x + z * 32] = offset;
        this.dataFile.seek((x + z * 32) * 4);
        this.dataFile.writeInt(offset);
        boolean bl = is = offset != 0;
        if (was != is) {
            if (is) {
                this.existingChunks.add(new FilePos(x, z));
            } else {
                this.existingChunks.remove(new FilePos(x, z));
            }
        }
    }

    public List<FilePos> getInstalledChunks() {
        return new ArrayList<FilePos>(this.existingChunks);
    }

    public File getFile() {
        return this.fileName;
    }
}

