/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.trackerInfo.TrackerEntry;
import pregenerator.impl.network.packets.TrackerAnswerPacket;

public class TrackerRequestPacket
extends PregenPacket {
    List<TrackerEntry> entries = new ArrayList<TrackerEntry>();

    public TrackerRequestPacket() {
    }

    public TrackerRequestPacket(List<TrackerEntry> list) {
        this.entries.addAll(list);
    }

    @Override
    public void read(IReadableBuffer buffer) {
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            TrackerEntry entry = TrackerEntry.getByID(buffer.readByte());
            if (entry == null) continue;
            entry.readServer(buffer);
            this.entries.add(entry);
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeByte(this.entries.size());
        for (TrackerEntry entry : this.entries) {
            buffer.writeByte(entry.getID());
            entry.writeClient(buffer);
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        ChunkPregenerator.networking.sendPacketToPlayer(new TrackerAnswerPacket(this.entries), player);
    }
}

