/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.INotifyListener;
import pregenerator.impl.storage.MassCircleTask;
import pregenerator.impl.storage.PregenTask;

public class TaskStorage
extends WorldSavedData {
    Set<PregenTask> commandsToRun = new LinkedHashSet<PregenTask>();
    Set<INotifyListener> autoListeners = new LinkedHashSet<INotifyListener>();
    Map<PregenTask, PregenMemory> memory = new LinkedHashMap<PregenTask, PregenMemory>();
    boolean created = false;
    Set<Integer> alreadyRan = new HashSet<Integer>();

    public TaskStorage(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        PregenTask task;
        int i;
        this.alreadyRan.clear();
        this.created = nbt.func_74767_n("Created");
        this.commandsToRun.clear();
        this.autoListeners.clear();
        HashMap<Integer, PregenTask> tasks = new HashMap<Integer, PregenTask>();
        NBTTagList list = nbt.func_150295_c("SavedData", 11);
        for (i = 0; i < list.func_74745_c(); ++i) {
            int[] array = list.func_150306_c(i);
            if (array.length == 10) {
                task = new MassCircleTask(array);
                this.commandsToRun.add(task);
                tasks.put(task.hashCode(), task);
                continue;
            }
            if (array.length != 7) continue;
            task = new PregenTask(array);
            this.commandsToRun.add(task);
            tasks.put(task.hashCode(), task);
        }
        list = nbt.func_150295_c("memory", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            task = (PregenTask)tasks.get(data.func_74762_e("key"));
            if (task == null) continue;
            this.memory.put(task, new PregenMemory(data));
        }
        list = nbt.func_150295_c("AutoListeners", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            INotifyListener listener = TaskStorage.fromNBT(list.func_150305_b(i));
            if (listener == null) continue;
            this.autoListeners.add(listener);
        }
        for (int data : nbt.func_74759_k("DimCreated")) {
            this.alreadyRan.add(data);
        }
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74757_a("Created", this.created);
        NBTTagList list = new NBTTagList();
        for (PregenTask pregenTask : this.commandsToRun) {
            list.func_74742_a((NBTBase)pregenTask.save());
        }
        compound.func_74782_a("SavedData", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry entry : this.memory.entrySet()) {
            NBTTagCompound tag = ((PregenMemory)entry.getValue()).save();
            tag.func_74768_a("key", ((PregenTask)entry.getKey()).hashCode());
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("memory", (NBTBase)list);
        list = new NBTTagList();
        for (INotifyListener iNotifyListener : this.autoListeners) {
            list.func_74742_a((NBTBase)iNotifyListener.save());
        }
        compound.func_74782_a("AutoListeners", (NBTBase)list);
        int[] dims = new int[this.alreadyRan.size()];
        boolean bl = false;
        for (Integer data : this.alreadyRan) {
            void var4_10;
            dims[var4_10] = data;
            ++var4_10;
        }
        compound.func_74783_a("DimCreated", dims);
        return compound;
    }

    public void setCreated() {
        this.created = true;
        this.func_76185_a();
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean hasNotRanAlready(int dimID) {
        return this.alreadyRan.add(dimID);
    }

    public void savePregenTask(PregenTask command) {
        this.commandsToRun.add(command);
        this.func_76185_a();
    }

    public void savePregenTasks(List<PregenTask> list) {
        this.commandsToRun.addAll(list);
        this.func_76185_a();
    }

    public List<PregenTask> getTasks() {
        return new ArrayList<PregenTask>(this.commandsToRun);
    }

    public void finishTask(PregenTask command) {
        if (this.commandsToRun.remove(command)) {
            this.memory.remove(command);
            this.func_76185_a();
        }
    }

    public void clearAll() {
        this.commandsToRun.clear();
        this.memory.clear();
        this.func_76185_a();
    }

    public PregenTask clearOne() {
        Iterator<PregenTask> com = this.commandsToRun.iterator();
        if (com.hasNext()) {
            PregenTask result = com.next();
            this.memory.remove(result);
            com.remove();
            this.func_76185_a();
            return result;
        }
        return null;
    }

    public int clearLast() {
        return this.clearIndex(this.commandsToRun.size());
    }

    public int clearIndex(int index) {
        int done;
        if (index == 0) {
            return this.clearOne() != null ? 2 : 0;
        }
        Iterator<PregenTask> com = this.commandsToRun.iterator();
        PregenTask lastTask = null;
        for (done = 0; com.hasNext() && done < index; ++done) {
            lastTask = com.next();
        }
        if (done == index) {
            this.memory.remove(lastTask);
            com.remove();
            this.func_76185_a();
            return 1;
        }
        return 0;
    }

    public boolean hasTasks() {
        return this.commandsToRun.size() > 0;
    }

    public int getTaskCount() {
        return this.commandsToRun.size();
    }

    public PregenTask getNextTask() {
        return this.commandsToRun.iterator().next();
    }

    public PregenMemory getOrCreateMemory(PregenTask task) {
        PregenMemory result = this.memory.get(task);
        if (result == null) {
            result = new PregenMemory();
            this.memory.put(task, result);
        }
        return result;
    }

    public static TaskStorage getStorage() {
        return TaskStorage.getFromServer(FMLCommonHandler.instance().getMinecraftServerInstance());
    }

    public static TaskStorage getFromServer(MinecraftServer server) {
        return TaskStorage.getFromWorld(server.func_130014_f_());
    }

    public static TaskStorage getFromWorld(World world) {
        TaskStorage storage = (TaskStorage)world.func_72943_a(TaskStorage.class, "PregenTaskStorage");
        if (storage == null) {
            storage = new TaskStorage("PregenTaskStorage");
            world.func_72823_a("PregenTaskStorage", (WorldSavedData)storage);
        }
        return storage;
    }

    public String toString() {
        return this.commandsToRun.toString();
    }

    public void addListenState(ICommandSender sender, boolean state) {
        INotifyListener notitfy = TaskStorage.fromSender(sender, state);
        this.autoListeners.remove(notitfy);
        this.autoListeners.add(notitfy);
    }

    public void removeSender(ICommandSender sender) {
        this.autoListeners.remove(TaskStorage.fromSender(sender, false));
    }

    public int getState(ICommandSender sender) {
        for (INotifyListener listen : this.autoListeners) {
            if (!listen.matches(sender)) continue;
            return listen.isListening() ? 1 : 2;
        }
        return 0;
    }

    public boolean autoListens(ICommandSender sender) {
        for (INotifyListener listen : this.autoListeners) {
            if (!listen.matches(sender)) continue;
            return listen.isListening();
        }
        return true;
    }

    public void addListeners(GlobalListeners listen, MinecraftServer server) {
        for (INotifyListener listener : this.autoListeners) {
            ICommandSender sender;
            if (!listener.isListening() || (sender = listener.getSender(server)) == null) continue;
            listen.addListener(sender);
        }
    }

    public static INotifyListener fromNBT(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("Type")) {
            case 0: {
                return new INotifyListener.ServerListener(nbt);
            }
            case 1: {
                return new INotifyListener.PlayerListener(nbt);
            }
        }
        return null;
    }

    public static INotifyListener fromSender(ICommandSender sender, boolean listens) {
        if (sender instanceof EntityPlayer) {
            return new INotifyListener.PlayerListener((EntityPlayer)sender, listens);
        }
        if (sender instanceof MinecraftServer) {
            return new INotifyListener.ServerListener(listens);
        }
        return null;
    }

    public class PregenMemory {
        Map<Long, Byte> chunkState = new LinkedHashMap<Long, Byte>();

        public PregenMemory() {
        }

        public PregenMemory(NBTTagCompound nbt) {
            int size = nbt.func_74762_e("size");
            ByteBuffer buffer = ByteBuffer.wrap(nbt.func_74770_j("data"));
            for (int i = 0; i < size; ++i) {
                this.chunkState.put(buffer.getLong(), buffer.get());
            }
        }

        public void setState(long key, byte value) {
            if (value == 0) {
                this.chunkState.remove(key);
                TaskStorage.this.func_76185_a();
                return;
            }
            this.chunkState.put(key, value);
            TaskStorage.this.func_76185_a();
        }

        public int getState(long key) {
            Byte value = this.chunkState.get(key);
            return value == null ? 0 : value.intValue();
        }

        public NBTTagCompound save() {
            ByteBuffer buffer = ByteBuffer.allocate(this.chunkState.size() * 9);
            for (Map.Entry<Long, Byte> state : this.chunkState.entrySet()) {
                buffer.putLong(state.getKey());
                buffer.put(state.getValue());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74773_a("data", buffer.array());
            nbt.func_74768_a("size", this.chunkState.size());
            return nbt;
        }
    }
}

