/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.config;

import net.minecraftforge.common.config.Config;

@Config(modid="performant")
public class Configuration {
    @Config.Comment(value={"All configurations related to Loadbalancing tps"})
    public static LoadBalancing loadBalancing = new LoadBalancing();
    @Config.Comment(value={"All configurations related to AI"})
    public static AI ai = new AI();
    @Config.Comment(value={"All configurations related to non AI entity changes"})
    public static Entity ex = new Entity();

    public static class Entity {
        @Config.Comment(value={"Use fast collision and nearbyentity checks, default: true"})
        public boolean fastCollisionAndEntityChecks = true;
    }

    public static class AI {
        @Config.Comment(value={"Interval in which non-running AI tasks are rechecked. Vanilla default is 3, this mods suggested default is 4"})
        @Config.RangeInt(min=1, max=500)
        public int goalSelectorTickRate = 4;
        @Config.Comment(value={"Whether to use a slower SwimmingAI, default: true"})
        public boolean slowerSwimmingAI = true;
        @Config.Comment(value={"Whether to use a slower TemptAI check, default: true"})
        public boolean slowerTemptCheck = true;
        @Config.Comment(value={"Whether to use a slower WanderAI check, default: true"})
        public boolean slowerWander = true;
    }

    public static class LoadBalancing {
        @Config.Comment(value={"Enables load balancing for entity AI. default = true"})
        public boolean AILoadBalancing = true;
        @Config.Comment(value={"Mean tick time at which AI load balancing takes effect, 1000 / mean tick time = TPS. default: 45"})
        @Config.RangeInt(min=1, max=500)
        public int meanTickAITH = 45;
        @Config.Comment(value={"Whether to debug lagging entities and log offenders, requires load balancing to be enabled. default = true"})
        public boolean logEntityAILag = true;
    }
}

