/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class UIBase
extends Gui {
    protected static Color idleButtonColor;
    protected static Color hoveredButtonColor;
    protected static Color idleButtonBorderColor;
    protected static Color hoveredButtonBorderColor;
    protected static float buttonBorderWidth;
    protected static float baseUIScale;

    protected static void initButtonColors() {
        if (idleButtonColor == null) {
            idleButtonColor = new Color(71, 71, 71);
            hoveredButtonColor = new Color(83, 156, 212);
            idleButtonBorderColor = new Color(209, 194, 209);
            hoveredButtonBorderColor = new Color(227, 211, 227);
        }
    }

    public static void colorizeButton(AdvancedButton button) {
        UIBase.initButtonColors();
        button.setBackgroundColor(idleButtonColor, hoveredButtonColor, idleButtonBorderColor, hoveredButtonBorderColor, buttonBorderWidth);
    }

    public static Color getButtonIdleColor() {
        UIBase.initButtonColors();
        return idleButtonColor;
    }

    public static Color getButtonBorderIdleColor() {
        UIBase.initButtonColors();
        return idleButtonBorderColor;
    }

    public static Color getButtonHoverColor() {
        UIBase.initButtonColors();
        return hoveredButtonColor;
    }

    public static Color getButtonBorderHoverColor() {
        UIBase.initButtonColors();
        return hoveredButtonBorderColor;
    }

    public static float getUIScale() {
        float uiScale = ((Float)FancyMenu.config.getOrDefault("uiscale", (Object)Float.valueOf(1.0f))).floatValue();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        double mcScale = sr.func_78325_e();
        return (float)((double)baseUIScale * ((double)baseUIScale / mcScale) * (double)uiScale);
    }

    public static void openScaledContextMenuAt(FMContextMenu menu, int x, int y) {
        GuiScreen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null) {
            menu.openMenuAt((int)((float)x / UIBase.getUIScale()), (int)((float)y / UIBase.getUIScale()), (int)((float)s.field_146294_l / UIBase.getUIScale()), (int)((float)s.field_146295_m / UIBase.getUIScale()));
        }
    }

    public static void openScaledContextMenuAtMouse(FMContextMenu menu) {
        UIBase.openScaledContextMenuAt(menu, MouseInput.getMouseX(), MouseInput.getMouseY());
    }

    public static void renderScaledContextMenu(FMContextMenu menu) {
        GuiScreen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null && menu != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)UIBase.getUIScale(), (float)UIBase.getUIScale(), (float)UIBase.getUIScale());
            MouseInput.setRenderScale((float)UIBase.getUIScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            MouseInput.resetRenderScale();
            menu.render(mouseX, mouseY, (int)((float)s.field_146294_l / UIBase.getUIScale()), (int)((float)s.field_146295_m / UIBase.getUIScale()));
            GlStateManager.func_179121_F();
        }
    }

    static {
        buttonBorderWidth = 1.0f;
        baseUIScale = 1.0f;
    }
}

