/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import org.apache.commons.lang3.tuple.Pair;

public class MinecraftTransforms {
    public static AxisAlignedTransform2D from(Rotation rotation, Mirror mirror) {
        return AxisAlignedTransform2D.from(MinecraftTransforms.from(rotation) + (mirror == Mirror.LEFT_RIGHT ? 2 : 0), mirror != Mirror.NONE);
    }

    public static Pair<Rotation, Mirror> to(AxisAlignedTransform2D transform) {
        return Pair.of((Object)MinecraftTransforms.to(transform.getRotation()), (Object)(transform.isMirrorX() ? Mirror.FRONT_BACK : Mirror.NONE));
    }

    public static void useAs(AxisAlignedTransform2D transform, BiConsumer<Rotation, Mirror> consumer) {
        consumer.accept(MinecraftTransforms.to(transform.getRotation()), transform.isMirrorX() ? Mirror.FRONT_BACK : Mirror.NONE);
    }

    public static <T> T map(AxisAlignedTransform2D transform, BiFunction<Rotation, Mirror, T> consumer) {
        return consumer.apply(MinecraftTransforms.to(transform.getRotation()), transform.isMirrorX() ? Mirror.FRONT_BACK : Mirror.NONE);
    }

    public static Rotation to(int rotation) {
        switch (rotation) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.COUNTERCLOCKWISE_90;
    }

    public static int from(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
        }
        return 3;
    }
}

