/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SetMazeComponent<C>
implements MorphingMazeComponent<C> {
    public final Set<MazeRoom> rooms = new HashSet<MazeRoom>();
    public final Map<MazePassage, C> exits = new HashMap<MazePassage, C>();
    public final Multimap<MazePassage, MazePassage> reachability = HashMultimap.create();

    public SetMazeComponent() {
    }

    @Deprecated
    public SetMazeComponent(Set<MazeRoom> rooms, Map<MazePassage, C> exits) {
        this(rooms, exits, (Multimap<MazePassage, MazePassage>)HashMultimap.create());
        SetMazeComponent.connectAll(exits.keySet(), this.reachability);
    }

    public static void connectAll(Set<MazePassage> exits, Multimap<MazePassage, MazePassage> reachability) {
        ArrayList connections = Lists.newArrayList(exits);
        for (int i = 1; i < connections.size(); ++i) {
            MazePassage left = (MazePassage)((Object)connections.get(i - 1));
            MazePassage right = (MazePassage)((Object)connections.get(i));
            reachability.put((Object)left, (Object)right);
            reachability.put((Object)right, (Object)left);
        }
    }

    public static void connectAll(Set<MazePassage> exits, ImmutableMultimap.Builder<MazePassage, MazePassage> reachability) {
        ArrayList connections = Lists.newArrayList(exits);
        for (int i = 1; i < connections.size(); ++i) {
            MazePassage left = (MazePassage)((Object)connections.get(i - 1));
            MazePassage right = (MazePassage)((Object)connections.get(i));
            reachability.put((Object)left, (Object)right);
            reachability.put((Object)right, (Object)left);
        }
    }

    public SetMazeComponent(Set<MazeRoom> rooms, Map<MazePassage, C> exits, Multimap<MazePassage, MazePassage> reachability) {
        this.rooms.addAll(rooms);
        this.exits.putAll(exits);
        this.reachability.putAll(reachability);
    }

    @Override
    public Set<MazeRoom> rooms() {
        return this.rooms;
    }

    @Override
    public Map<MazePassage, C> exits() {
        return this.exits;
    }

    @Override
    public Multimap<MazePassage, MazePassage> reachability() {
        return this.reachability;
    }

    @Override
    public void add(MazeComponent<C> component) {
        this.rooms.addAll(component.rooms());
        component.exits().entrySet().stream().filter(entry -> this.exits.remove(entry.getKey()) == null).forEach(entry -> this.exits.put((MazePassage)((Object)((Object)entry.getKey())), (C)entry.getValue()));
        this.reachability.putAll(component.reachability());
    }

    @Override
    public void set(MazeComponent<C> component) {
        this.rooms.clear();
        this.rooms.addAll(component.rooms());
        this.exits.clear();
        this.exits.putAll(component.exits());
        this.reachability.clear();
        this.reachability.putAll(component.reachability());
    }

    @Override
    public MorphingMazeComponent<C> copy() {
        return new SetMazeComponent<C>(this.rooms, this.exits, this.reachability);
    }
}

