/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

public class ExtendedButtonControl
extends GuiButton {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private FontRenderer currentFontRender = null;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.onPushEvent = onPushEvent;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.onHoverEvent = onHoverEvent;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(CraftPresence.GUIS.getNextIndex(), x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        super(id, xPos, yPos, displayString);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString);
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.setCurrentFontRender(mc.field_71466_p);
        if (this.field_146125_m) {
            this.field_146123_n = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            int hoverState = this.func_146114_a(this.field_146123_n);
            String backgroundCode = CraftPresence.CONFIG.buttonBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                CraftPresence.GUIS.drawGradientRect(this.field_73735_i, this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), backgroundCode, backgroundCode);
            } else {
                ResourceLocation texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                        backgroundCode = backgroundCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                    }
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new ResourceLocation(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
                CraftPresence.GUIS.renderButton(this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), hoverState, this.field_73735_i, texLocation);
            }
            this.func_146119_b(mc, mouseX, mouseY);
            int color = !this.field_146124_l ? 0xA0A0A0 : (this.field_146123_n ? 0xFFFFA0 : 0xE0E0E0);
            this.func_73732_a(this.getFontRenderer(), this.getControlMessage(), this.getControlPosX() + this.getControlWidth() / 2, this.getControlPosY() + (this.getControlHeight() - 8) / 2, color);
        }
    }

    public int getControlWidth() {
        return this.field_146120_f;
    }

    public int getControlHeight() {
        return this.field_146121_g;
    }

    public int getControlPosX() {
        return this.field_146128_h;
    }

    public int getControlPosY() {
        return this.field_146129_i;
    }

    public FontRenderer getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(FontRenderer currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_78288_b;
    }

    public String[] getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public String getControlMessage() {
        return this.field_146126_j;
    }

    public void setControlMessage(String newMessage) {
        this.field_146126_j = newMessage;
    }

    public boolean isControlEnabled() {
        return this.field_146124_l;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.field_146124_l = isEnabled;
    }

    public boolean isControlVisible() {
        return this.field_146125_m;
    }

    public void setControlVisible(boolean isVisible) {
        this.field_146125_m = isVisible;
    }
}

