/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class ExtendedScreen
extends GuiScreen {
    public final GuiScreen parentScreen;
    public final GuiScreen currentScreen;
    protected final List<Gui> extendedControls = Lists.newArrayList();
    protected final List<ScrollableListControl> extendedLists = Lists.newArrayList();
    private boolean initialized = false;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(GuiScreen parentScreen) {
        this.field_146297_k = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.setDebugMode(ModUtils.IS_DEV);
        this.setVerboseMode(ModUtils.IS_VERBOSE);
    }

    public ExtendedScreen(GuiScreen parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(GuiScreen parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.extendedControls.clear();
        this.extendedLists.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.initializeUi();
        super.func_73866_w_();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        this.initialized = false;
        super.func_175273_b(mcIn, w, h);
    }

    @Nonnull
    protected <T extends GuiButton> T func_189646_b(@Nonnull T buttonIn) {
        return this.addControl(buttonIn);
    }

    @Nonnull
    protected <T extends Gui> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof GuiButton && !this.field_146292_n.contains(buttonIn)) {
            this.field_146292_n.add((GuiButton)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.field_146294_l, this.field_146295_m);
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                if (!listControl.func_148125_i()) continue;
                listControl.func_148128_a(mouseX, mouseY, partialTicks);
            }
            for (Gui extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146194_f();
            }
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (Gui extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public void func_146274_d() throws IOException {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.func_178039_p();
            }
            super.func_146274_d();
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        if (button instanceof ExtendedButtonControl) {
            ((ExtendedButtonControl)button).onClick();
        }
        super.func_146284_a(button);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.initialized) {
            if (keyCode == 1) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
            }
            for (Gui extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146201_a(typedChar, keyCode);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.initialized) {
            for (Gui extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146192_a(mouseX, mouseY, mouseButton);
            }
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_73876_c() {
        if (this.initialized) {
            for (Gui extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146178_a();
            }
        }
    }

    public void func_146281_b() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.field_146294_l / widthScale) - (float)StringUtils.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.field_146295_m / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().func_175063_a(text, xPos, yPos, color);
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146297_k.field_71466_p != null ? this.field_146297_k.field_71466_p : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_78288_b;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }
}

