/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import de.keksuccino.fancymenu.keybinding.Keybinding;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonScriptEngine;
import de.keksuccino.fancymenu.menu.button.VanillaButtonDescriptionHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.music.GameMusicHandler;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.fancymenu.menu.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.menu.slideshow.SlideshowHandler;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.exceptions.InvalidValueException;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="fancymenu", acceptedMinecraftVersions="[1.12,1.12.2]", dependencies="after:randompatches;after:findme;required-after:konkrete@[1.1.7,]", clientSideOnly=true)
public class FancyMenu {
    public static final String VERSION = "2.2.2";
    public static Config config;
    private static final File animationsPath;
    private static final File customizationPath;
    private static final File customGuiPath;
    private static final File buttonscriptPath;
    private static final File panoramaPath;
    private static final File slideshowPath;
    private static boolean optifineLoaded;

    public FancyMenu() {
        try {
            if (FMLClientHandler.instance().getSide() == Side.CLIENT) {
                animationsPath.mkdirs();
                customizationPath.mkdirs();
                customGuiPath.mkdirs();
                buttonscriptPath.mkdirs();
                panoramaPath.mkdirs();
                slideshowPath.mkdirs();
                FancyMenu.updateConfig();
                AnimationHandler.init();
                AnimationHandler.loadCustomAnimations();
                PanoramaHandler.init();
                SlideshowHandler.init();
                CustomGuiLoader.loadCustomGuis();
                GameIntroHandler.init();
                MenuCustomization.init();
                if (((Boolean)config.getOrDefault("enablehotkeys", (Object)true)).booleanValue()) {
                    Keybinding.init();
                }
                ButtonScriptEngine.init();
                VanillaButtonDescriptionHandler.init();
                Konkrete.addPostLoadingEvent((String)"fancymenu", this::onClientSetup);
            } else {
                System.out.println("## WARNING ## 'FancyMenu' is a client mod and has no effect when loaded on a server!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClientSetup() {
        try {
            if (FMLClientHandler.instance().getSide() == Side.CLIENT) {
                FancyMenu.initLocals();
                GameMusicHandler.init();
                GuiConstructor.init();
                try {
                    Class.forName("optifine.Installer");
                    optifineLoaded = true;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void initLocals() {
        String baseresdir = "fmlocals/";
        File f = new File("config/fancymenu/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "en_us.local"), (String)"en_us", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "de_de.local"), (String)"de_de", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "pl_pl.local"), (String)"pl_pl", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "pt_br.local"), (String)"pt_br", (String)f.getPath());
        Locals.getLocalsFromDir((String)f.getPath());
    }

    public static void updateConfig() {
        try {
            config = new Config("config/fancymenu/config.txt");
            config.registerValue("enablehotkeys", Boolean.valueOf(true), "general", "A minecraft restart is required after changing this value.");
            config.registerValue("playmenumusic", Boolean.valueOf(true), "general");
            config.registerValue("playbackgroundsounds", Boolean.valueOf(true), "general", "If menu background sounds added by FancyMenu should be played or not.");
            config.registerValue("playbackgroundsoundsinworld", Boolean.valueOf(false), "general", "If menu background sounds added by FancyMenu should be played when a world is loaded.");
            config.registerValue("stopworldmusicwhencustomizable", Boolean.valueOf(false), "general", "Stop vanilla world music when in a customizable menu.");
            config.registerValue("defaultguiscale", Integer.valueOf(-1), "general", "Sets the default GUI scale on first launch. Useful for modpacks. Cache data is saved in '/mods/fancymenu/'.");
            config.registerValue("showdebugwarnings", Boolean.valueOf(true), "general");
            config.registerValue("showcustomizationbuttons", Boolean.valueOf(true), "customization");
            config.registerValue("advancedmode", Boolean.valueOf(false), "customization");
            config.registerValue("hidebranding", Boolean.valueOf(true), "mainmenu");
            config.registerValue("hidelogo", Boolean.valueOf(false), "mainmenu");
            config.registerValue("hiderealmsnotifications", Boolean.valueOf(false), "mainmenu");
            config.registerValue("copyrightposition", "bottom-right", "mainmenu");
            config.registerValue("hideforgenotifications", Boolean.valueOf(false), "mainmenu");
            config.registerValue("copyrightcolor", "#ffffff", "mainmenu");
            config.registerValue("hidesplashtext", Boolean.valueOf(false), "mainmenu_splash");
            config.registerValue("splashx", Integer.valueOf(0), "mainmenu_splash");
            config.registerValue("splashy", Integer.valueOf(0), "mainmenu_splash");
            config.registerValue("splashorientation", "original", "mainmenu_splash");
            config.registerValue("splashcolor", "#ffff00", "mainmenu_splash");
            config.registerValue("splashtextfile", "", "mainmenu_splash");
            config.registerValue("splashrotation", Integer.valueOf(-20), "mainmenu_splash");
            config.registerValue("gameintroanimation", "", "loading");
            config.registerValue("showanimationloadingstatus", Boolean.valueOf(true), "loading");
            config.registerValue("allowgameintroskip", Boolean.valueOf(true), "loading");
            config.registerValue("customgameintroskiptext", "", "loading");
            config.registerValue("loadinganimationcolor", "#E22837", "loading");
            config.registerValue("preloadanimations", Boolean.valueOf(true), "loading");
            config.registerValue("customwindowicon", Boolean.valueOf(false), "minecraftwindow", "A minecraft restart is required after changing this value.");
            config.registerValue("customwindowtitle", "", "minecraftwindow", "A minecraft restart is required after changing this value.");
            config.registerValue("showvanillamovewarning", Boolean.valueOf(true), "layouteditor", "If the warning when trying to move an vanilla button without an orientation should be displayed or not.");
            config.registerValue("editordeleteconfirmation", Boolean.valueOf(true), "layouteditor");
            config.registerValue("uiscale", Float.valueOf(1.0f), "ui");
            config.syncConfig();
            config.clearUnusedValues();
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }

    public static File getAnimationPath() {
        if (!animationsPath.exists()) {
            animationsPath.mkdirs();
        }
        return animationsPath;
    }

    public static File getCustomizationPath() {
        if (!customizationPath.exists()) {
            customizationPath.mkdirs();
        }
        return customizationPath;
    }

    public static File getCustomGuiPath() {
        if (!customGuiPath.exists()) {
            customGuiPath.mkdirs();
        }
        return customGuiPath;
    }

    public static File getButtonScriptPath() {
        if (!buttonscriptPath.exists()) {
            buttonscriptPath.mkdirs();
        }
        return buttonscriptPath;
    }

    public static File getPanoramaPath() {
        if (!panoramaPath.exists()) {
            panoramaPath.mkdirs();
        }
        return panoramaPath;
    }

    public static File getSlideshowPath() {
        if (!slideshowPath.exists()) {
            slideshowPath.mkdirs();
        }
        return slideshowPath;
    }

    public static boolean isOptifineLoaded() {
        return optifineLoaded;
    }

    public static boolean isDrippyLoadingScreenLoaded() {
        try {
            Class.forName("de.keksuccino.drippyloadingscreen.DrippyLoadingScreen");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isKonkreteLoaded() {
        try {
            Class.forName("de.keksuccino.konkrete.Konkrete");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        animationsPath = new File("config/fancymenu/animations");
        customizationPath = new File("config/fancymenu/customization");
        customGuiPath = new File("config/fancymenu/customguis");
        buttonscriptPath = new File("config/fancymenu/buttonscripts");
        panoramaPath = new File("config/fancymenu/panoramas");
        slideshowPath = new File("config/fancymenu/slideshows");
        optifineLoaded = false;
    }
}

