/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AnimationHandlerEvents {
    private boolean idle = false;
    private GuiScreen lastScreen;
    private boolean animationsLoaded = false;

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent e) {
        if (e.getGui() instanceof GuiMainMenu) {
            if (!AnimationHandler.isReady()) {
                AnimationHandler.setupAnimations(e);
            }
            if (((Boolean)FancyMenu.config.getOrDefault("preloadanimations", (Object)true)).booleanValue()) {
                if (!this.animationsLoaded) {
                    System.out.println("[FANCYMENU] LOADING ANIMATION TEXTURES! THIS CAUSES THE LOADING SCREEN TO FREEZE FOR A WHILE!");
                    try {
                        ArrayList<ResourcePackAnimationRenderer> l = new ArrayList<ResourcePackAnimationRenderer>();
                        for (IAnimationRenderer iAnimationRenderer : AnimationHandler.getAnimations()) {
                            if (iAnimationRenderer instanceof AdvancedAnimation) {
                                IAnimationRenderer main = ((AdvancedAnimation)iAnimationRenderer).getMainAnimationRenderer();
                                IAnimationRenderer intro = ((AdvancedAnimation)iAnimationRenderer).getIntroAnimationRenderer();
                                if (main != null && main instanceof ResourcePackAnimationRenderer) {
                                    l.add((ResourcePackAnimationRenderer)main);
                                }
                                if (intro == null || !(intro instanceof ResourcePackAnimationRenderer)) continue;
                                l.add((ResourcePackAnimationRenderer)intro);
                                continue;
                            }
                            if (!(iAnimationRenderer instanceof ResourcePackAnimationRenderer)) continue;
                            l.add((ResourcePackAnimationRenderer)iAnimationRenderer);
                        }
                        for (ResourcePackAnimationRenderer resourcePackAnimationRenderer : l) {
                            for (ResourceLocation rl : resourcePackAnimationRenderer.getAnimationFrames()) {
                                TextureManager t = Minecraft.func_71410_x().func_110434_K();
                                ITextureObject to = t.func_110581_b(rl);
                                if (to != null) continue;
                                to = new SimpleTexture(rl);
                                t.func_110579_a(rl, to);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.out.println("[FANCYMENU] FINISHED LOADING ANIMATION TEXTURES!");
                    this.animationsLoaded = true;
                }
            } else {
                this.animationsLoaded = true;
            }
        }
    }

    @SubscribeEvent
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        if (MenuCustomization.isValidScreen(e.getGui())) {
            if (AnimationHandler.isReady() && this.lastScreen != e.getGui() && !LayoutEditorScreen.isActive) {
                for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                    if (!(r instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)r).stopAudio();
                    if (!((AdvancedAnimation)r).replayIntro()) continue;
                    ((AdvancedAnimation)r).resetAnimation();
                }
            }
            this.lastScreen = e.getGui();
        }
        this.idle = false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71462_r == null && AnimationHandler.isReady() && !this.idle) {
            for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                if (!(r instanceof AdvancedAnimation)) continue;
                ((AdvancedAnimation)r).stopAudio();
            }
            this.idle = true;
        }
    }
}

