/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.GuiInitCompletedEvent;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.konkrete.gui.screens.SimpleLoadingScreen;
import de.keksuccino.konkrete.localization.LocaleUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ButtonCache {
    private static Map<Long, ButtonData> buttons = new HashMap<Long, ButtonData>();
    private static Map<Long, GuiButton> replaced = new HashMap<Long, GuiButton>();
    private static GuiScreen current = null;
    private static boolean cached = false;
    private static boolean caching = false;

    @SubscribeEvent
    public void updateCache(GuiScreenEvent.InitGuiEvent.Post e) {
        if (!caching) {
            cached = false;
            current = e.getGui();
        }
    }

    @SubscribeEvent
    public void onInitCompleted(GuiInitCompletedEvent e) {
        ButtonCache.cache(e.getGui());
    }

    private static void cache(GuiScreen s) {
        if (!cached) {
            cached = true;
            if (s instanceof LayoutEditorScreen) {
                return;
            }
            if (s instanceof SimpleLoadingScreen) {
                return;
            }
            if (!MenuCustomization.isMenuCustomizable(s)) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s != null && s instanceof GuiVideoSettings && FancyMenu.isOptifineLoaded()) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("slimeknights.")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("net.optifine")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s == Minecraft.func_71410_x().field_71462_r) {
                ButtonCache.updateButtons(s);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, ButtonCache.getButtons(), true));
        }
    }

    private static void updateButtons(GuiScreen s) {
        replaced.clear();
        buttons.clear();
        if (!MenuCustomization.isMenuCustomizable(s)) {
            return;
        }
        if (s != null && s instanceof GuiVideoSettings && FancyMenu.isOptifineLoaded()) {
            return;
        }
        if (s.getClass().getName().startsWith("slimeknights.")) {
            return;
        }
        if (s.getClass().getName().startsWith("net.optifine")) {
            return;
        }
        List<ButtonData> ids = ButtonCache.cacheButtons(s, 1000, 1000);
        List<ButtonData> btns = ButtonCache.cacheButtons(s, MainWindowHandler.getScaledWidth(), MainWindowHandler.getScaledHeight());
        if (btns.size() == ids.size()) {
            int i = 0;
            for (ButtonData id : ids) {
                ButtonData button = btns.get(i);
                if (!buttons.containsKey(id.getId())) {
                    buttons.put(id.getId(), new ButtonData(button.getButton(), id.getId(), LocaleUtils.getKeyForString((String)button.getButton().field_146126_j), s));
                } else if (((Boolean)FancyMenu.config.getOrDefault("showdebugwarnings", (Object)true)).booleanValue()) {
                    System.out.println("");
                    System.out.println("#### WARNING [FANCYMENU]: Overlapping buttons found!");
                    System.out.println("At: X=" + button.x + " Y=" + button.y + "!");
                    System.out.println("Labels: " + button.label + ", " + ButtonCache.buttons.get((Object)Long.valueOf((long)id.getId())).label);
                    System.out.println("");
                    System.out.println("If one or both of these buttons are added by a mod, please contact the developer(s) to fix this!");
                    System.out.println("FancyMenu cannot customize overlapping buttons!");
                    System.out.println("#####################################################");
                    System.out.println("");
                }
                ++i;
            }
        }
    }

    private static List<ButtonData> cacheButtons(GuiScreen s, int screenWidth, int screenHeight) {
        caching = true;
        ArrayList<ButtonData> buttonlist = new ArrayList<ButtonData>();
        try {
            Field f0 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
            ((List)f0.get(s)).clear();
            s.field_146297_k = Minecraft.func_71410_x();
            s.field_146294_l = screenWidth;
            s.field_146295_m = screenHeight;
            Field f1 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"itemRender", "field_146296_j"});
            f1.set(s, Minecraft.func_71410_x().func_175599_af());
            Field f2 = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"fontRenderer", "field_146289_q"});
            f2.set(s, Minecraft.func_71410_x().field_71466_p);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre(s, (List)f0.get(s)));
            s.func_73866_w_();
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post(s, (List)f0.get(s)));
            Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
            for (GuiButton w : (List)f.get(s)) {
                String idRaw = w.field_146128_h + "" + w.field_146129_i;
                long id = 0L;
                if (MathUtils.isLong((String)idRaw)) {
                    id = Long.parseLong(idRaw);
                }
                buttonlist.add(new ButtonData(w, id, LocaleUtils.getKeyForString((String)w.field_146126_j), s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        caching = false;
        return buttonlist;
    }

    public static void replaceButton(long id, GuiButton w) {
        ButtonData d = ButtonCache.getButtonForId(id);
        GuiButton ori = null;
        if (d != null && current != null) {
            try {
                Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});
                List l = (List)f.get(current);
                ArrayList<GuiButton> l2 = new ArrayList<GuiButton>();
                for (GuiButton b : l) {
                    if (b == d.getButton()) {
                        l2.add(w);
                        ori = b;
                        continue;
                    }
                    l2.add(b);
                }
                f.set(current, l2);
                if (ori != null) {
                    replaced.put(d.getId(), ori);
                }
                d.replaceButton(w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void replaceButton(String key, GuiButton w) {
        ButtonData d = ButtonCache.getButtonForKey(key);
        if (d != null) {
            ButtonCache.replaceButton(d.getId(), w);
        }
    }

    public static void cacheFrom(GuiScreen s, int screenWidth, int screenHeight) {
        ButtonCache.updateButtons(s);
    }

    public static long getIdForButton(GuiButton w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getId();
        }
        return -1L;
    }

    public static String getNameForButton(GuiButton w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().label;
        }
        return null;
    }

    public static String getKeyForButton(GuiButton w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getKey();
        }
        return null;
    }

    public static ButtonData getButtonForId(long id) {
        return buttons.get(id);
    }

    public static ButtonData getButtonForKey(String key) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().getKey().equalsIgnoreCase(key)) continue;
            return m.getValue();
        }
        return null;
    }

    public static ButtonData getButtonForName(String name) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().label.equals(name)) continue;
            return m.getValue();
        }
        return null;
    }

    public static List<ButtonData> getButtons() {
        ArrayList<ButtonData> b = new ArrayList<ButtonData>();
        b.addAll(buttons.values());
        return b;
    }

    public static boolean isCaching() {
        return caching;
    }
}

