/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class DynamicValueHelper {
    public static String convertFromRaw(String in) {
        int width = 0;
        int height = 0;
        String playername = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        String playeruuid = Minecraft.func_71410_x().func_110432_I().func_148255_b();
        String mcversion = "1.12.2";
        if (Minecraft.func_71410_x().field_71462_r != null) {
            width = Minecraft.func_71410_x().field_71462_r.field_146294_l;
            height = Minecraft.func_71410_x().field_71462_r.field_146295_m;
        }
        in = StringUtils.convertFormatCodes((String)in, (String)"&", (String)"\u00a7");
        in = in.replace("%guiwidth%", "" + width);
        in = in.replace("%guiheight%", "" + height);
        in = in.replace("%playername%", playername);
        in = in.replace("%playeruuid%", playeruuid);
        in = in.replace("%mcversion%", mcversion);
        in = DynamicValueHelper.replaceModVersionPlaceolder(in);
        int loaded = DynamicValueHelper.getLoadedMods();
        in = in.replace("%loadedmods%", "" + loaded);
        int total = DynamicValueHelper.getTotalMods();
        if (total < loaded) {
            total = loaded;
        }
        in = in.replace("%totalmods%", "" + total);
        return in;
    }

    public static boolean containsDynamicValues(String in) {
        String s = DynamicValueHelper.convertFromRaw(in);
        return !s.equals(in);
    }

    private static String replaceModVersionPlaceolder(String in) {
        try {
            if (in.contains("%version:")) {
                ArrayList<String> l = new ArrayList<String>();
                int index = -1;
                for (int i = 0; i < in.length(); ++i) {
                    String s = "" + in.charAt(i);
                    if (!s.equals("%")) continue;
                    if (index == -1) {
                        index = i;
                        continue;
                    }
                    String sub = in.substring(index, i + 1);
                    if (sub.startsWith("%version:") && sub.endsWith("%")) {
                        l.add(sub);
                    }
                    index = -1;
                }
                for (String s : l) {
                    ModContainer c;
                    String blank;
                    String mod;
                    if (!s.contains(":") || !Loader.isModLoaded((String)(mod = (blank = s.substring(1, s.length() - 1)).split(":", 2)[1])) || (c = DynamicValueHelper.getModContainerById(mod)) == null) continue;
                    String version = c.getVersion();
                    in = in.replace(s, version);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    private static ModContainer getModContainerById(String modid) {
        try {
            for (ModContainer c : Loader.instance().getActiveModList()) {
                if (!c.getModId().equals(modid)) continue;
                return c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static int getTotalMods() {
        try {
            return Loader.instance().getModList().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static int getLoadedMods() {
        try {
            return Loader.instance().getActiveModList().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

