/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroScreen;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationButton;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.CreateCustomGuiPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.MenuBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMNotificationPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMTextInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMYesNoPopup;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.screens.ConfigScreen;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.gui.screens.popup.TextInputPopup;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CustomizationHelperUI
extends UIBase {
    public static MenuBar bar;
    public static boolean showButtonInfo;
    public static boolean showMenuInfo;
    protected static List<ButtonData> buttons;
    protected static int tick;
    protected static final ResourceLocation CLOSE_BUTTON_TEXTURE;
    protected static final ResourceLocation RELOAD_BUTTON_TEXTURE;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new CustomizationHelperUI());
    }

    public static void updateUI() {
        try {
            boolean extended = true;
            if (bar != null) {
                extended = bar.isExtended();
            }
            bar = new MenuBar();
            FMContextMenu currentMenu = new FMContextMenu();
            currentMenu.setAutoclose(true);
            bar.addChild(currentMenu, "fm.ui.tab.current", MenuBar.ElementAlignment.LEFT);
            String toggleLabel = Locals.localize((String)"helper.popup.togglecustomization.enable", (String[])new String[0]);
            if (MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
                toggleLabel = Locals.localize((String)"helper.popup.togglecustomization.disable", (String[])new String[0]);
            }
            CustomizationButton toggleCustomizationButton = new CustomizationButton(0, 0, 0, 0, toggleLabel, true, press -> {
                if (MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
                    press.field_146126_j = Locals.localize((String)"helper.popup.togglecustomization.enable", (String[])new String[0]);
                    MenuCustomization.disableCustomizationForMenu(Minecraft.func_71410_x().field_71462_r);
                    CustomizationHelper.reloadSystemAndMenu();
                } else {
                    press.field_146126_j = Locals.localize((String)"helper.popup.togglecustomization.disable", (String[])new String[0]);
                    MenuCustomization.enableCustomizationForMenu(Minecraft.func_71410_x().field_71462_r);
                    CustomizationHelper.reloadSystemAndMenu();
                }
            });
            toggleCustomizationButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.onoff.btndesc", (String[])new String[0]), (String)"%n%"));
            currentMenu.addContent(toggleCustomizationButton);
            FMContextMenu layoutsMenu = new FMContextMenu();
            layoutsMenu.setAutoclose(true);
            currentMenu.addChild(layoutsMenu);
            CustomizationButton newLayoutButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts.new", (String[])new String[0]), true, press -> {
                LayoutEditorScreen.isActive = true;
                GuiScreen s = Minecraft.func_71410_x().field_71462_r;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new LayoutEditorScreen(s));
                MenuCustomization.stopSounds();
                MenuCustomization.resetSounds();
                for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                    if (!(r instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)r).stopAudio();
                    if (!((AdvancedAnimation)r).replayIntro()) continue;
                    ((AdvancedAnimation)r).resetAnimation();
                }
            });
            newLayoutButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.new.desc", (String[])new String[0]), (String)"%n%"));
            layoutsMenu.addContent(newLayoutButton);
            ManageLayoutsContextMenu manageLayoutsMenu = new ManageLayoutsContextMenu();
            manageLayoutsMenu.setAutoclose(true);
            layoutsMenu.addChild(manageLayoutsMenu);
            CustomizationButton manageLayoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts.manage", (String[])new String[0]), true, press -> {
                manageLayoutsMenu.setParentButton((AdvancedButton)press);
                manageLayoutsMenu.openMenuAt(press);
            });
            manageLayoutsButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.manage.desc", (String[])new String[0]), (String)"%n%"));
            layoutsMenu.addContent(manageLayoutsButton);
            CustomizationButton layoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts", (String[])new String[0]), true, press -> {
                layoutsMenu.setParentButton((AdvancedButton)press);
                layoutsMenu.openMenuAt(0, press.field_146129_i);
            });
            if (!MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
                layoutsButton.field_146124_l = false;
            }
            layoutsButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.desc", (String[])new String[0]), (String)"%n%"));
            currentMenu.addContent(layoutsButton);
            FMContextMenu advancedMenu = new FMContextMenu();
            advancedMenu.setAutoclose(true);
            currentMenu.addChild(advancedMenu);
            OverrideMenuContextMenu overrideMenu = new OverrideMenuContextMenu();
            overrideMenu.setAutoclose(true);
            advancedMenu.addChild(overrideMenu);
            String overrLabel = Locals.localize((String)"helper.buttons.tools.overridemenu", (String[])new String[0]);
            if (CustomizationHelper.isScreenOverridden(Minecraft.func_71410_x().field_71462_r)) {
                overrLabel = Locals.localize((String)"helper.buttons.tools.resetoverride", (String[])new String[0]);
            }
            CustomizationButton overrideButton = new CustomizationButton(0, 0, 0, 0, overrLabel, true, press -> {
                if (!CustomizationHelper.isScreenOverridden(Minecraft.func_71410_x().field_71462_r)) {
                    overrideMenu.setParentButton((AdvancedButton)press);
                    overrideMenu.openMenuAt(0, press.field_146129_i);
                } else {
                    for (String s : FileUtils.getFiles((String)FancyMenu.getCustomizationPath().getPath())) {
                        PropertiesSet props = PropertiesSerializer.getProperties((String)s);
                        if (props == null) continue;
                        PropertiesSet props2 = new PropertiesSet(props.getPropertiesType());
                        List l = props.getProperties();
                        ArrayList<PropertiesSection> l2 = new ArrayList<PropertiesSection>();
                        boolean b = false;
                        List metas = props.getPropertiesOfType("customization-meta");
                        if (metas == null || metas.isEmpty()) {
                            metas = props.getPropertiesOfType("type-meta");
                        }
                        if (metas == null || metas.isEmpty()) continue;
                        String identifier = ((PropertiesSection)metas.get(0)).getEntryValue("identifier");
                        GuiScreen overridden = ((CustomGuiBase)Minecraft.func_71410_x().field_71462_r).getOverriddenScreen();
                        if (identifier == null || !identifier.equalsIgnoreCase(overridden.getClass().getName())) continue;
                        for (PropertiesSection sec : l) {
                            String action = sec.getEntryValue("action");
                            if (sec.getSectionType().equalsIgnoreCase("customization-meta") || sec.getSectionType().equalsIgnoreCase("type-meta")) {
                                l2.add(sec);
                                continue;
                            }
                            if (action != null && !action.equalsIgnoreCase("overridemenu")) {
                                l2.add(sec);
                            }
                            if (action == null || !action.equalsIgnoreCase("overridemenu")) continue;
                            b = true;
                        }
                        if (!b) continue;
                        File f = new File(s);
                        if (f.exists() && f.isFile()) {
                            f.delete();
                        }
                        if (l2.size() <= 1) continue;
                        for (PropertiesSection sec : l2) {
                            props2.addProperties(sec);
                        }
                        PropertiesSerializer.writeProperties((PropertiesSet)props2, (String)s);
                    }
                    CustomizationHelper.reloadSystemAndMenu();
                    if (Minecraft.func_71410_x().field_71462_r instanceof CustomGuiBase) {
                        Minecraft.func_71410_x().func_147108_a(((CustomGuiBase)Minecraft.func_71410_x().field_71462_r).getOverriddenScreen());
                    }
                }
            });
            overrideButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.overridewith.btndesc", (String[])new String[0]), (String)"%n%"));
            if (!(Minecraft.func_71410_x().field_71462_r instanceof CustomGuiBase)) {
                advancedMenu.addContent(overrideButton);
            } else if (((CustomGuiBase)Minecraft.func_71410_x().field_71462_r).getOverriddenScreen() != null) {
                advancedMenu.addContent(overrideButton);
            }
            CustomizationButton advancedButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.advanced", (String[])new String[0]), true, press -> {
                advancedMenu.setParentButton((AdvancedButton)press);
                advancedMenu.openMenuAt(0, press.field_146129_i);
            });
            if (!MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
                advancedButton.field_146124_l = false;
            }
            advancedButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.advanced.desc", (String[])new String[0]), (String)"%n%"));
            if (((Boolean)FancyMenu.config.getOrDefault("advancedmode", (Object)false)).booleanValue()) {
                currentMenu.addContent(advancedButton);
            }
            CustomizationButton closeCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc.closegui", (String[])new String[0]), true, press -> Minecraft.func_71410_x().func_147108_a(null));
            closeCustomGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.closegui.desc", (String[])new String[0]), (String)"%n%"));
            if (Minecraft.func_71410_x().field_71462_r instanceof CustomGuiBase && ((CustomGuiBase)Minecraft.func_71410_x().field_71462_r).getOverriddenScreen() == null) {
                currentMenu.addContent(closeCustomGuiButton);
            }
            CustomizationButton currentTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current", (String[])new String[0]), true, press -> {
                currentMenu.setParentButton((AdvancedButton)press);
                currentMenu.openMenuAt(press.field_146128_h, press.field_146129_i + press.field_146121_g);
            });
            bar.addElement(currentTab, "fm.ui.tab.current", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu customGuiMenu = new FMContextMenu();
            customGuiMenu.setAutoclose(true);
            bar.addChild(customGuiMenu, "fm.ui.tab.customguis", MenuBar.ElementAlignment.LEFT);
            CustomizationButton newCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.customguis.new", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    PopupHandler.displayPopup((Popup)new CreateCustomGuiPopup());
                }
            }, Locals.localize((String)"helper.ui.customguis.new.sure", (String[])new String[0]))));
            newCustomGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.customguis.new.desc", (String[])new String[0]), (String)"%n%"));
            customGuiMenu.addContent(newCustomGuiButton);
            ManageCustomGuiContextMenu manageCustomGuiMenu = new ManageCustomGuiContextMenu();
            manageCustomGuiMenu.setAutoclose(true);
            customGuiMenu.addChild(manageCustomGuiMenu);
            CustomizationButton manageCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.customguis.manage", (String[])new String[0]), true, press -> {
                manageCustomGuiMenu.setParentButton((AdvancedButton)press);
                manageCustomGuiMenu.openMenuAt(0, press.field_146129_i);
            });
            manageCustomGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.customguis.manage.desc", (String[])new String[0]), (String)"%n%"));
            customGuiMenu.addContent(manageCustomGuiButton);
            CustomizationButton customGuiTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.customguis", (String[])new String[0]), true, press -> {
                customGuiMenu.setParentButton((AdvancedButton)press);
                customGuiMenu.openMenuAt(press.field_146128_h, press.field_146129_i + press.field_146121_g);
            });
            if (((Boolean)FancyMenu.config.getOrDefault("advancedmode", (Object)false)).booleanValue()) {
                bar.addElement(customGuiTab, "fm.ui.tab.customguis", MenuBar.ElementAlignment.LEFT, false);
            }
            FMContextMenu toolsMenu = new FMContextMenu();
            toolsMenu.setAutoclose(true);
            bar.addChild(toolsMenu, "fm.ui.tab.tools", MenuBar.ElementAlignment.LEFT);
            CustomizationButton menuInfoButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.tools.menuinfo.off", (String[])new String[0]), true, press -> {
                if (showMenuInfo) {
                    showMenuInfo = false;
                    ((AdvancedButton)press).field_146126_j = Locals.localize((String)"helper.ui.tools.menuinfo.off", (String[])new String[0]);
                } else {
                    showMenuInfo = true;
                    ((AdvancedButton)press).field_146126_j = Locals.localize((String)"helper.ui.tools.menuinfo.on", (String[])new String[0]);
                }
            });
            if (showMenuInfo) {
                menuInfoButton.field_146126_j = Locals.localize((String)"helper.ui.tools.menuinfo.on", (String[])new String[0]);
            }
            menuInfoButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.tools.menuinfo.desc", (String[])new String[0]), (String)"%n%"));
            toolsMenu.addContent(menuInfoButton);
            CustomizationButton buttonInfoButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.tools.buttoninfo.off", (String[])new String[0]), true, press -> {
                if (showButtonInfo) {
                    showButtonInfo = false;
                    ((AdvancedButton)press).field_146126_j = Locals.localize((String)"helper.ui.tools.buttoninfo.off", (String[])new String[0]);
                } else {
                    showButtonInfo = true;
                    ((AdvancedButton)press).field_146126_j = Locals.localize((String)"helper.ui.tools.buttoninfo.on", (String[])new String[0]);
                }
            });
            if (showButtonInfo) {
                buttonInfoButton.field_146126_j = Locals.localize((String)"helper.ui.tools.buttoninfo.on", (String[])new String[0]);
            }
            buttonInfoButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.tools.buttoninfo.desc", (String[])new String[0]), (String)"%n%"));
            toolsMenu.addContent(buttonInfoButton);
            CustomizationButton toolsTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.tools", (String[])new String[0]), true, press -> {
                toolsMenu.setParentButton((AdvancedButton)press);
                toolsMenu.openMenuAt(press.field_146128_h, press.field_146129_i + press.field_146121_g);
            });
            bar.addElement(toolsTab, "fm.ui.tab.tools", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu miscMenu = new FMContextMenu();
            miscMenu.setAutoclose(true);
            bar.addChild(miscMenu, "fm.ui.tab.misc", MenuBar.ElementAlignment.LEFT);
            CustomizationButton closeGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc.closegui", (String[])new String[0]), true, press -> Minecraft.func_71410_x().func_147108_a(null));
            closeGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.closegui.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(closeGuiButton);
            CustomizationButton miscTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc", (String[])new String[0]), true, press -> {
                miscMenu.setParentButton((AdvancedButton)press);
                miscMenu.openMenuAt(press.field_146128_h, press.field_146129_i + press.field_146121_g);
            });
            bar.addElement(miscTab, "fm.ui.tab.misc", MenuBar.ElementAlignment.LEFT, false);
            AdvancedImageButton closeGuiButtonTab = new AdvancedImageButton(20, 20, 20, 20, CLOSE_BUTTON_TEXTURE, true, press -> Minecraft.func_71410_x().func_147108_a(null)){

                public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                    this.field_146120_f = this.field_146121_g;
                    super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                }
            };
            closeGuiButtonTab.ignoreLeftMouseDownClickBlock = true;
            closeGuiButtonTab.ignoreBlockedInput = true;
            closeGuiButtonTab.enableRightclick = true;
            closeGuiButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.closegui.desc", (String[])new String[0]), (String)"%n%"));
            bar.addElement((AdvancedButton)closeGuiButtonTab, "fm.ui.tab.closegui", MenuBar.ElementAlignment.RIGHT, false);
            AdvancedImageButton reloadButtonTab = new AdvancedImageButton(20, 20, 20, 20, RELOAD_BUTTON_TEXTURE, true, press -> CustomizationHelper.reloadSystemAndMenu()){

                public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                    this.field_146120_f = this.field_146121_g;
                    super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                }
            };
            reloadButtonTab.ignoreLeftMouseDownClickBlock = true;
            reloadButtonTab.ignoreBlockedInput = true;
            reloadButtonTab.enableRightclick = true;
            reloadButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.reload.desc", (String[])new String[0]), (String)"%n%"));
            bar.addElement((AdvancedButton)reloadButtonTab, "fm.ui.tab.reload", MenuBar.ElementAlignment.RIGHT, false);
            AdvancedButton expandButton = bar.getElement("menubar.default.extendbtn");
            if (expandButton != null && expandButton instanceof AdvancedImageButton && !extended) {
                ((AdvancedImageButton)expandButton).setImage(MenuBar.EXPAND_BTN_TEXTURE);
                expandButton.setDescription(new String[]{Locals.localize((String)"helper.menubar.expand", (String[])new String[0])});
            }
            bar.setExtended(extended);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void render(GuiScreen screen) {
        try {
            if (bar != null && !PopupHandler.isPopupActive() && ((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue() && !(screen instanceof LayoutEditorScreen) && !(screen instanceof ConfigScreen) && !(screen instanceof GameIntroScreen) && AnimationHandler.isReady() && MenuCustomization.isValidScreen(screen)) {
                RenderUtils.setZLevelPre((int)400);
                CustomizationHelperUI.renderMenuInfo(screen);
                CustomizationHelperUI.renderUnicodeWarning(screen);
                CustomizationHelperUI.renderButtonInfo(screen);
                RenderUtils.setZLevelPost();
                bar.render(screen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void renderButtonInfo(GuiScreen screen) {
        if (showButtonInfo) {
            for (ButtonData d : buttons) {
                String key;
                if (!d.getButton().func_146115_a()) continue;
                long id = d.getId();
                String idString = Locals.localize((String)"helper.buttoninfo.idnotfound", (String[])new String[0]);
                if (id >= 0L) {
                    idString = String.valueOf(id);
                }
                if ((key = ButtonCache.getKeyForButton(d.getButton())) == null) {
                    key = Locals.localize((String)"helper.buttoninfo.keynotfound", (String[])new String[0]);
                }
                ArrayList<String> info = new ArrayList<String>();
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0])) + 10;
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.id", (String[])new String[0]) + ": " + idString);
                info.add("\u00a7f" + Locals.localize((String)"general.width", (String[])new String[0]) + ": " + d.getButton().field_146120_f);
                info.add("\u00a7f" + Locals.localize((String)"general.height", (String[])new String[0]) + ": " + d.getButton().field_146121_g);
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.labelwidth", (String[])new String[0]) + ": " + Minecraft.func_71410_x().field_71466_p.func_78256_a(d.getButton().field_146126_j));
                for (String s : info) {
                    int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                    if (i <= width) continue;
                    width = i;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)CustomizationHelperUI.getUIScale(), (float)CustomizationHelperUI.getUIScale(), (float)CustomizationHelperUI.getUIScale());
                MouseInput.setRenderScale((float)CustomizationHelperUI.getUIScale());
                int x = MouseInput.getMouseX();
                if ((float)screen.field_146294_l / CustomizationHelperUI.getUIScale() < (float)(x + width + 10)) {
                    x -= width + 10;
                }
                int y = MouseInput.getMouseY();
                if ((float)screen.field_146295_m / CustomizationHelperUI.getUIScale() < (float)(y + 80)) {
                    y -= 90;
                }
                CustomizationHelperUI.func_73734_a((int)x, (int)y, (int)(x + width + 10), (int)(y + 80), (int)new Color(102, 0, 102, 200).getRGB());
                GlStateManager.func_179147_l();
                screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, "\u00a7f\u00a7l" + Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0]), x + 10, y + 10, 0);
                int i2 = 20;
                for (String s : info) {
                    screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, s, x + 10, y + 10 + i2, 0);
                    i2 += 10;
                }
                MouseInput.resetRenderScale();
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                break;
            }
        }
    }

    protected static void renderMenuInfo(GuiScreen screen) {
        if (showMenuInfo) {
            String infoTitle = "\u00a7f\u00a7l" + Locals.localize((String)"helper.menuinfo.identifier", (String[])new String[0]) + ":";
            String id = "";
            id = screen instanceof CustomGuiBase ? ((CustomGuiBase)screen).getIdentifier() : screen.getClass().getName();
            int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(infoTitle);
            int w2 = Minecraft.func_71410_x().field_71466_p.func_78256_a(id);
            if (w2 > w) {
                w = w2;
            }
            int h = bar.getHeight() + 5;
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)CustomizationHelperUI.getUIScale(), (float)CustomizationHelperUI.getUIScale(), (float)CustomizationHelperUI.getUIScale());
            CustomizationHelperUI.func_73734_a((int)3, (int)h, (int)(3 + w + 4), (int)(h + 23), (int)new Color(0, 0, 0, 240).getRGB());
            screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, infoTitle, 5, h + 2, 0);
            if (tick == 0) {
                screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, "\u00a7f" + id, 5, h + 13, 0);
            } else {
                screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, "\u00a7a" + Locals.localize((String)"helper.menuinfo.idcopied", (String[])new String[0]), 5, h + 13, 0);
            }
            MouseInput.setRenderScale((float)CustomizationHelperUI.getUIScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            if (!bar.isChildOpen() && mouseX >= 5 && mouseX <= 5 + w2 && mouseY >= h + 13 && mouseY <= h + 13 + 10 && tick == 0) {
                CustomizationHelperUI.func_73734_a((int)5, (int)(h + 13 + 10 - 1), (int)(5 + w2), (int)(h + 13 + 10), (int)-1);
                if (MouseInput.isLeftMouseDown()) {
                    ++tick;
                    GuiScreen.func_146275_d((String)id);
                }
            }
            if (tick > 0) {
                tick = tick < 60 ? ++tick : 0;
            }
            MouseInput.resetRenderScale();
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    protected static void renderUnicodeWarning(GuiScreen screen) {
        if (Minecraft.func_71410_x().field_71474_y.field_151455_aw) {
            String[] lines;
            String title = Locals.localize((String)"helper.ui.warning", (String[])new String[0]);
            int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(title);
            for (String s : lines = StringUtils.splitLines((String)Locals.localize((String)"helper.ui.warning.unicode", (String[])new String[0]), (String)"%n%")) {
                int w2 = Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
                if (w2 <= w) continue;
                w = w2;
            }
            int x = screen.field_146294_l - w - 5;
            int y = (int)((float)(bar.getHeight() + 5) * UIBase.getUIScale());
            GlStateManager.func_179147_l();
            int h = 13;
            if (lines.length > 0) {
                h += 10 * lines.length;
            }
            CustomizationHelperUI.func_73734_a((int)(x - 4), (int)y, (int)(x + w + 2), (int)(y + h), (int)new Color(230, 15, 0, 240).getRGB());
            screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, title, x, y + 2, Color.WHITE.getRGB());
            int i = 0;
            for (String s : lines) {
                screen.func_73731_b(Minecraft.func_71410_x().field_71466_p, s, x, y + 13 + i, Color.WHITE.getRGB());
                i += 10;
            }
            GlStateManager.func_179084_k();
        }
    }

    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        buttons = e.getButtonDataList();
    }

    @SubscribeEvent
    public void onInitScreen(GuiScreenEvent.InitGuiEvent.Pre e) {
        try {
            if (e.getGui() != null && ((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue()) {
                CustomizationHelperUI.updateUI();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void onOverrideWithCustomGui(GuiScreen current, String customGuiIdentifier) {
        if (customGuiIdentifier != null && CustomGuiLoader.guiExists(customGuiIdentifier)) {
            PropertiesSection meta = new PropertiesSection("customization-meta");
            meta.addEntry("identifier", current.getClass().getName());
            PropertiesSection or = new PropertiesSection("customization");
            or.addEntry("action", "overridemenu");
            or.addEntry("identifier", customGuiIdentifier);
            PropertiesSet props = new PropertiesSet("menu");
            props.addProperties(meta);
            props.addProperties(or);
            String screenname = current.getClass().getName();
            if (screenname.contains(".")) {
                screenname = new StringBuilder(new StringBuilder(screenname).reverse().toString().split("[.]", 2)[0]).reverse().toString();
            }
            String filename = FileUtils.generateAvailableFilename((String)FancyMenu.getCustomizationPath().getPath(), (String)("overridemenu_" + screenname), (String)"txt");
            String finalpath = FancyMenu.getCustomizationPath().getPath() + "/" + filename;
            PropertiesSerializer.writeProperties((PropertiesSet)props, (String)finalpath);
            CustomizationHelper.reloadSystemAndMenu();
        }
    }

    static {
        showButtonInfo = false;
        showMenuInfo = false;
        buttons = new ArrayList<ButtonData>();
        tick = 0;
        CLOSE_BUTTON_TEXTURE = new ResourceLocation("keksuccino", "close_btn.png");
        RELOAD_BUTTON_TEXTURE = new ResourceLocation("keksuccino", "filechooser/back_icon.png");
    }

    private static class OverrideMenuContextMenu
    extends FMContextMenu {
        private OverrideMenuContextMenu() {
        }

        public void openMenuAt(int x, int y) {
            this.content.clear();
            List<String> l = CustomGuiLoader.getCustomGuis();
            if (!l.isEmpty()) {
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.pickbyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new TextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.pickbyname", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (CustomGuiLoader.guiExists(call)) {
                            CustomizationHelperUI.onOverrideWithCustomGui(Minecraft.func_71410_x().field_71462_r, call);
                        } else {
                            PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])));
                        }
                    }
                }))));
                this.addSeparator();
                for (String s : l) {
                    String label = s;
                    if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 80) {
                        label = Minecraft.func_71410_x().field_71466_p.func_78269_a(label, 75) + "..";
                    }
                    this.addContent(new CustomizationButton(0, 0, 0, 0, label, true, press -> CustomizationHelperUI.onOverrideWithCustomGui(Minecraft.func_71410_x().field_71462_r, s)));
                }
            } else {
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {}));
            }
            super.openMenuAt(x, y);
        }
    }

    private static class ManageLayoutsSubContextMenu
    extends FMContextMenu {
        private ManageLayoutsSubContextMenu() {
        }

        public void openMenuAt(int x, int y, File layout, boolean disabled) {
            this.content.clear();
            String toggleLabel = Locals.localize((String)"helper.buttons.customization.managelayouts.disable", (String[])new String[0]);
            if (disabled) {
                toggleLabel = Locals.localize((String)"helper.buttons.customization.managelayouts.enable", (String[])new String[0]);
            }
            CustomizationButton toggleLayoutBtn = new CustomizationButton(0, 0, 0, 0, toggleLabel, press -> {
                if (disabled) {
                    String name = FileUtils.generateAvailableFilename((String)FancyMenu.getCustomizationPath().getPath(), (String)Files.getNameWithoutExtension((String)layout.getName()), (String)"txt");
                    FileUtils.copyFile((File)layout, (File)new File(FancyMenu.getCustomizationPath().getPath() + "/" + name));
                    layout.delete();
                } else {
                    String disPath = FancyMenu.getCustomizationPath().getPath() + "/.disabled";
                    String name = FileUtils.generateAvailableFilename((String)disPath, (String)Files.getNameWithoutExtension((String)layout.getName()), (String)"txt");
                    FileUtils.copyFile((File)layout, (File)new File(disPath + "/" + name));
                    layout.delete();
                }
                CustomizationHelper.reloadSystemAndMenu();
            });
            this.addContent(toggleLayoutBtn);
            CustomizationButton editLayoutBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts.manage.edit", (String[])new String[0]), press -> CustomizationHelper.editLayout(Minecraft.func_71410_x().field_71462_r, layout));
            editLayoutBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.manage.edit.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(editLayoutBtn);
            CustomizationButton openInTextEditorBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.customization.managelayouts.openintexteditor", (String[])new String[0]), press -> CustomizationHelper.openFile(layout));
            openInTextEditorBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.openintexteditor.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(openInTextEditorBtn);
            CustomizationButton deleteLayoutBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.customization.managelayouts.delete", (String[])new String[0]), press -> {
                PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                    if (call.booleanValue() && layout.exists()) {
                        layout.delete();
                        CustomizationHelper.reloadSystemAndMenu();
                    }
                }, Locals.localize((String)"helper.buttons.customization.managelayouts.delete.msg", (String[])new String[0]), "", "", "", ""));
                CustomizationHelper.reloadSystemAndMenu();
            });
            this.addContent(deleteLayoutBtn);
            this.openMenuAt(x, y);
        }
    }

    private static class ManageLayoutsContextMenu
    extends FMContextMenu {
        private ManageLayoutsSubContextMenu manageSubPopup = new ManageLayoutsSubContextMenu();

        public ManageLayoutsContextMenu() {
            this.addChild(this.manageSubPopup);
        }

        public void openMenuAt(GuiButton parentBtn) {
            List<PropertiesSet> disabled;
            List<PropertiesSet> enabled;
            this.content.clear();
            String identifier = Minecraft.func_71410_x().field_71462_r.getClass().getName();
            if (Minecraft.func_71410_x().field_71462_r instanceof CustomGuiBase) {
                identifier = ((CustomGuiBase)Minecraft.func_71410_x().field_71462_r).getIdentifier();
            }
            if (!(enabled = MenuCustomizationProperties.getPropertiesWithIdentifier(identifier)).isEmpty()) {
                for (PropertiesSet s : enabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    CustomizationButton layoutEntryBtn = new CustomizationButton(0, 0, 0, 0, "\u00a7a" + name, press -> {
                        this.manageSubPopup.setParentButton((AdvancedButton)press);
                        this.manageSubPopup.openMenuAt(0, press.field_146129_i, f, false);
                    });
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"helper.buttons.customization.managelayouts.enabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (!(disabled = MenuCustomizationProperties.getDisabledPropertiesWithIdentifier(identifier)).isEmpty()) {
                for (PropertiesSet s : disabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    CustomizationButton layoutEntryBtn = new CustomizationButton(0, 0, 0, 0, "\u00a7c" + name, press -> {
                        this.manageSubPopup.setParentButton((AdvancedButton)press);
                        this.manageSubPopup.openMenuAt(0, press.field_146129_i, f, true);
                    });
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"helper.buttons.customization.managelayouts.disabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (enabled.isEmpty() && disabled.isEmpty()) {
                CustomizationButton emptyBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), press -> {});
                this.addContent(emptyBtn);
            }
            this.openMenuAt(parentBtn.field_146128_h - this.getWidth() - 2, parentBtn.field_146129_i);
        }

        public void render(int mouseX, int mouseY) {
            super.render(mouseX, mouseY);
            if (this.manageSubPopup != null) {
                this.manageSubPopup.render(mouseX, mouseY);
                if (!this.isOpen()) {
                    this.manageSubPopup.closeMenu();
                }
            }
        }

        public void closeMenu() {
            if (!this.manageSubPopup.isHovered()) {
                super.closeMenu();
            }
        }

        @Override
        public boolean isHovered() {
            if (this.manageSubPopup.isOpen() && this.manageSubPopup.isHovered()) {
                return true;
            }
            return super.isHovered();
        }
    }

    private static class ManageCustomGuiSubContextMenu
    extends FMContextMenu {
        private ManageCustomGuiSubContextMenu() {
        }

        public void openMenuAt(int x, int y, String customGuiIdentifier) {
            this.content.clear();
            CustomizationButton openMenuButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.open", (String[])new String[0]), press -> {
                if (CustomGuiLoader.guiExists(customGuiIdentifier)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)CustomGuiLoader.getGui(customGuiIdentifier, Minecraft.func_71410_x().field_71462_r, null));
                }
            });
            this.addContent(openMenuButton);
            CustomizationButton deleteMenuButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.delete", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue() && CustomGuiLoader.guiExists(customGuiIdentifier)) {
                    ArrayList<File> delete = new ArrayList<File>();
                    for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
                        File f = new File(s);
                        for (String s2 : FileUtils.getFileLines((File)f)) {
                            if (!s2.replace(" ", "").toLowerCase().equals("identifier=" + customGuiIdentifier)) continue;
                            delete.add(f);
                        }
                    }
                    for (File f : delete) {
                        if (!f.isFile()) continue;
                        f.delete();
                    }
                    CustomizationHelper.reloadSystemAndMenu();
                }
            }, Locals.localize((String)"helper.buttons.tools.customguis.sure", (String[])new String[0]))));
            this.addContent(deleteMenuButton);
            this.openMenuAt(x, y);
        }
    }

    private static class ManageCustomGuiContextMenu
    extends FMContextMenu {
        private ManageCustomGuiSubContextMenu manageMenu = new ManageCustomGuiSubContextMenu();

        public ManageCustomGuiContextMenu() {
            this.addChild(this.manageMenu);
        }

        public void openMenuAt(int x, int y) {
            this.content.clear();
            List<String> l = CustomGuiLoader.getCustomGuis();
            if (!l.isEmpty()) {
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.openbyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.openbyname", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (CustomGuiLoader.guiExists(call)) {
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)CustomGuiLoader.getGui(call, Minecraft.func_71410_x().field_71462_r, null));
                        } else {
                            PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])));
                        }
                    }
                }))));
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.deletebyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.deletebyname", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (CustomGuiLoader.guiExists(call)) {
                            PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call2 -> {
                                if (call2.booleanValue() && CustomGuiLoader.guiExists(call)) {
                                    ArrayList<File> delete = new ArrayList<File>();
                                    for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
                                        File f = new File(s);
                                        for (String s2 : FileUtils.getFileLines((File)f)) {
                                            if (!s2.replace(" ", "").toLowerCase().equals("identifier=" + call)) continue;
                                            delete.add(f);
                                        }
                                    }
                                    for (File f : delete) {
                                        if (!f.isFile()) continue;
                                        f.delete();
                                    }
                                    CustomizationHelper.reloadSystemAndMenu();
                                }
                            }, Locals.localize((String)"helper.buttons.tools.customguis.sure", (String[])new String[0])));
                        } else {
                            PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])));
                        }
                    }
                }))));
                this.addSeparator();
                for (String s : l) {
                    String label = s;
                    if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 80) {
                        label = Minecraft.func_71410_x().field_71466_p.func_78269_a(label, 75) + "..";
                    }
                    this.addContent(new CustomizationButton(0, 0, 0, 0, label, true, press -> {
                        this.manageMenu.setParentButton((AdvancedButton)press);
                        this.manageMenu.openMenuAt(0, press.field_146129_i, s);
                    }));
                }
            }
            super.openMenuAt(x, y);
        }
    }
}

