/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class WindowSizePopup
extends FMPopup {
    private ActionType type;
    private LayoutEditorScreen parent;
    private AdvancedButton cancelButton;
    private AdvancedButton doneButton;
    private AdvancedTextField widthText;
    private AdvancedTextField heightText;

    public WindowSizePopup(LayoutEditorScreen parent, ActionType type) {
        super(240);
        this.type = type;
        this.parent = parent;
        this.cancelButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> this.setDisplayed(false));
        this.addButton(this.cancelButton);
        this.doneButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.onDoneButtonPressed());
        this.addButton(this.doneButton);
        this.widthText = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        if (type == ActionType.BIGGERTHAN) {
            this.widthText.func_146180_a("" + parent.biggerThanWidth);
        } else {
            this.widthText.func_146180_a("" + parent.smallerThanWidth);
        }
        this.heightText = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        if (type == ActionType.BIGGERTHAN) {
            this.heightText.func_146180_a("" + parent.biggerThanHeight);
        } else {
            this.heightText.func_146180_a("" + parent.smallerThanHeight);
        }
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    public void render(int mouseX, int mouseY, GuiScreen renderIn) {
        super.render(mouseX, mouseY, renderIn);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (this.type == ActionType.BIGGERTHAN) {
            renderIn.func_73732_a(font, "\u00a7l" + Locals.localize((String)"helper.creator.windowsize.biggerthan.desc", (String[])new String[0]), renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 - 110, Color.WHITE.getRGB());
        } else {
            renderIn.func_73732_a(font, "\u00a7l" + Locals.localize((String)"helper.creator.windowsize.smallerthan.desc", (String[])new String[0]), renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 - 110, Color.WHITE.getRGB());
        }
        renderIn.func_73732_a(font, Locals.localize((String)"general.width", (String[])new String[0]), renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 - 80, Color.WHITE.getRGB());
        this.widthText.field_146209_f = renderIn.field_146294_l / 2 - this.widthText.func_146200_o() / 2;
        this.widthText.field_146210_g = renderIn.field_146295_m / 2 - 65;
        this.widthText.func_146194_f();
        renderIn.func_73732_a(font, Locals.localize((String)"general.height", (String[])new String[0]), renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 - 37, Color.WHITE.getRGB());
        this.heightText.field_146209_f = renderIn.field_146294_l / 2 - this.heightText.func_146200_o() / 2;
        this.heightText.field_146210_g = renderIn.field_146295_m / 2 - 22;
        this.heightText.func_146194_f();
        renderIn.func_73732_a(font, Locals.localize((String)"helper.creator.windowsize.currentwidth", (String[])new String[0]) + ": " + Minecraft.func_71410_x().field_71443_c, renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 + 15, Color.WHITE.getRGB());
        renderIn.func_73732_a(font, Locals.localize((String)"helper.creator.windowsize.currentheight", (String[])new String[0]) + ": " + Minecraft.func_71410_x().field_71440_d, renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 + 30, Color.WHITE.getRGB());
        this.doneButton.field_146128_h = renderIn.field_146294_l / 2 - this.doneButton.field_146120_f - 5;
        this.doneButton.field_146129_i = renderIn.field_146295_m / 2 + 80;
        this.cancelButton.field_146128_h = renderIn.field_146294_l / 2 + 5;
        this.cancelButton.field_146129_i = renderIn.field_146295_m / 2 + 80;
        this.renderButtons(mouseX, mouseY);
    }

    private void onDoneButtonPressed() {
        try {
            if (MathUtils.isInteger((String)this.widthText.func_146179_b()) && MathUtils.isInteger((String)this.heightText.func_146179_b())) {
                int w = Integer.parseInt(this.widthText.func_146179_b());
                int h = Integer.parseInt(this.heightText.func_146179_b());
                if (this.type == ActionType.BIGGERTHAN) {
                    if (this.parent.biggerThanWidth != w || this.parent.biggerThanHeight != h) {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    }
                    this.parent.biggerThanWidth = w;
                    this.parent.biggerThanHeight = h;
                } else {
                    if (this.parent.smallerThanWidth != w || this.parent.smallerThanHeight != h) {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    }
                    this.parent.smallerThanWidth = w;
                    this.parent.smallerThanHeight = h;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayed(false);
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 28 && this.isDisplayed() && this.doneButton != null && this.doneButton.field_146125_m) {
            this.onDoneButtonPressed();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 1 && this.isDisplayed()) {
            this.setDisplayed(false);
        }
    }

    public static enum ActionType {
        BIGGERTHAN,
        SMALLERTHAN;

    }
}

