/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class StringCustomizationItem
extends CustomizationItemBase {
    public float scale = 1.0f;
    public boolean shadow = false;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;

    public StringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtext")) {
            String al;
            String sc;
            String sh;
            this.value = item.getEntryValue("value");
            if (this.value != null) {
                this.value = !StringCustomizationItem.isEditorActive() ? DynamicValueHelper.convertFromRaw(this.value) : StringUtils.convertFormatCodes((String)this.value, (String)"&", (String)"\u00a7");
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((al = item.getEntryValue("alignment")) != null) {
                if (al.equalsIgnoreCase("right")) {
                    this.alignment = CustomizationItemBase.Alignment.RIGHT;
                }
                if (al.equalsIgnoreCase("centered")) {
                    this.alignment = CustomizationItemBase.Alignment.CENTERED;
                }
            }
        }
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        int x = this.getPosX(menu);
        int y = this.getPosY(menu);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.shadow) {
            font.func_175063_a("\u00a7f" + this.value, (float)x, (float)y, 0 | MathHelper.func_76123_f((float)(this.opacity * 255.0f)) << 24);
        } else {
            font.func_78276_b("\u00a7f" + this.value, x, y, 0 | MathHelper.func_76123_f((float)(this.opacity * 255.0f)) << 24);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    @Override
    public int getPosX(GuiScreen menu) {
        int x = super.getPosX(menu);
        if (this.value != null) {
            if (this.alignment == CustomizationItemBase.Alignment.CENTERED) {
                x -= (int)((float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(this.value) / 2) * this.scale);
            } else if (this.alignment == CustomizationItemBase.Alignment.RIGHT) {
                x -= (int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(this.value) * this.scale);
            }
        }
        x = (int)((float)x / this.scale);
        return x;
    }

    @Override
    public int getPosY(GuiScreen menu) {
        return (int)((float)super.getPosY(menu) / this.scale);
    }
}

