/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.custom;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.IOUtils;
import org.lwjgl.util.glu.Project;

public class MainMenuHandler
extends MenuHandlerBase {
    private static final ResourceLocation[] PANORAMA_RESOURCES = new ResourceLocation[]{new ResourceLocation("textures/gui/title/background/panorama_0.png"), new ResourceLocation("textures/gui/title/background/panorama_1.png"), new ResourceLocation("textures/gui/title/background/panorama_2.png"), new ResourceLocation("textures/gui/title/background/panorama_3.png"), new ResourceLocation("textures/gui/title/background/panorama_4.png"), new ResourceLocation("textures/gui/title/background/panorama_5.png")};
    private DynamicTexture viewport = new DynamicTexture(256, 256);
    private ResourceLocation background;
    private float panoramaTimer;
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURES = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation MINECRAFT_TITLE_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");
    private static final Random RANDOM = new Random();
    private String splash;

    public MainMenuHandler() {
        super(GuiMainMenu.class.getName());
    }

    @Override
    public void onMenuReloaded(MenuReloadedEvent e) {
        super.onMenuReloaded(e);
        this.splash = MainMenuHandler.getRandomSplashText();
    }

    @Override
    public void onButtonsCached(ButtonCachedEvent e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            if (this.splash == null) {
                this.splash = MainMenuHandler.getRandomSplashText();
            }
            this.background = Minecraft.func_71410_x().func_110434_K().func_110578_a("background", this.viewport);
            this.setWidthCopyrightRest(Integer.MAX_VALUE);
        }
        super.onButtonsCached(e);
    }

    @SubscribeEvent
    public void onRender(GuiScreenEvent.DrawScreenEvent.Pre e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            e.setCanceled(true);
            e.getGui().func_146276_q_();
        }
    }

    @Override
    public void drawToBackground(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (this.shouldCustomize(e.getGui())) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int width = e.getGui().field_146294_l;
            int height = e.getGui().field_146295_m;
            int j = width / 2 - 137;
            float minecraftLogoSpelling = RANDOM.nextFloat();
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            if (!this.canRenderBackground()) {
                this.panoramaTimer += Minecraft.func_71410_x().func_184121_ak();
                this.renderSkybox(mouseX, mouseY, Minecraft.func_71410_x().func_184121_ak(), e.getGui());
            }
            super.drawToBackground(e);
            if (!((Boolean)FancyMenu.config.getOrDefault("hidelogo", (Object)true)).booleanValue()) {
                GlStateManager.func_179147_l();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MINECRAFT_TITLE_TEXTURES);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((double)minecraftLogoSpelling < 1.0E-4) {
                    e.getGui().func_73729_b(j + 0, 30, 0, 0, 99, 44);
                    e.getGui().func_73729_b(j + 99, 30, 129, 0, 27, 44);
                    e.getGui().func_73729_b(j + 99 + 26, 30, 126, 0, 3, 44);
                    e.getGui().func_73729_b(j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                    e.getGui().func_73729_b(j + 155, 30, 0, 45, 155, 44);
                } else {
                    e.getGui().func_73729_b(j + 0, 30, 0, 0, 155, 44);
                    e.getGui().func_73729_b(j + 155, 30, 0, 45, 155, 44);
                }
                String version = "1.12.2";
                if (version.equals("1.12.2")) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(MINECRAFT_TITLE_EDITION);
                    GuiScreen.func_146110_a((int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (float)128.0f, (float)16.0f);
                }
                GlStateManager.func_179084_k();
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hidebranding", (Object)true)).booleanValue()) {
                List brandings = Lists.reverse((List)FMLCommonHandler.instance().getBrandings(true));
                for (int brdline = 0; brdline < brandings.size(); ++brdline) {
                    String brd = (String)brandings.get(brdline);
                    if (Strings.isNullOrEmpty((String)brd)) continue;
                    e.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, brd, 2, e.getGui().field_146295_m - (10 + brdline * (Minecraft.func_71410_x().field_71466_p.field_78288_b + 1)), 0xFFFFFF);
                }
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hideforgenotifications", (Object)false)).booleanValue()) {
                ForgeHooksClient.renderMainMenu((GuiMainMenu)((GuiMainMenu)e.getGui()), (FontRenderer)font, (int)e.getGui().field_146294_l, (int)e.getGui().field_146295_m, (String)"");
            }
            String c = "Copyright Mojang AB. Do not distribute!";
            String cPos = (String)FancyMenu.config.getOrDefault("copyrightposition", (Object)"bottom-right");
            int cX = 0;
            int cY = 0;
            int cW = Minecraft.func_71410_x().field_71466_p.func_78256_a(c);
            int cH = 10;
            if (cPos.equalsIgnoreCase("top-left")) {
                cX = 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("top-centered")) {
                cX = width / 2 - cW / 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("top-right")) {
                cX = width - cW - 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("bottom-left")) {
                cX = 2;
                cY = height - cH - 2;
            } else if (cPos.equalsIgnoreCase("bottom-centered")) {
                cX = width / 2 - cW / 2;
                cY = height - cH - 2;
            } else {
                cX = width - cW - 2;
                cY = height - cH - 2;
            }
            Color copyrightcolor = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("copyrightcolor", (Object)"#ffffff")));
            if (copyrightcolor == null) {
                copyrightcolor = new Color(255, 255, 255);
            }
            e.getGui().func_73731_b(font, c, cX, cY, copyrightcolor.getRGB() | 0xFF000000);
            if (mouseX >= cX && mouseX <= cX + cW && mouseY >= cY && mouseY <= cY + cH) {
                Gui.func_73734_a((int)cX, (int)(cY + cH - 1), (int)(cX + cW), (int)(cY + cH), (int)-1);
                if (MouseInput.isLeftMouseDown()) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWinGame(false, Runnables.doNothing()));
                }
            }
            if (!PopupHandler.isPopupActive()) {
                this.renderButtonsAndLabels(e, mouseX, mouseY);
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hiderealmsnotifications", (Object)false)).booleanValue()) {
                this.drawRealmsNotification(e.getGui());
            }
            this.renderSplash(font, e.getGui());
        }
    }

    protected void renderSplash(FontRenderer font, GuiScreen s) {
        if (!((Boolean)FancyMenu.config.getOrDefault("hidesplashtext", (Object)true)).booleanValue()) {
            float finalPosX = s.field_146294_l / 2 + 90;
            float finalPosY = 70.0f;
            int rotation = (Integer)FancyMenu.config.getOrDefault("splashrotation", (Object)-20);
            int posX = (Integer)FancyMenu.config.getOrDefault("splashx", (Object)0);
            int posY = (Integer)FancyMenu.config.getOrDefault("splashy", (Object)0);
            String orientation = (String)FancyMenu.config.getOrDefault("splashorientation", (Object)"original");
            int originX = 0;
            int originY = 0;
            boolean setpos = true;
            if (orientation.equalsIgnoreCase("original")) {
                originX = (int)finalPosX;
                originY = (int)finalPosY;
            } else if (!orientation.equalsIgnoreCase("top-left")) {
                if (orientation.equalsIgnoreCase("mid-left")) {
                    originY = s.field_146295_m / 2;
                } else if (orientation.equalsIgnoreCase("bottom-left")) {
                    originY = s.field_146295_m;
                } else if (orientation.equalsIgnoreCase("top-centered")) {
                    originX = s.field_146294_l / 2;
                } else if (orientation.equalsIgnoreCase("mid-centered")) {
                    originX = s.field_146294_l / 2;
                    originY = s.field_146295_m / 2;
                } else if (orientation.equalsIgnoreCase("bottom-centered")) {
                    originX = s.field_146294_l / 2;
                    originY = s.field_146295_m;
                } else if (orientation.equalsIgnoreCase("top-right")) {
                    originX = s.field_146294_l;
                } else if (orientation.equalsIgnoreCase("mid-right")) {
                    originX = s.field_146294_l;
                    originY = s.field_146295_m / 2;
                } else if (orientation.equalsIgnoreCase("bottom-right")) {
                    originX = s.field_146294_l;
                    originY = s.field_146295_m;
                } else {
                    setpos = false;
                }
            }
            if (setpos) {
                finalPosX = originX + posX;
                finalPosY = originY + posY;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)finalPosX, (float)finalPosY, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            float f = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            f = f * 100.0f / (float)(font.func_78256_a(this.splash) + 32);
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            Color c = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("splashcolor", (Object)"#ffff00")));
            if (c == null) {
                c = new Color(255, 255, 0);
            }
            s.func_73732_a(font, this.splash, 0, -8, c.getRGB());
            GlStateManager.func_179121_F();
        }
    }

    private void renderButtonsAndLabels(GuiScreenEvent.BackgroundDrawnEvent e, int mouseX, int mouseY) {
        List<GuiButton> buttons = this.getButtonList(e.getGui());
        List<GuiLabel> labels = this.getLabelList(e.getGui());
        float partial = Minecraft.func_71410_x().func_184121_ak();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                buttons.get(i).func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partial);
            }
        }
        if (labels != null) {
            for (int j = 0; j < labels.size(); ++j) {
                System.out.println(labels.get(j).toString());
                labels.get(j).func_146159_a(Minecraft.func_71410_x(), mouseX, mouseY);
            }
        }
    }

    private void drawRealmsNotification(GuiScreen gui) {
        if (Minecraft.func_71410_x().field_71474_y.func_74308_b(GameSettings.Options.REALMS_NOTIFICATIONS)) {
            Field f = ReflectionHelper.findField(GuiMainMenu.class, (String[])new String[]{"field_183503_M", "realmsNotification"});
            GuiScreen realms = null;
            try {
                realms = (GuiScreen)f.get(gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (realms != null) {
                realms.func_73863_a(MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_184121_ak());
            }
        }
    }

    private List<GuiButton> getButtonList(GuiScreen gui) {
        Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"field_146292_n", "buttonList"});
        ArrayList<GuiButton> buttons = new ArrayList();
        try {
            buttons = (List)f.get(gui);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttons;
    }

    private List<GuiLabel> getLabelList(GuiScreen gui) {
        Field f = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"field_146293_o", "labelList"});
        ArrayList<GuiLabel> labels = new ArrayList();
        try {
            labels = (List)f.get(gui);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labels;
    }

    private void setWidthCopyrightRest(int i) {
        try {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiMainMenu) {
                Field f = ReflectionHelper.findField(GuiMainMenu.class, (String[])new String[]{"field_193979_N", "widthCopyrightRest"});
                f.set(Minecraft.func_71410_x().field_71462_r, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawPanorama(int mouseX, int mouseY, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        for (int j = 0; j < 64; ++j) {
            GlStateManager.func_179094_E();
            float f = ((float)(j % 8) / 8.0f - 0.5f) / 64.0f;
            float f1 = ((float)(j / 8) / 8.0f - 0.5f) / 64.0f;
            GlStateManager.func_179109_b((float)f, (float)f1, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(this.panoramaTimer / 400.0f)) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.panoramaTimer * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int k = 0; k < 6; ++k) {
                GlStateManager.func_179094_E();
                if (k == 1) {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 2) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 3) {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 4) {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (k == 5) {
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(PANORAMA_RESOURCES[k]);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int l = 255 / (j + 1);
                bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                bufferbuilder.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                bufferbuilder.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
    }

    private void rotateAndBlurSkybox(GuiScreen gui) {
        if (Minecraft.func_71410_x().func_110434_K() != null && this.background != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.background);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            GlStateManager.func_187443_a((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            GlStateManager.func_179118_c();
            float zLevel = MainMenuHandler.getZlevel((Gui)gui);
            for (int j = 0; j < 3; ++j) {
                float f = 1.0f / (float)(j + 1);
                int k = gui.field_146294_l;
                int l = gui.field_146295_m;
                float f1 = (float)(j - 1) / 256.0f;
                bufferbuilder.func_181662_b((double)k, (double)l, (double)zLevel).func_187315_a((double)(0.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
                bufferbuilder.func_181662_b((double)k, 0.0, (double)zLevel).func_187315_a((double)(1.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
                bufferbuilder.func_181662_b(0.0, 0.0, (double)zLevel).func_187315_a((double)(1.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
                bufferbuilder.func_181662_b(0.0, (double)l, (double)zLevel).func_187315_a((double)(0.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179141_d();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    private void renderSkybox(int mouseX, int mouseY, float partialTicks, GuiScreen gui) {
        Minecraft.func_71410_x().func_147110_a().func_147609_e();
        GlStateManager.func_179083_b((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(mouseX, mouseY, partialTicks);
        this.rotateAndBlurSkybox(gui);
        this.rotateAndBlurSkybox(gui);
        this.rotateAndBlurSkybox(gui);
        this.rotateAndBlurSkybox(gui);
        this.rotateAndBlurSkybox(gui);
        this.rotateAndBlurSkybox(gui);
        this.rotateAndBlurSkybox(gui);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        float f = 120.0f / (float)(gui.field_146294_l > gui.field_146295_m ? gui.field_146294_l : gui.field_146295_m);
        float f1 = (float)gui.field_146295_m * f / 256.0f;
        float f2 = (float)gui.field_146294_l * f / 256.0f;
        int i = gui.field_146294_l;
        int j = gui.field_146295_m;
        float zLevel = MainMenuHandler.getZlevel((Gui)gui);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(0.0, (double)j, (double)zLevel).func_187315_a((double)(0.5f - f1), (double)(0.5f + f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)i, (double)j, (double)zLevel).func_187315_a((double)(0.5f - f1), (double)(0.5f - f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)i, 0.0, (double)zLevel).func_187315_a((double)(0.5f + f1), (double)(0.5f - f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, (double)zLevel).func_187315_a((double)(0.5f + f1), (double)(0.5f + f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    private static float getZlevel(Gui gui) {
        Field f = ReflectionHelper.findField(Gui.class, (String[])new String[]{"field_73735_i", "zLevel"});
        try {
            return f.getFloat(gui);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getRandomSplashText() {
        IResource iresource;
        String sp;
        block9: {
            List l;
            File f;
            String customSplashPath = (String)FancyMenu.config.getOrDefault("splashtextfile", (Object)"");
            if (customSplashPath != null && !customSplashPath.equals("") && (f = new File(customSplashPath)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".txt") && (l = FileUtils.getFileLines((File)f)) != null && !l.isEmpty()) {
                int random = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                return (String)l.get(random);
            }
            sp = "missingno";
            iresource = null;
            try {
                String s;
                ArrayList list = Lists.newArrayList();
                iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXTS);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8));
                while ((s = bufferedreader.readLine()) != null) {
                    if ((s = s.trim()).isEmpty()) continue;
                    list.add(s);
                }
                if (!list.isEmpty()) {
                    while ((sp = (String)list.get(RANDOM.nextInt(list.size()))).hashCode() == 125780783) {
                    }
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
                    sp = "Merry X-mas!";
                    break block9;
                }
                if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
                    sp = "Happy new year!";
                    break block9;
                }
                if (calendar.get(2) + 1 != 10 || calendar.get(5) != 31) break block9;
                sp = "OOoooOOOoooo! Spooky!";
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(iresource);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iresource);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)iresource);
        return sp;
    }
}

