/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.widget.dumps;

import codechicken.nei.widget.dumps.DataDumper;
import java.util.LinkedList;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidRegistryDumper
extends DataDumper {
    public FluidRegistryDumper() {
        super("tools.dump.fluid");
    }

    @Override
    public String[] header() {
        return new String[]{"Name", "ID", "Unlocalized Name", "Luminosity", "Density", "Temperature", "Viscosity", "Is Gas", "Rarity", "Block", "Still Texture", "Flowing Texture", "Fill Sound", "Empty Sound", "Class"};
    }

    @Override
    public Iterable<String[]> dump(int mode) {
        Map registeredFluids = FluidRegistry.getRegisteredFluids();
        Map fluidIDMap = FluidRegistry.getRegisteredFluidIDs();
        LinkedList<String[]> dumps = new LinkedList<String[]>();
        for (Map.Entry fluidEntry : registeredFluids.entrySet()) {
            Fluid fluid = (Fluid)fluidEntry.getValue();
            int id = (Integer)fluidIDMap.get(fluid);
            dumps.add(new String[]{(String)fluidEntry.getKey(), Integer.toString(id), fluid.getUnlocalizedName(), String.valueOf(fluid.getLuminosity()), String.valueOf(fluid.getDensity()), String.valueOf(fluid.getTemperature()), String.valueOf(fluid.getViscosity()), String.valueOf(fluid.isGaseous()), fluid.getRarity().toString(), fluid.canBePlacedInWorld() ? fluid.getBlock().getRegistryName().toString() : "No Block", fluid.getStill().toString(), fluid.getFlowing().toString(), fluid.getFillSound().getRegistryName().toString(), fluid.getEmptySound().getRegistryName().toString(), fluid.getClass().getCanonicalName()});
        }
        return dumps;
    }

    @Override
    public int modeCount() {
        return 1;
    }
}

