/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import de.keksuccino.konkrete.gui.content.AdvancedButtonHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class AdvancedButton
extends GuiButton {
    private boolean handleClick = false;
    private static boolean leftDown = false;
    private boolean leftDownThis = false;
    private boolean leftDownNotHovered = false;
    public boolean ignoreBlockedInput = false;
    public boolean ignoreLeftMouseDownClickBlock = false;
    public boolean enableRightclick = false;
    public float labelScale = 1.0f;
    private boolean useable = true;
    private boolean labelShadow = true;
    public float alpha = 1.0f;
    private Color idleColor;
    private Color hoveredColor;
    private Color idleBorderColor;
    private Color hoveredBorderColor;
    private float borderWidth = 2.0f;
    private ResourceLocation backgroundHover;
    private ResourceLocation backgroundNormal;
    String clicksound = null;
    String[] description = null;
    private IPressable press;

    public AdvancedButton(int x, int y, int widthIn, int heightIn, String buttonText, IPressable onPress) {
        super(MathUtils.getRandomNumberInRange(100, 999), x, y, widthIn, heightIn, buttonText);
        this.press = onPress;
    }

    public AdvancedButton(int x, int y, int widthIn, int heightIn, String buttonText, boolean handleClick, IPressable onPress) {
        super(MathUtils.getRandomNumberInRange(100, 999), x, y, widthIn, heightIn, buttonText);
        this.handleClick = handleClick;
        this.press = onPress;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GlStateManager.func_179147_l();
            if (this.hasColorBackground()) {
                Color border;
                if (!this.field_146123_n) {
                    AdvancedButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)(this.idleColor.getRGB() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
                    border = this.idleBorderColor;
                } else if (this.field_146124_l) {
                    AdvancedButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)(this.hoveredColor.getRGB() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
                    border = this.hoveredBorderColor;
                } else {
                    AdvancedButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)(this.idleColor.getRGB() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
                    border = this.idleBorderColor;
                }
                if (this.hasBorder()) {
                    RenderUtils.fill(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, (float)this.field_146129_i + this.borderWidth, border.getRGB(), this.alpha);
                    RenderUtils.fill(this.field_146128_h, (float)(this.field_146129_i + this.field_146121_g) - this.borderWidth, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, border.getRGB(), this.alpha);
                    RenderUtils.fill(this.field_146128_h, (float)this.field_146129_i + this.borderWidth, (float)this.field_146128_h + this.borderWidth, (float)(this.field_146129_i + this.field_146121_g) - this.borderWidth, border.getRGB(), this.alpha);
                    RenderUtils.fill((float)(this.field_146128_h + this.field_146120_f) - this.borderWidth, (float)this.field_146129_i + this.borderWidth, this.field_146128_h + this.field_146120_f, (float)(this.field_146129_i + this.field_146121_g) - this.borderWidth, border.getRGB(), this.alpha);
                }
            } else if (this.hasCustomTextureBackground()) {
                if (this.func_146115_a()) {
                    if (this.field_146124_l) {
                        mc.func_110434_K().func_110577_a(this.backgroundHover);
                    } else {
                        mc.func_110434_K().func_110577_a(this.backgroundNormal);
                    }
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.backgroundNormal);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                AdvancedButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)0.0f, (int)this.field_146120_f, (int)this.field_146121_g, (float)this.field_146120_f, (float)this.field_146121_g);
            } else {
                mc.func_110434_K().func_110577_a(field_146122_a);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            }
            this.func_146119_b(mc, mouseX, mouseY);
            this.renderLabel();
            if (this.func_146115_a()) {
                AdvancedButtonHandler.setActiveDescriptionButton(this);
            }
        }
        if (!this.func_146115_a() && MouseInput.isLeftMouseDown()) {
            this.leftDownNotHovered = true;
        }
        if (!MouseInput.isLeftMouseDown()) {
            this.leftDownNotHovered = false;
        }
        if (this.handleClick && this.useable) {
            if (this.func_146115_a() && (MouseInput.isLeftMouseDown() || this.enableRightclick && MouseInput.isRightMouseDown()) && (!leftDown || this.ignoreLeftMouseDownClickBlock) && !this.leftDownNotHovered && !this.isInputBlocked() && this.field_146124_l && this.field_146125_m && !this.leftDownThis) {
                this.press.onPress(this);
                this.func_146113_a(Minecraft.func_71410_x().func_147118_V());
                leftDown = true;
                this.leftDownThis = true;
            }
            if (!(MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown() && this.enableRightclick)) {
                leftDown = false;
                this.leftDownThis = false;
            }
        }
    }

    protected void renderLabel() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = font.func_78256_a(this.field_146126_j);
        int stringHeight = 8;
        int pX = (int)(((float)(this.field_146128_h + this.field_146120_f / 2) - (float)stringWidth * this.labelScale / 2.0f) / this.labelScale);
        int pY = (int)(((float)(this.field_146129_i + this.field_146121_g / 2) - (float)stringHeight * this.labelScale / 2.0f) / this.labelScale);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.labelScale, (float)this.labelScale, (float)this.labelScale);
        if (this.labelShadow) {
            font.func_175063_a(this.field_146126_j, (float)pX, (float)pY, this.getFGColor() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        } else {
            font.func_78276_b(this.field_146126_j, pX, pY, this.getFGColor() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        }
        GlStateManager.func_179121_F();
    }

    protected int getFGColor() {
        int j = 0xE0E0E0;
        if (this.packedFGColour != 0) {
            j = this.packedFGColour;
        } else if (!this.field_146124_l) {
            j = 0xA0A0A0;
        } else if (this.field_146123_n) {
            j = 0xFFFFA0;
        }
        return j;
    }

    private boolean isInputBlocked() {
        if (this.ignoreBlockedInput) {
            return false;
        }
        return MouseInput.isVanillaInputBlocked();
    }

    public void setBackgroundColor(@Nullable Color idle, @Nullable Color hovered, @Nullable Color idleBorder, @Nullable Color hoveredBorder, float borderWidth) {
        this.idleColor = idle;
        this.hoveredColor = hovered;
        this.hoveredBorderColor = hoveredBorder;
        this.idleBorderColor = idleBorder;
        if (borderWidth >= 0.0f) {
            this.borderWidth = borderWidth;
        } else {
            borderWidth = 0.0f;
        }
    }

    public void setBackgroundColor(@Nullable Color idle, @Nullable Color hovered, @Nullable Color idleBorder, @Nullable Color hoveredBorder, int borderWidth) {
        this.setBackgroundColor(idle, hovered, idleBorder, hoveredBorder, (float)borderWidth);
    }

    public void setBackgroundTexture(ResourceLocation normal, ResourceLocation hovered) {
        this.backgroundNormal = normal;
        this.backgroundHover = hovered;
    }

    public void setBackgroundTexture(ExternalTextureResourceLocation normal, ExternalTextureResourceLocation hovered) {
        if (!normal.isReady()) {
            normal.loadTexture();
        }
        if (!hovered.isReady()) {
            hovered.loadTexture();
        }
        this.backgroundHover = hovered.getResourceLocation();
        this.backgroundNormal = normal.getResourceLocation();
    }

    public boolean hasBorder() {
        return this.hasColorBackground() && this.idleBorderColor != null && this.hoveredBorderColor != null;
    }

    public boolean hasColorBackground() {
        return this.idleColor != null && this.hoveredColor != null;
    }

    public boolean hasCustomTextureBackground() {
        return this.backgroundHover != null && this.backgroundNormal != null;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (!this.handleClick && this.useable) {
            if (this.func_146115_a()) {
                this.press.onPress(this);
            }
            return super.func_146116_c(mc, mouseX, mouseY);
        }
        return false;
    }

    public void func_146113_a(net.minecraft.client.audio.SoundHandler soundHandlerIn) {
        if (this.clicksound == null) {
            super.func_146113_a(soundHandlerIn);
        } else {
            SoundHandler.resetSound(this.clicksound);
            SoundHandler.playSound(this.clicksound);
        }
    }

    public void setUseable(boolean b) {
        this.useable = b;
    }

    public boolean isUseable() {
        return this.useable;
    }

    public void setHandleClick(boolean b) {
        this.handleClick = b;
    }

    public void setPressAction(IPressable press) {
        this.press = press;
    }

    public void setClickSound(@Nullable String key) {
        this.clicksound = key;
    }

    public void setDescription(String ... desc) {
        this.description = desc;
    }

    public String[] getDescription() {
        return this.description;
    }

    public void setLabelShadow(boolean shadow) {
        this.labelShadow = shadow;
    }

    public static boolean isAnyButtonLeftClicked() {
        return leftDown;
    }

    public static interface IPressable {
        public void onPress(GuiButton var1);
    }
}

