/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.rendering;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class RenderUtils {
    private static ResourceLocation WHITE = null;
    private static ResourceLocation BLANK = null;

    public static ResourceLocation getWhiteImageResource() {
        ResourceLocation r;
        if (WHITE != null) {
            return WHITE;
        }
        if (Minecraft.func_71410_x().func_110434_K() == null) {
            return null;
        }
        BufferedImage i = new BufferedImage(1, 1, 2);
        i.setRGB(0, 0, Color.WHITE.getRGB());
        WHITE = r = Minecraft.func_71410_x().func_110434_K().func_110578_a("whiteback", new DynamicTexture(i));
        return r;
    }

    public static ResourceLocation getBlankImageResource() {
        ResourceLocation r;
        if (BLANK != null) {
            return BLANK;
        }
        if (Minecraft.func_71410_x().func_110434_K() == null) {
            return null;
        }
        BufferedImage i = new BufferedImage(1, 1, 2);
        i.setRGB(0, 0, new Color(255, 255, 255, 0).getRGB());
        BLANK = r = Minecraft.func_71410_x().func_110434_K().func_110578_a("blankback", new DynamicTexture(i));
        return r;
    }

    public static void setScale(float scale) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    public static void postScale() {
        GlStateManager.func_179121_F();
    }

    public static void doubleBlit(double x, double y, float f1, float f2, int w, int h) {
        RenderUtils.innerDoubleBlit(x, x + (double)w, y, y + (double)h, 0, (f1 + 0.0f) / (float)w, (f1 + (float)w) / (float)w, (f2 + 0.0f) / (float)h, (f2 + (float)h) / (float)h);
    }

    public static void innerDoubleBlit(double x, double xEnd, double y, double yEnd, int z, float f1, float f2, float f3, float f4) {
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tesselator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, yEnd, (double)z).func_187315_a((double)f1, (double)f4).func_181675_d();
        bufferbuilder.func_181662_b(xEnd, yEnd, (double)z).func_187315_a((double)f2, (double)f4).func_181675_d();
        bufferbuilder.func_181662_b(xEnd, y, (double)z).func_187315_a((double)f2, (double)f3).func_181675_d();
        bufferbuilder.func_181662_b(x, y, (double)z).func_187315_a((double)f1, (double)f3).func_181675_d();
        tesselator.func_78381_a();
    }

    public static Color getColorFromHexString(String hex) {
        try {
            hex = hex.replace("#", "");
            if (hex.length() == 6) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            if (hex.length() == 8) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setZLevelPre(int zLevel) {
        GlStateManager.func_179101_C();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)zLevel);
    }

    public static void setZLevelPost() {
        GlStateManager.func_179121_F();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
    }

    public static void fill(float minX, float minY, float maxX, float maxY, int color, float opacity) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        a *= opacity;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bb.func_181662_b((double)minX, (double)maxY, 0.0).func_181675_d();
        bb.func_181662_b((double)maxX, (double)maxY, 0.0).func_181675_d();
        bb.func_181662_b((double)maxX, (double)minY, 0.0).func_181675_d();
        bb.func_181662_b((double)minX, (double)minY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

