/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityTFCharmEffect
extends Entity {
    private static final DataParameter<Integer> DATA_OWNER = EntityDataManager.func_187226_a(EntityTFCharmEffect.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_ITEMID = EntityDataManager.func_187226_a(EntityTFCharmEffect.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final double DISTANCE = 1.75;
    private double interpTargetX;
    private double interpTargetY;
    private double interpTargetZ;
    private double interpTargetYaw;
    private double interpTargetPitch;
    private int newPosRotationIncrements;
    public float offset;

    public EntityTFCharmEffect(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityTFCharmEffect(World world, EntityLivingBase owner, Item item) {
        this(world);
        this.setOwner(owner);
        this.setItemID(item);
        Vec3d look = new Vec3d(1.75, 0.0, 0.0);
        this.func_70012_b(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v, owner.field_70177_z, owner.field_70125_A);
        this.field_70165_t += look.field_72450_a * 1.75;
        this.field_70161_v += look.field_72449_c * 1.75;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70071_h_() {
        EntityLivingBase orbiting;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.newPosRotationIncrements > 0) {
            double d0 = this.field_70165_t + (this.interpTargetX - this.field_70165_t) / (double)this.newPosRotationIncrements;
            double d1 = this.field_70163_u + (this.interpTargetY - this.field_70163_u) / (double)this.newPosRotationIncrements;
            double d2 = this.field_70161_v + (this.interpTargetZ - this.field_70161_v) / (double)this.newPosRotationIncrements;
            double d3 = MathHelper.func_76138_g((double)(this.interpTargetYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.newPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.interpTargetPitch - (double)this.field_70125_A) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        if ((orbiting = this.getOwner()) != null) {
            this.func_70012_b(orbiting.field_70165_t, orbiting.field_70163_u + (double)orbiting.func_70047_e(), orbiting.field_70161_v, orbiting.field_70177_z, orbiting.field_70125_A);
            float rotation = (float)this.field_70173_aa / 5.0f + this.offset;
            Vec3d look = new Vec3d(1.75, 0.0, 0.0).func_178785_b(rotation);
            this.field_70165_t += look.field_72450_a;
            this.field_70161_v += look.field_72449_c;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.getItemID() > -1) {
            for (int i = 0; i < 3; ++i) {
                double dx = this.field_70165_t + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                double dy = this.field_70163_u + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                double dz = this.field_70161_v + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, dx, dy, dz, 0.0, 0.2, 0.0, new int[]{this.getItemID()});
            }
        }
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 200 || orbiting != null && orbiting.field_70128_L)) {
            this.func_70106_y();
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_ITEMID, (Object)-1);
        this.field_70180_af.func_187214_a(DATA_OWNER, (Object)-1);
    }

    public void setOwner(EntityLivingBase owner) {
        this.field_70180_af.func_187227_b(DATA_OWNER, (Object)owner.func_145782_y());
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity e = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DATA_OWNER)).intValue());
        if (e instanceof EntityLivingBase) {
            return (EntityLivingBase)e;
        }
        return null;
    }

    public int getItemID() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_ITEMID);
    }

    public void setItemID(Item item) {
        this.field_70180_af.func_187227_b(DATA_ITEMID, (Object)Item.func_150891_b((Item)item));
    }

    protected void func_70037_a(NBTTagCompound cmp) {
    }

    protected void func_70014_b(NBTTagCompound cmp) {
    }
}

