/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFHedgeSpider;
import twilightforest.entity.EntityTFHostileWolf;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.TFMaze;

public class ComponentTFHedgeMaze
extends StructureTFComponentOld {
    private static final int MSIZE = 16;
    private static final int RADIUS = 25;
    private static final int DIAMETER = 50;
    private static final int FLOOR_LEVEL = 3;

    public ComponentTFHedgeMaze() {
    }

    public ComponentTFHedgeMaze(TFFeature feature, World world, Random rand, int i, int x, int y, int z) {
        super(feature, i);
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = StructureTFComponentOld.getComponentToAddBoundingBox(x, y, z, -25, -3, -25, 50, 10, 50, EnumFacing.SOUTH);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        TFMaze maze = new TFMaze(16, 16);
        maze.oddBias = 2;
        maze.torchBlockState = TFBlocks.firefly.func_176223_P();
        maze.wallBlockState = TFBlocks.hedge.func_176223_P();
        maze.type = 4;
        maze.tall = 3;
        maze.roots = 3;
        maze.setSeed(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * this.field_74887_e.field_78896_c));
        for (int fx = 0; fx <= 50; ++fx) {
            for (int fz = 0; fz <= 50; ++fz) {
                this.func_175811_a(world, Blocks.field_150349_c.func_176223_P(), fx, 2, fz, sbb);
            }
        }
        IBlockState northJacko = Blocks.field_150428_aP.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.NORTH);
        IBlockState southJacko = Blocks.field_150428_aP.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.SOUTH);
        IBlockState westJacko = Blocks.field_150428_aP.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.WEST);
        IBlockState eastJacko = Blocks.field_150428_aP.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.EAST);
        this.func_175811_a(world, westJacko, 0, 3, 24, sbb);
        this.func_175811_a(world, westJacko, 0, 3, 29, sbb);
        this.func_175811_a(world, eastJacko, 50, 3, 24, sbb);
        this.func_175811_a(world, eastJacko, 50, 3, 29, sbb);
        this.func_175811_a(world, northJacko, 24, 3, 0, sbb);
        this.func_175811_a(world, northJacko, 29, 3, 0, sbb);
        this.func_175811_a(world, southJacko, 24, 3, 50, sbb);
        this.func_175811_a(world, southJacko, 29, 3, 50, sbb);
        int nrooms = 5;
        int[] rcoords = new int[nrooms * 2];
        for (int i = 0; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = maze.rand.nextInt(14) + 1, rz = maze.rand.nextInt(14) + 1, rcoords)) {
            }
            maze.carveRoom1(rx, rz);
            rcoords[i * 2] = rx;
            rcoords[i * 2 + 1] = rz;
        }
        maze.generateRecursiveBacktracker(0, 0);
        maze.add4Exits();
        maze.copyToStructure(world, 1, 3, 1, this, sbb);
        this.decorate3x3Rooms(world, rcoords, sbb);
        return true;
    }

    private boolean isNearRoom(int dx, int dz, int[] rcoords) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= 3 || Math.abs(dz - rz) >= 3) continue;
            return true;
        }
        return false;
    }

    private void decorate3x3Rooms(World world, int[] rcoords, StructureBoundingBox sbb) {
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int dx = rcoords[i * 2];
            int dz = rcoords[i * 2 + 1];
            dx = dx * 3 + 3;
            dz = dz * 3 + 3;
            this.decorate3x3Room(world, dx, dz, sbb);
        }
    }

    private void decorate3x3Room(World world, int x, int z, StructureBoundingBox sbb) {
        Random roomRNG = new Random(world.func_72905_C() ^ (long)(x + z));
        this.roomJackO(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomJackO(world, roomRNG, x, z, 8, sbb);
        }
        this.roomSpawner(world, roomRNG, x, z, 8, sbb);
        this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        }
    }

    private void roomSpawner(World world, Random rand, int x, int z, int diameter, StructureBoundingBox sbb) {
        ResourceLocation mobID;
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        switch (rand.nextInt(3)) {
            case 1: {
                mobID = EntityList.func_191306_a(EntityTFSwarmSpider.class);
                break;
            }
            case 2: {
                mobID = EntityList.func_191306_a(EntityTFHostileWolf.class);
                break;
            }
            default: {
                mobID = EntityList.func_191306_a(EntityTFHedgeSpider.class);
            }
        }
        this.setSpawner(world, rx, 3, rz, sbb, mobID);
    }

    private void roomTreasure(World world, Random rand, int x, int z, int diameter, StructureBoundingBox sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        this.placeTreasureAtCurrentPosition(world, rand, rx, 3, rz, TFTreasure.hedgemaze, sbb);
    }

    private void roomJackO(World world, Random rand, int x, int z, int diameter, StructureBoundingBox sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        this.func_175811_a(world, Blocks.field_150428_aP.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)rand.nextInt(4))), rx, 3, rz, sbb);
    }
}

