/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import com.mojang.authlib.exceptions.AuthenticationException;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import org.lwjgl.input.Keyboard;
import technicianlp.reauth.ConfigGUI;
import technicianlp.reauth.GuiPasswordField;
import technicianlp.reauth.Main;
import technicianlp.reauth.Secure;
import technicianlp.reauth.VersionChecker;

final class GuiLogin
extends GuiScreen {
    private GuiTextField username;
    private GuiPasswordField pw;
    private GuiButton login;
    private GuiButton cancel;
    private GuiButton offline;
    private GuiCheckBox save;
    private GuiButton config;
    private GuiScreen prev;
    private int basey;
    private String message = "";

    GuiLogin(GuiScreen prev) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.prev = prev;
    }

    protected void func_146284_a(GuiButton b) {
        switch (b.field_146127_k) {
            case 0: {
                if (!this.login()) break;
                this.field_146297_k.func_147108_a(this.prev);
                break;
            }
            case 3: {
                if (!this.playOffline()) break;
                this.field_146297_k.func_147108_a(this.prev);
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a(this.prev);
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)new ConfigGUI(this));
            }
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Username/E-Mail:", this.field_146294_l / 2, this.basey, Color.WHITE.getRGB());
        this.func_73732_a(this.field_146289_q, "Password:", this.field_146294_l / 2, this.basey + 45, Color.WHITE.getRGB());
        if (this.message != null && !this.message.isEmpty()) {
            this.func_73732_a(this.field_146289_q, this.message, this.field_146294_l / 2, this.basey - 15, 0xFFFFFF);
        }
        this.username.func_146194_f();
        this.pw.func_146194_f();
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.username.func_146194_f();
        this.pw.func_146194_f();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.basey = this.field_146295_m / 2 - 55;
        this.username = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 155, this.basey + 15, 310, 20);
        this.username.func_146203_f(512);
        this.username.func_146180_a(Secure.username);
        this.username.func_146195_b(true);
        this.pw = new GuiPasswordField(this.field_146289_q, this.field_146294_l / 2 - 155, this.basey + 60, 310, 20);
        this.pw.setPassword(Secure.password);
        this.save = new GuiCheckBox(2, this.field_146294_l / 2 - 155, this.basey + 85, "Save Password to Config (WARNING: SECURITY RISK!)", false);
        this.field_146292_n.add(this.save);
        if (!Main.OfflineModeEnabled) {
            this.login = new GuiButton(0, this.field_146294_l / 2 - 155, this.basey + 105, 153, 20, "Login");
            this.cancel = new GuiButton(1, this.field_146294_l / 2 + 2, this.basey + 105, 155, 20, "Cancel");
            this.field_146292_n.add(this.login);
            this.field_146292_n.add(this.cancel);
        } else {
            this.login = new GuiButton(0, this.field_146294_l / 2 - 155, this.basey + 105, 100, 20, "Login");
            this.offline = new GuiButton(3, this.field_146294_l / 2 - 50, this.basey + 105, 100, 20, "Play Offline");
            this.cancel = new GuiButton(1, this.field_146294_l / 2 + 55, this.basey + 105, 100, 20, "Cancel");
            this.field_146292_n.add(this.login);
            this.field_146292_n.add(this.cancel);
            this.field_146292_n.add(this.offline);
        }
        this.config = new GuiButton(4, this.field_146294_l - 80, this.field_146295_m - 25, 75, 20, "Config");
        this.field_146292_n.add(this.config);
        if (!VersionChecker.isLatestVersion()) {
            this.message = VersionChecker.getUpdateMessage();
        }
        if (!VersionChecker.isVersionAllowed()) {
            this.message = VersionChecker.getUpdateMessage();
            this.login.field_146124_l = false;
        }
    }

    protected void func_73869_a(char c, int k) throws IOException {
        super.func_73869_a(c, k);
        this.username.func_146201_a(c, k);
        this.pw.func_146201_a(c, k);
        if (k == 15) {
            this.username.func_146195_b(!this.username.func_146206_l());
            this.pw.func_146195_b(!this.pw.func_146206_l());
        } else if (k == 28) {
            if (this.username.func_146206_l()) {
                this.username.func_146195_b(false);
                this.pw.func_146195_b(true);
            } else if (this.pw.func_146206_l()) {
                this.func_146284_a(this.login);
            }
        }
    }

    protected void func_73864_a(int x, int y, int b) throws IOException {
        super.func_73864_a(x, y, b);
        this.username.func_146192_a(x, y, b);
        this.pw.func_146192_a(x, y, b);
    }

    private boolean login() {
        try {
            Secure.login(this.username.func_146179_b(), this.pw.getPW(), this.save.isChecked());
            this.message = "\u00a7aLogin successful!";
            return true;
        }
        catch (AuthenticationException e) {
            this.message = "\u00a74Login failed: " + e.getMessage();
            Main.log.error("Login failed:", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.message = "\u00a74Error: Something went wrong!";
            Main.log.error("Error:", (Throwable)e);
            return false;
        }
    }

    private boolean playOffline() {
        String username = this.username.func_146179_b();
        if (username.length() < 2 || username.length() > 16) {
            this.message = "\u00a74Error: Username needs a length between 2 and 16";
            return false;
        }
        if (!username.matches("[A-Za-z0-9_]{2,16}")) {
            this.message = "\u00a74Error: Username has to be alphanumerical";
            return false;
        }
        try {
            Secure.offlineMode(username);
            return true;
        }
        catch (Exception e) {
            this.message = "\u00a74Error: Something went wrong!";
            Main.log.error("Error:", (Throwable)e);
            return false;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.pw.setPassword(new char[0]);
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

