/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import technicianlp.reauth.GuiHandler;
import technicianlp.reauth.Secure;

@Mod(modid="reauth", name="ReAuth", version="3.6.0", guiFactory="technicianlp.reauth.GuiFactory", canBeDeactivated=true, clientSideOnly=true, acceptedMinecraftVersions="[1.12]", certificateFingerprint="daba0ec4df71b6da841768c49fb873def208a1e3")
public final class Main {
    static final Logger log = LogManager.getLogger((String)"ReAuth");
    static Configuration config;
    static boolean OfflineModeEnabled;
    @Mod.Instance(value="reauth")
    static Main main;
    @Mod.Metadata
    static ModMetadata meta;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        File config = new File(Minecraft.func_71410_x().field_71412_D, ".ReAuth.cfg");
        if (evt.getSuggestedConfigurationFile().exists() && !config.exists()) {
            evt.getSuggestedConfigurationFile().renameTo(config);
        }
        Main.config = new Configuration(config);
        Main.loadConfig();
        Secure.init();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equals("reauth")) {
            Main.loadConfig();
        }
    }

    private static void loadConfig() {
        Property username = config.get("general", "username", "", "Your Username");
        Secure.username = username.getString();
        Property password = config.get("general", "password", "", "Your Password in plaintext if chosen to save to disk");
        Secure.password = password.getString().toCharArray();
        Property offline = config.get("general", "offlineModeEnabled", false, "Enables play-offline button");
        OfflineModeEnabled = offline.getBoolean();
        Property validator = config.get("general", "validatorEnabled", true, "Disables the Session Validator");
        GuiHandler.enabled = validator.getBoolean();
        Property bold = config.get("general", "validatorBold", true, "If the Session-Validator look weird disable this");
        GuiHandler.bold = bold.getBoolean();
        config.save();
    }

    @Mod.EventHandler
    public void securityError(FMLFingerprintViolationEvent event) {
        throw new SecurityException("The Version of ReAuth is not signed! It is a modified version!");
    }
}

