/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.component.IKeyListener;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.message.InventoryActionMessage;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public abstract class MalisisGui
extends GuiScreen {
    public static GuiTexture BLOCK_TEXTURE = new GuiTexture(TextureMap.field_110575_b);
    public static boolean cancelClose = false;
    protected GuiRenderer renderer;
    protected int displayWidth;
    protected int displayHeight;
    protected int currentGuiScale;
    protected ScaledResolution resolution;
    private UIContainer<?> screen;
    protected boolean guiscreenBackground = true;
    protected int lastMouseX;
    protected int lastMouseY;
    protected long lastClickButton = -1L;
    protected long lastClickTime = 0L;
    protected MalisisInventoryContainer inventoryContainer;
    protected boolean isOverlay = false;
    private AnimationRenderer ar;
    protected UIComponent<?> hoveredComponent;
    protected UIComponent<?> focusedComponent;
    protected UIComponent<?> draggedComponent;
    protected UIComponent<?> tooltipComponent;
    protected boolean constructed = false;
    protected Set<IKeyListener> keyListeners = new HashSet<IKeyListener>();
    protected boolean debug = false;
    private HashMap<String, Supplier<String>> debugMap = new LinkedHashMap<String, Supplier<String>>();

    protected MalisisGui() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146296_j = this.field_146297_k.func_175599_af();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.renderer = new GuiRenderer();
        this.screen = (UIContainer)new UIContainer(this).setName("Screen");
        this.ar = new AnimationRenderer();
        this.ar.autoClearAnimations();
        this.screen.setClipContent(false);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public abstract void construct();

    protected boolean doConstruct() {
        try {
            if (!this.constructed) {
                this.debugMap.clear();
                this.addDefaultDebug();
                this.construct();
                this.constructed = true;
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured while constructing " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + e.getMessage());
            MalisisCore.log.error("A problem occured while constructing " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
        }
        return this.constructed;
    }

    public GuiRenderer getRenderer() {
        return this.renderer;
    }

    public void setInventoryContainer(MalisisInventoryContainer container) {
        this.inventoryContainer = container;
    }

    public MalisisInventoryContainer getInventoryContainer() {
        return this.inventoryContainer;
    }

    public GuiTexture getGuiTexture() {
        return this.renderer.getDefaultTexture();
    }

    public long getElapsedTime() {
        return this.ar.getElapsedTime();
    }

    public final void func_146280_a(Minecraft minecraft, int width, int height) {
        this.setResolution();
    }

    public void setResolution() {
        boolean set = this.resolution == null;
        set |= this.displayWidth != Display.getWidth() || this.displayHeight != Display.getHeight();
        if (!(set |= this.currentGuiScale != this.field_146297_k.field_71474_y.field_74335_Z)) {
            return;
        }
        this.displayWidth = Display.getWidth();
        this.displayHeight = Display.getHeight();
        this.currentGuiScale = this.field_146297_k.field_71474_y.field_74335_Z;
        this.resolution = new ScaledResolution(this.field_146297_k);
        this.renderer.setScaleFactor(this.resolution.func_78325_e());
        this.field_146294_l = this.renderer.isIgnoreScale() ? this.displayWidth : this.resolution.func_78326_a();
        this.field_146295_m = this.renderer.isIgnoreScale() ? this.displayHeight : this.resolution.func_78328_b();
        this.screen.setSize(this.field_146294_l, this.field_146295_m);
    }

    public boolean isOverlay() {
        return this.isOverlay;
    }

    public void addToScreen(UIComponent<?> component) {
        this.screen.add(component);
        component.onAddedToScreen();
    }

    public void removeFromScreen(UIComponent<?> component) {
        this.screen.remove(component);
    }

    public void clearScreen() {
        this.screen.removeAll();
    }

    public void registerKeyListener(IKeyListener listener) {
        this.keyListeners.add(listener);
    }

    public void unregisterKeyListener(IKeyListener listener) {
        this.keyListeners.remove(listener);
    }

    public UIComponent<?> getComponentAt(int x, int y) {
        UIComponent<?> component = this.screen.getComponentAt(x, y);
        return component == this.screen ? null : component;
    }

    public void func_146274_d() {
        try {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (this.renderer.isIgnoreScale()) {
                mouseX = Mouse.getX();
                mouseY = this.field_146295_m - Mouse.getY() - 1;
            }
            int button = Mouse.getEventButton();
            if (Mouse.getEventButtonState()) {
                if (this.field_146297_k.field_71474_y.field_85185_A && this.field_146298_h++ > 0) {
                    return;
                }
                this.field_146287_f = button;
                this.field_146288_g = Minecraft.func_71386_F();
                this.func_73864_a(mouseX, mouseY, this.field_146287_f);
            } else if (button != -1) {
                if (this.field_146297_k.field_71474_y.field_85185_A && --this.field_146298_h > 0) {
                    return;
                }
                this.field_146287_f = -1;
                this.func_146286_b(mouseX, mouseY, button);
                this.draggedComponent = null;
            } else if (this.field_146287_f != -1 && this.field_146288_g > 0L) {
                long l = Minecraft.func_71386_F() - this.field_146288_g;
                this.func_146273_a(mouseX, mouseY, this.field_146287_f, l);
            }
            if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
                UIComponent<?> component = this.getComponentAt(mouseX, mouseY);
                if (component != null) {
                    this.tooltipComponent = component;
                    if (component.isEnabled()) {
                        component.onMouseMove(this.lastMouseX, this.lastMouseY, mouseX, mouseY);
                        component.setHovered(true);
                    }
                } else {
                    MalisisGui.setHoveredComponent(null, false);
                }
            }
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            int delta = Mouse.getEventDWheel();
            if (delta == 0) {
                return;
            }
            if (delta > 1) {
                delta = 1;
            } else if (delta < -1) {
                delta = -1;
            }
            UIComponent<?> component = this.getComponentAt(mouseX, mouseY);
            if (component != null && component.isEnabled()) {
                component.onScrollWheel(mouseX, mouseY, delta);
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        try {
            long time = System.currentTimeMillis();
            UIComponent<?> component = this.getComponentAt(x, y);
            if (component != null && component.isEnabled()) {
                boolean regularClick = true;
                if ((long)button == this.lastClickButton && time - this.lastClickTime < 250L && component == this.focusedComponent) {
                    regularClick = !component.onDoubleClick(x, y, MouseButton.getButton(button));
                    this.lastClickTime = 0L;
                }
                if (regularClick) {
                    component.onButtonPress(x, y, MouseButton.getButton(button));
                    if (this.draggedComponent == null) {
                        this.draggedComponent = component;
                    }
                }
                component.setFocused(true);
            } else {
                MalisisGui.setFocusedComponent(null, true);
                if (this.inventoryContainer != null && !this.inventoryContainer.getPickedItemStack().func_190926_b()) {
                    MalisisInventoryContainer.ActionType action = button == 1 ? MalisisInventoryContainer.ActionType.DROP_ONE : MalisisInventoryContainer.ActionType.DROP_STACK;
                    MalisisGui.sendAction(action, null, button);
                }
            }
            this.lastClickTime = time;
            this.lastClickButton = button;
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_146273_a(int x, int y, int button, long timer) {
        try {
            if (this.draggedComponent != null) {
                this.draggedComponent.onDrag(this.lastMouseX, this.lastMouseY, x, y, MouseButton.getButton(button));
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        try {
            UIComponent<?> component;
            if (this.inventoryContainer != null) {
                if (this.inventoryContainer.shouldResetDrag(button)) {
                    MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_RESET, null, 0);
                    UISlot.buttonRelased = false;
                    return;
                }
                if (this.inventoryContainer.shouldEndDrag(button)) {
                    MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_END, null, 0);
                    return;
                }
            }
            if ((component = this.getComponentAt(x, y)) != null && component.isEnabled()) {
                MouseButton mb = MouseButton.getButton(button);
                if (this.draggedComponent != null) {
                    this.draggedComponent.onButtonRelease(x, y, mb);
                }
                if (component == this.focusedComponent) {
                    if (mb == MouseButton.LEFT) {
                        component.onClick(x, y);
                    } else if (mb == MouseButton.RIGHT) {
                        component.onRightClick(x, y);
                    }
                }
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        try {
            boolean ret = false;
            for (IKeyListener listener : this.keyListeners) {
                ret |= listener.onKeyTyped(keyChar, keyCode);
            }
            if (ret) {
                return;
            }
            if (this.focusedComponent != null && !this.keyListeners.contains(this.focusedComponent) && this.focusedComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (this.hoveredComponent != null && !this.keyListeners.contains(this.hoveredComponent) && this.hoveredComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (MalisisGui.isGuiCloseKey(keyCode) && this.field_146297_k.field_71462_r == this) {
                this.close();
            }
            if (!MalisisCore.isObfEnv && MalisisGui.func_146271_m() && (MalisisGui.currentGui() != null || this.isOverlay)) {
                if (keyCode == 19) {
                    this.clearScreen();
                    this.setResolution();
                    this.construct();
                }
                if (keyCode == 32) {
                    this.debug = !this.debug;
                }
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured while handling key typed for " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.ar.animate();
        if (this.renderer.isIgnoreScale()) {
            mouseX = Mouse.getX();
            mouseY = this.field_146295_m - Mouse.getY() - 1;
        }
        this.update(mouseX, mouseY, partialTicks);
        if (this.guiscreenBackground) {
            this.func_146270_b(1);
        }
        this.renderer.drawScreen(this.screen, mouseX, mouseY, partialTicks);
        this.renderDebug(mouseX, mouseY, partialTicks);
        if (this.inventoryContainer != null) {
            ItemStack itemStack = this.inventoryContainer.getPickedItemStack();
            if (!itemStack.func_190926_b()) {
                this.renderer.renderPickedItemStack(itemStack);
            } else if (this.tooltipComponent != null) {
                this.renderer.drawTooltip(this.tooltipComponent.getTooltip());
            }
        } else if (this.tooltipComponent != null) {
            this.renderer.drawTooltip(this.tooltipComponent.getTooltip());
        }
    }

    private void addDefaultDebug() {
        this.addDebug("Focus", () -> String.valueOf(this.focusedComponent));
        this.addDebug("Hover", () -> String.valueOf(this.hoveredComponent));
        this.addDebug("Dragged", () -> String.valueOf(this.draggedComponent));
        if (this.inventoryContainer != null) {
            this.addDebug("Picked", () -> ItemUtils.toString(this.inventoryContainer.getPickedItemStack()));
        }
    }

    public void addDebug(String name, String value) {
        this.addDebug(name, () -> value);
    }

    public void addDebug(String name, Supplier<String> supplier) {
        this.debugMap.put(name, supplier);
    }

    public void removeDebug(String name) {
        this.debugMap.remove(name);
    }

    private void renderDebug(int mouseX, int mouseY, float partialTicks) {
        if (this.debug) {
            this.renderer.set(mouseX, mouseY, partialTicks);
            this.renderer.prepare(RenderType.GUI, new double[0]);
            int dy = 0;
            int oy = 5;
            FontOptions fro = FontOptions.builder().color(0xFFFFFF).shadow().build();
            this.renderer.drawText(null, "Mouse : " + mouseX + "," + mouseY, 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
            if (this.hoveredComponent != null) {
                this.renderer.drawText(null, "(" + this.hoveredComponent.relativeX(mouseX) + ", " + this.hoveredComponent.relativeY(mouseY) + ")", 100.0f, (dy - 1) * 10 + oy, 0.0f, fro, false);
            }
            for (Map.Entry<String, Supplier<String>> entry : this.debugMap.entrySet()) {
                this.renderer.drawText(null, entry.getKey() + " : " + entry.getValue().get(), 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
            }
            this.renderer.clean();
        }
    }

    public void update(int mouseX, int mouseY, float partialTick) {
    }

    public void updateGui() {
    }

    public void animate(Animation<?> animation) {
        this.animate(animation, 0);
    }

    public void animate(Animation<?> animation, int delay) {
        animation.setDelay((int)this.ar.getElapsedTicks() + delay);
        this.ar.addAnimation(animation);
    }

    public void stopAnimation(Animation<?> animation) {
        this.ar.deleteAnimation(animation);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void display() {
        this.display(false);
    }

    public void display(boolean cancelClose) {
        this.setResolution();
        if (!this.doConstruct()) {
            return;
        }
        MalisisGui.cancelClose = cancelClose;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
    }

    public void close() {
        MalisisGui.setFocusedComponent(null, true);
        MalisisGui.setHoveredComponent(null, true);
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.field_146297_k.field_71439_g != null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
    }

    public void displayOverlay() {
        this.isOverlay = true;
        this.setResolution();
        if (!this.doConstruct()) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void closeOverlay() {
        if (this.field_146297_k.field_71462_r == this) {
            this.close();
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.func_146281_b();
    }

    public void func_146281_b() {
        if (this.inventoryContainer != null) {
            this.inventoryContainer.func_75134_a((EntityPlayer)this.field_146297_k.field_71439_g);
        }
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || Minecraft.func_71410_x().field_71462_r == this) {
            return;
        }
        this.setResolution();
        this.func_73863_a(0, 0, event.getPartialTicks());
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent event) {
        if (!this.isOverlay || this.field_146297_k.field_71462_r == this) {
            return;
        }
        if (Keyboard.getEventKeyState()) {
            this.func_73869_a(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public static MalisisGui currentGui() {
        return MalisisGui.currentGui(MalisisGui.class);
    }

    public static <T extends MalisisGui> T currentGui(Class<T> type) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !(gui instanceof MalisisGui)) {
            return null;
        }
        try {
            return (T)((Object)((MalisisGui)((Object)type.cast(gui))));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static void sendAction(MalisisInventoryContainer.ActionType action, MalisisSlot slot, int code) {
        if (action == null || MalisisGui.currentGui() == null || MalisisGui.currentGui().inventoryContainer == null) {
            return;
        }
        int inventoryId = slot != null ? slot.getInventoryId() : 0;
        int slotNumber = slot != null ? slot.getSlotIndex() : 0;
        MalisisGui.currentGui().inventoryContainer.handleAction(action, inventoryId, slotNumber, code);
        InventoryActionMessage.sendAction(action, inventoryId, slotNumber, code);
    }

    public static UIComponent<?> getHoveredComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().hoveredComponent : null;
    }

    public static boolean setHoveredComponent(UIComponent<?> component, boolean hovered) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.hoveredComponent == component) {
            if (!hovered) {
                gui.hoveredComponent = null;
                return true;
            }
            return false;
        }
        if (hovered) {
            if (gui.hoveredComponent != null) {
                gui.hoveredComponent.setHovered(false);
            }
            gui.hoveredComponent = component;
        }
        if (component == null) {
            gui.hoveredComponent = null;
        }
        return true;
    }

    public static UIComponent<?> getFocusedComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().focusedComponent : null;
    }

    public static boolean setFocusedComponent(UIComponent<?> component, boolean focused) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.focusedComponent == component) {
            if (!focused) {
                gui.focusedComponent = null;
                return true;
            }
            return false;
        }
        if (focused) {
            if (gui.focusedComponent != null) {
                gui.focusedComponent.setFocused(false);
            }
            gui.focusedComponent = component;
        }
        return true;
    }

    public static void playSound(SoundEvent sound) {
        MalisisGui.playSound(sound, 1.0f);
    }

    public static void playSound(SoundEvent sound, float level) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)level));
    }

    public static boolean isGuiCloseKey(int keyCode) {
        MalisisGui gui = MalisisGui.currentGui();
        return keyCode == 1 || gui != null && gui.inventoryContainer != null && keyCode == gui.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }
}

