/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.BasicTextBox;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.component.SpaceChangeEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Face;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BasicContainer<T extends BasicContainer<T>>
extends UIContainer<T>
implements ITransformable.Color {
    private int topLeftColor = -1;
    private int topRightColor = -1;
    private int bottomLeftColor = -1;
    private int bottomRightColor = -1;
    private int topLeftAlpha = 255;
    private int topRightAlpha = 255;
    private int bottomLeftAlpha = 255;
    private int bottomRightAlpha = 255;
    private int leftBorderSize = 0;
    private int rightBorderSize = 0;
    private int topBorderSize = 0;
    private int bottomBorderSize = 0;
    private int borderColor = 0;
    private int borderAlpha = 0;
    private Consumer<SpaceChangeEvent.SizeChangeEvent> onResizeConsumer;

    public BasicContainer(MalisisGui gui) {
        super(gui);
        this.shape = new SimpleGuiShape();
    }

    public BasicContainer(MalisisGui gui, String title) {
        this(gui);
        this.setTitle(title);
    }

    public BasicContainer(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public BasicContainer(MalisisGui gui, String title, int width, int height) {
        this(gui);
        this.setTitle(title);
        this.setSize(width, height);
    }

    public BasicContainer<T> setBorder(int color, int size, int alpha) {
        return this.setBorders(color, alpha, size, size, size, size);
    }

    public BasicContainer<T> setBorders(int color, int alpha, int leftBorderSize, int topBorderSize, int rightBorderSize, int bottomBorderSize) {
        this.borderColor = color;
        this.borderAlpha = alpha;
        this.leftBorderSize = leftBorderSize;
        this.topBorderSize = topBorderSize;
        this.rightBorderSize = rightBorderSize;
        this.bottomBorderSize = bottomBorderSize;
        this.shape = leftBorderSize >= 0 || rightBorderSize >= 0 || topBorderSize >= 0 || bottomBorderSize >= 0 ? new SidedShape(leftBorderSize, topBorderSize, rightBorderSize, bottomBorderSize) : new SimpleGuiShape();
        return this;
    }

    public int getTopLeftColor() {
        return this.topLeftColor;
    }

    public BasicContainer<T> setTopLeftColor(int topLeftColor) {
        this.topLeftColor = topLeftColor;
        return this;
    }

    public int getTopRightColor() {
        return this.topRightColor;
    }

    public BasicContainer<T> setTopRightColor(int topRightColor) {
        this.topRightColor = topRightColor;
        return this;
    }

    public int getBottomLeftColor() {
        return this.bottomLeftColor;
    }

    public BasicContainer<T> setBottomLeftColor(int bottomLeftColor) {
        this.bottomLeftColor = bottomLeftColor;
        return this;
    }

    public int getBottomRightColor() {
        return this.bottomRightColor;
    }

    public BasicContainer<T> setBottomRightColor(int bottomRightColor) {
        this.bottomRightColor = bottomRightColor;
        return this;
    }

    public BasicContainer<T> setTopColor(int color) {
        this.setTopLeftColor(color);
        this.setTopRightColor(color);
        return this;
    }

    public BasicContainer<T> setBottomColor(int color) {
        this.setBottomLeftColor(color);
        this.setBottomRightColor(color);
        return this;
    }

    public BasicContainer<T> setLeftColor(int color) {
        this.setTopLeftColor(color);
        this.setBottomLeftColor(color);
        return this;
    }

    public BasicContainer<T> setRightColor(int color) {
        this.setTopRightColor(color);
        this.setBottomRightColor(color);
        return this;
    }

    @Override
    public void setColor(int color) {
        this.setTopColor(color);
        this.setBottomColor(color);
    }

    public int getTopLeftAlpha() {
        return this.topLeftAlpha;
    }

    public BasicContainer<T> setTopLeftAlpha(int topLeftAlpha) {
        this.topLeftAlpha = topLeftAlpha;
        return this;
    }

    public int getTopRightAlpha() {
        return this.topRightAlpha;
    }

    public BasicContainer<T> setTopRightAlpha(int topRightAlpha) {
        this.topRightAlpha = topRightAlpha;
        return this;
    }

    public int getBottomLeftAlpha() {
        return this.bottomLeftAlpha;
    }

    public BasicContainer<T> setBottomLeftAlpha(int bottomLeftAlpha) {
        this.bottomLeftAlpha = bottomLeftAlpha;
        return this;
    }

    public int getBottomRightAlpha() {
        return this.bottomRightAlpha;
    }

    public BasicContainer<T> setBottomRightAlpha(int bottomRightAlpha) {
        this.bottomRightAlpha = bottomRightAlpha;
        return this;
    }

    public BasicContainer<T> setTopAlpha(int alpha) {
        this.setTopLeftAlpha(alpha);
        this.setTopRightAlpha(alpha);
        return this;
    }

    public BasicContainer<T> setBottomAlpha(int alpha) {
        this.setBottomLeftAlpha(alpha);
        this.setBottomRightAlpha(alpha);
        return this;
    }

    public BasicContainer<T> setLeftAlpha(int alpha) {
        this.setTopLeftAlpha(alpha);
        this.setBottomLeftAlpha(alpha);
        return this;
    }

    public BasicContainer<T> setRightAlpha(int alpha) {
        this.setTopRightAlpha(alpha);
        this.setBottomRightAlpha(alpha);
        return this;
    }

    public BasicContainer<T> setBackgroundAlpha(int alpha) {
        this.setTopAlpha(alpha);
        this.setBottomAlpha(alpha);
        return this;
    }

    public BasicContainer<T> setPadding(int padding) {
        this.setLeftPadding(padding);
        this.setTopPadding(padding);
        this.setRightPadding(padding);
        this.setBottomPadding(padding);
        return this;
    }

    public BasicContainer<T> setPadding(int left, int top, int right, int bottom) {
        this.setLeftPadding(left);
        this.setTopPadding(top);
        this.setRightPadding(right);
        this.setBottomPadding(bottom);
        return this;
    }

    public BasicContainer<T> setWidth(int width) {
        this.setSize(width, this.height);
        return this;
    }

    public BasicContainer<T> setHeight(int height) {
        this.setSize(this.width, height);
        return this;
    }

    public int getLeftBorderSize() {
        return this.leftBorderSize;
    }

    public int getRightBorderSize() {
        return this.rightBorderSize;
    }

    public int getTopBorderSize() {
        return this.topBorderSize;
    }

    public int getBottomBorderSize() {
        return this.bottomBorderSize;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBorderAlpha() {
        return this.borderAlpha;
    }

    public Set<UIComponent<?>> getComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    public void tabToLastControl() {
        BasicTextBox currentTextbox = BasicScreen.getFocusedComponent() instanceof BasicTextBox ? (BasicTextBox)BasicScreen.getFocusedComponent() : null;
        BasicTextBox toFocus = null;
        int lastTabIndex = currentTextbox == null ? 0 : currentTextbox.getTabIndex();
        List filteredComponents = this.components.stream().filter(c -> c.isEnabled() && c.isVisible() && c instanceof BasicTextBox).map(c -> (BasicTextBox)c).filter(UITextField::isEditable).sorted(Comparator.comparingInt(BasicTextBox::getTabIndex).reversed()).collect(Collectors.toList());
        for (BasicTextBox tb : filteredComponents) {
            if (tb == currentTextbox || tb.getTabIndex() >= lastTabIndex) continue;
            toFocus = tb;
            break;
        }
        if (toFocus == null) {
            for (BasicTextBox tb : filteredComponents) {
                if (tb == currentTextbox || tb.getTabIndex() != lastTabIndex) continue;
                toFocus = tb;
                break;
            }
        }
        if (toFocus == null) {
            BasicTextBox highestIndexTextBox = currentTextbox;
            for (BasicTextBox tb : filteredComponents) {
                if (tb == currentTextbox || highestIndexTextBox != null && tb.getTabIndex() <= highestIndexTextBox.getTabIndex()) continue;
                highestIndexTextBox = tb;
            }
            if (highestIndexTextBox != null) {
                toFocus = highestIndexTextBox;
            }
        }
        if (toFocus != null && currentTextbox != null) {
            currentTextbox.deselectAll();
            toFocus.focus();
            toFocus.selectAll();
        }
    }

    public void tabToNextControl() {
        BasicTextBox currentTextbox = BasicScreen.getFocusedComponent() instanceof BasicTextBox ? (BasicTextBox)BasicScreen.getFocusedComponent() : null;
        BasicTextBox toFocus = null;
        int lastTabIndex = currentTextbox == null ? 0 : currentTextbox.getTabIndex();
        List filteredComponents = this.components.stream().filter(c -> c.isEnabled() && c.isVisible() && c instanceof BasicTextBox).map(c -> (BasicTextBox)c).filter(UITextField::isEditable).sorted(Comparator.comparingInt(BasicTextBox::getTabIndex)).collect(Collectors.toList());
        for (BasicTextBox tb : filteredComponents) {
            if (tb == currentTextbox || tb.getTabIndex() <= lastTabIndex) continue;
            toFocus = tb;
            break;
        }
        if (toFocus == null) {
            for (BasicTextBox tb : filteredComponents) {
                if (tb == currentTextbox || tb.getTabIndex() != lastTabIndex) continue;
                toFocus = tb;
                break;
            }
        }
        if (toFocus == null) {
            BasicTextBox lowestIndexTextBox = currentTextbox;
            for (BasicTextBox tb : filteredComponents) {
                if (tb == currentTextbox || lowestIndexTextBox != null && tb.getTabIndex() >= lowestIndexTextBox.getTabIndex()) continue;
                lowestIndexTextBox = tb;
            }
            if (lowestIndexTextBox != null) {
                toFocus = lowestIndexTextBox;
            }
        }
        if (toFocus != null && currentTextbox != null) {
            currentTextbox.deselectAll();
            toFocus.focus();
            toFocus.selectAll();
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.alpha == 0) {
            return;
        }
        renderer.enableBlending();
        Face f = this.shape.getFaces()[0];
        if (this.leftBorderSize > 0 || this.rightBorderSize > 0 || this.topBorderSize > 0 || this.bottomBorderSize > 0) {
            f = this.shape.getFaces()[4];
            this.rp.colorMultiplier.set(this.borderColor);
            this.rp.alpha.set(this.borderAlpha);
        }
        RenderParameters frp = f.getParameters();
        frp.usePerVertexColor.set(true);
        frp.usePerVertexAlpha.set(true);
        f.getVertexes("TopLeft").get(0).setColor(this.topLeftColor).setAlpha(this.topLeftAlpha);
        f.getVertexes("TopRight").get(0).setColor(this.topRightColor).setAlpha(this.topRightAlpha);
        f.getVertexes("BottomLeft").get(0).setColor(this.bottomLeftColor).setAlpha(this.bottomLeftAlpha);
        f.getVertexes("BottomRight").get(0).setColor(this.bottomRightColor).setAlpha(this.bottomRightAlpha);
        renderer.disableTextures();
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
        renderer.enableTextures();
    }

    public void setOnResize(Consumer<SpaceChangeEvent.SizeChangeEvent> consumer) {
        this.onResizeConsumer = consumer;
    }

    @Subscribe
    public void onResize(SpaceChangeEvent.SizeChangeEvent event) {
        if (this.onResizeConsumer == null || event.getComponent() != this) {
            return;
        }
        this.onResizeConsumer.accept(event);
    }

    private static final class SidedShape
    extends GuiShape {
        protected int left;
        protected int top;
        protected int right;
        protected int bottom;

        SidedShape(int left, int top, int right, int bottom) {
            super(9);
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.storeState();
        }

        @Override
        public void setSize(int w, int h) {
            w = Math.max(w - this.left - this.right, 0);
            h = Math.max(h - this.top - this.bottom, 0);
            this.faces[0].scale(this.left, this.top, 0.0f);
            this.faces[1].scale(w, this.top, 0.0f);
            this.faces[2].scale(this.right, this.top, 0.0f);
            this.faces[3].scale(this.left, h, 0.0f);
            this.faces[4].scale(w, h, 0.0f);
            this.faces[5].scale(this.right, h, 0.0f);
            this.faces[6].scale(this.left, this.bottom, 0.0f);
            this.faces[7].scale(w, this.bottom, 0.0f);
            this.faces[8].scale(this.right, this.bottom, 0.0f);
            this.faces[1].translate(this.left, 0.0f, 0.0f);
            this.faces[2].translate(this.left + w, 0.0f, 0.0f);
            this.faces[3].translate(0.0f, this.top, 0.0f);
            this.faces[4].translate(this.left, this.top, 0.0f);
            this.faces[5].translate(this.left + w, this.top, 0.0f);
            this.faces[6].translate(0.0f, this.top + h, 0.0f);
            this.faces[7].translate(this.left, this.top + h, 0.0f);
            this.faces[8].translate(this.left + w, this.top + h, 0.0f);
        }

        @Override
        public void scale(float x, float y) {
        }
    }
}

