/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.control.ICloseable;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;

public class UIWindow
extends UIContainer<UIWindow>
implements ICloseable {
    protected int backgroundColor = -1;

    public UIWindow(MalisisGui gui, String title, int width, int height, int anchor) {
        super(gui, title, width, height);
        this.setPadding(5, 5);
        this.anchor = anchor;
        this.shape = new XYResizableGuiShape();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(200, 0, 15, 15, 5));
    }

    public UIWindow(MalisisGui gui, String title, int width, int height) {
        this(gui, title, width, height, Anchor.CENTER | Anchor.MIDDLE);
    }

    public UIWindow(MalisisGui gui, int width, int height) {
        this(gui, null, width, height, Anchor.CENTER | Anchor.MIDDLE);
    }

    public UIWindow setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void onClose() {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui != null) {
            gui.close();
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.colorMultiplier.set(this.getBackgroundColor());
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this, 3);
    }
}

