/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import java.util.Arrays;
import net.malisis.core.renderer.icon.Icon;

public class GuiIcon
extends Icon {
    protected Icon[] icons;

    public GuiIcon(Icon icon) {
        this.icons = new Icon[]{icon};
    }

    public GuiIcon(Icon[] icons) {
        this.icons = icons;
    }

    public Icon getIcon(int index) {
        if (this.icons == null || this.icons.length == 0) {
            return null;
        }
        index %= this.icons.length;
        if (this.icons.length < 3) {
            return this.icons[index];
        }
        int row = index / 3;
        int col = index % 3;
        if (this.flippedU) {
            index = 3 * row + (2 - col);
        }
        row = index / 3;
        col = index % 3;
        if (this.flippedV) {
            index = 3 * (2 - row) + col;
        }
        return this.icons[index];
    }

    @Override
    public Icon flip(boolean horizontal, boolean vertical) {
        for (Icon icon : this.icons) {
            icon.flip(horizontal, vertical);
        }
        return super.flip(horizontal, vertical);
    }

    @Override
    public void setRotation(int rotation) {
        for (Icon icon : this.icons) {
            icon.setRotation(rotation);
        }
        super.setRotation(rotation);
    }

    @Override
    public Icon clip(float offsetXFactor, float offsetYFactor, float widthFactor, float heightFactor) {
        for (Icon icon : this.icons) {
            icon.clip(offsetXFactor, offsetYFactor, widthFactor, heightFactor);
        }
        return super.clip(offsetXFactor, offsetYFactor, widthFactor, heightFactor);
    }

    @Override
    public Icon clip(int offsetX, int offsetY, int width, int height) {
        for (Icon icon : this.icons) {
            icon.clip(offsetX, offsetY, width, height);
        }
        return super.clip(offsetX, offsetY, width, height);
    }

    public String toString() {
        return Arrays.toString((Object[])this.icons);
    }
}

