/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import java.util.HashMap;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.SidesIconProvider;
import net.malisis.core.util.MBlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MegaTextureIconProvider
extends SidesIconProvider {
    private static HashMap<EnumFacing, EnumFacing[]> searchDirs = new HashMap();
    private int[] numBlocks = new int[6];

    public MegaTextureIconProvider(Icon defaultIcon) {
        super(defaultIcon);
    }

    public void setMegaTexture(EnumFacing side, Icon icon) {
        this.setMegaTexture(side, icon, -1);
    }

    public void setMegaTexture(EnumFacing side, Icon icon, int numBlocks) {
        this.setSideIcon(side, icon);
        this.numBlocks[side.func_176745_a()] = numBlocks;
    }

    @Override
    public void setSideIcon(EnumFacing side, Icon icon) {
        super.setSideIcon(side, icon);
        this.numBlocks[side.func_176745_a()] = 0;
    }

    private boolean isMegaTexture(EnumFacing side) {
        return this.numBlocks[side.func_176745_a()] != 0;
    }

    private int getNumBlocks(Icon icon, EnumFacing side) {
        if (this.numBlocks[side.func_176745_a()] == -1) {
            int w = icon.func_94211_a();
            this.numBlocks[side.func_176745_a()] = w / 16;
        }
        return this.numBlocks[side.func_176745_a()];
    }

    @Override
    public Icon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        Icon icon = super.getIcon(world, pos, state, side);
        EnumFacing blockDir = side;
        if (IComponent.getComponent(DirectionalComponent.class, state.func_177230_c()) != null) {
            blockDir = DirectionalComponent.getDirection(state);
        }
        int numBlocks = this.getNumBlocks(icon, side);
        if (!this.isMegaTexture(side)) {
            return icon;
        }
        MBlockState baseState = this.getBaseState(world, new MBlockState(pos, state), blockDir);
        if (baseState == null) {
            return icon;
        }
        return this.getIconPart(icon, pos, baseState, blockDir, numBlocks);
    }

    private MBlockState getBaseState(IBlockAccess world, MBlockState state, EnumFacing side) {
        MBlockState baseState = state;
        MBlockState lastState = state;
        EnumFacing[] dirs = searchDirs.get(side);
        if (dirs == null) {
            return null;
        }
        block2: for (EnumFacing dir : dirs) {
            lastState = baseState;
            while (lastState.getBlock() == state.getBlock() && DirectionalComponent.getDirection(lastState.getBlockState()) == DirectionalComponent.getDirection(state.getBlockState())) {
                baseState = lastState;
                try {
                    lastState = new MBlockState(world, baseState.getPos().func_177972_a(dir));
                }
                catch (Exception e) {
                    // empty catch block
                    continue block2;
                }
            }
        }
        return baseState;
    }

    private Icon getIconPart(Icon icon, BlockPos pos, MBlockState state, EnumFacing side, int numBlocks) {
        int u = 0;
        int v = (pos.func_177956_o() - state.getY()) % numBlocks + 1;
        if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
            u = Math.abs(pos.func_177958_n() - state.getX()) % numBlocks;
        } else if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
            u = Math.abs(pos.func_177952_p() - state.getZ()) % numBlocks;
        } else {
            u = Math.abs(pos.func_177958_n() - state.getX()) % numBlocks;
            v = Math.abs(pos.func_177952_p() - state.getZ()) % numBlocks + 1;
        }
        float factor = 1.0f / (float)numBlocks;
        Icon copy = new Icon();
        copy.func_94217_a(icon);
        copy.clip((float)u * factor, 1.0f - (float)v * factor, factor, factor);
        return copy;
    }

    static {
        searchDirs.put(EnumFacing.NORTH, new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST});
        searchDirs.put(EnumFacing.SOUTH, new EnumFacing[]{EnumFacing.DOWN, EnumFacing.WEST});
        searchDirs.put(EnumFacing.EAST, new EnumFacing[]{EnumFacing.DOWN, EnumFacing.SOUTH});
        searchDirs.put(EnumFacing.WEST, new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH});
        searchDirs.put(EnumFacing.UP, new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST});
        searchDirs.put(EnumFacing.DOWN, new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST});
    }
}

