/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public abstract class WeakNested<K, V> {
    protected WeakHashMap<K, V> internalMap = new WeakHashMap();
    protected Supplier<V> factory = null;

    public WeakNested(Supplier<V> factory) {
        this.factory = factory;
    }

    protected V empty() {
        return this.factory.get();
    }

    public V get(K key) {
        return this.internalMap.get(key);
    }

    public V remove(K key) {
        return this.internalMap.remove(key);
    }

    public java.util.Set<K> keys() {
        return this.internalMap.keySet();
    }

    public void clear() {
        this.internalMap.clear();
    }

    protected V getOrCreate(K key, V defaultValue) {
        V v = this.internalMap.get(key);
        if (v != null) {
            return v;
        }
        this.internalMap.put(key, defaultValue);
        return defaultValue;
    }

    public static class Set<K, V>
    extends Collection<K, java.util.Set<V>, V> {
        public Set(Supplier<java.util.Set<V>> supplier) {
            super(supplier);
        }

        @Override
        public java.util.Set<V> get(K key) {
            java.util.Set ret = (java.util.Set)this.internalMap.get(key);
            return ret != null ? ret : ImmutableSet.of();
        }
    }

    public static class List<K, V>
    extends Collection<K, java.util.List<V>, V> {
        public List(Supplier<java.util.List<V>> supplier) {
            super(supplier);
        }

        @Override
        public java.util.List<V> get(K key) {
            java.util.List ret = (java.util.List)this.internalMap.get(key);
            return ret != null ? ret : ImmutableList.of();
        }
    }

    protected static abstract class Collection<K, U extends java.util.Collection<V>, V>
    extends WeakNested<K, U> {
        public Collection(Supplier<U> factory) {
            super(factory);
        }

        public void add(K key, V value) {
            ((java.util.Collection)this.getOrCreate(key, this.empty())).add(value);
        }

        public void addAll(K key, U values) {
            this.getOrCreate(key, values);
        }

        public void remove(K key, V value) {
            java.util.Collection l = (java.util.Collection)this.internalMap.get(key);
            if (l == null) {
                return;
            }
            l.remove(value);
            if (l.size() == 0) {
                this.remove(key);
            }
        }
    }

    public static class Map<K, U, V>
    extends WeakNested<K, java.util.Map<U, V>> {
        public Map(Supplier<java.util.Map<U, V>> supplier) {
            super(supplier);
        }

        @Override
        public java.util.Map<U, V> get(K key) {
            java.util.Map ret = (java.util.Map)this.internalMap.get(key);
            return ret != null ? ret : ImmutableMap.of();
        }

        public V get(K key, U key2) {
            return this.get((Object)key).get(key2);
        }

        public void put(K key, U key2, V value) {
            ((java.util.Map)this.getOrCreate(key, this.empty())).put(key2, value);
        }

        public void remove(K key, U key2) {
            java.util.Map h = (java.util.Map)this.internalMap.get(key);
            if (h == null) {
                return;
            }
            h.remove(key2);
            if (h.size() == 0) {
                this.remove(key);
            }
        }
    }
}

