/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.callback;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.function.BiFunction;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import org.apache.commons.lang3.tuple.Pair;

public class CallbackRegistry<C extends ICallback<V>, P extends ICallback.ICallbackPredicate, V> {
    protected List<Pair<C, ICallback.CallbackOption<P>>> callbacks = Lists.newArrayList();
    protected BiFunction<CallbackResult<V>, CallbackResult<V>, CallbackResult<V>> reduce = this::doReduce;

    private CallbackResult<V> doReduce(CallbackResult<V> r1, CallbackResult<V> r2) {
        if (r1 == CallbackResult.noResult()) {
            return r2 != null ? r2 : CallbackResult.noResult();
        }
        return r1 != null ? r1 : CallbackResult.noResult();
    }

    public void reduce(BiFunction<CallbackResult<V>, CallbackResult<V>, CallbackResult<V>> reduce) {
        this.reduce = (BiFunction)Preconditions.checkNotNull(reduce);
    }

    public void registerCallback(C callback, ICallback.CallbackOption<P> option) {
        this.callbacks.add(Pair.of(callback, option));
        this.callbacks = Ordering.natural().reverse().onResultOf(Enum::ordinal).onResultOf(ICallback.CallbackOption::getPriority).onResultOf(Pair::getRight).sortedCopy(this.callbacks);
    }

    public CallbackResult<V> processCallbacks(Object ... params) {
        if (this.callbacks.size() == 0) {
            return null;
        }
        CallbackResult<Object> result = CallbackResult.noResult();
        ICallback.Priority lastPriority = ICallback.Priority.HIGHEST;
        for (Pair<C, ICallback.CallbackOption<P>> pair : this.callbacks) {
            if (result.isCancelled() && ((ICallback.CallbackOption)pair.getRight()).getPriority() != lastPriority) {
                return result;
            }
            if (!((ICallback.CallbackOption)pair.getRight()).apply(params)) continue;
            CallbackResult tmp = ((ICallback)pair.getLeft()).call(params);
            if ((result = this.reduce.apply(result, tmp)).isForcedCancelled()) {
                return result;
            }
            lastPriority = ((ICallback.CallbackOption)pair.getRight()).getPriority();
        }
        return result;
    }
}

