/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.callback;

public class CallbackResult<U> {
    private static CallbackResult<?> NO_RESULT = CallbackResult.of(null);
    private static CallbackResult<?> RETURN_NULL = CallbackResult.builder().withReturn(true).result();
    private static CallbackResult<Boolean> RETURN_FALSE = CallbackResult.builder().value(false).withReturn(true).result();
    private static CallbackResult<Boolean> RETURN_TRUE = CallbackResult.builder().value(false).withReturn(true).result();
    private U value = null;
    private boolean shouldReturn = false;
    private boolean cancelCallbacks = false;
    private boolean forceCancel = false;

    private CallbackResult(U value, boolean shouldReturn, boolean cancelCallbacks, boolean forceCancel) {
        this.value = value;
        this.shouldReturn = shouldReturn;
        this.cancelCallbacks = cancelCallbacks;
        this.forceCancel = forceCancel;
    }

    public U getValue() {
        return this.value;
    }

    public boolean shouldReturn() {
        return this.shouldReturn;
    }

    public boolean isCancelled() {
        return this.cancelCallbacks;
    }

    public boolean isForcedCancelled() {
        return this.forceCancel;
    }

    public static <U> CallbackResult<U> of(U value) {
        return new CallbackResult<U>(value, false, false, false);
    }

    public static <U> CallbackResult<U> noResult() {
        return NO_RESULT;
    }

    public static <U> CallbackResult<U> returnNull() {
        return RETURN_NULL;
    }

    public static CallbackResult<Boolean> returnTrue() {
        return RETURN_TRUE;
    }

    public static CallbackResult<Boolean> returnFalse() {
        return RETURN_FALSE;
    }

    public static <U> CallbackResultBuilder<U> builder() {
        return new CallbackResultBuilder();
    }

    public static class CallbackResultBuilder<U> {
        private U value = null;
        private boolean shouldReturn = false;
        private boolean cancelCallbacks = false;
        private boolean forceCancel = false;

        private CallbackResultBuilder() {
        }

        public CallbackResultBuilder<U> value(U value) {
            this.value = value;
            return this;
        }

        public CallbackResultBuilder<U> withReturn(boolean shouldReturn) {
            this.shouldReturn = shouldReturn;
            return this;
        }

        public CallbackResultBuilder<U> cancel(boolean cancel) {
            this.cancelCallbacks = cancel;
            return this;
        }

        public CallbackResultBuilder<U> forceCancel(boolean forceCancel) {
            this.forceCancel = forceCancel;
            return this;
        }

        public CallbackResult<U> result() {
            return new CallbackResult(this.value, this.shouldReturn, this.cancelCallbacks, this.forceCancel);
        }
    }
}

