/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class ChunkBlockMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public ChunkBlockMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        ChunkBlockHandler.get().setCoords(message.x, message.z, message.coords);
    }

    public static void sendCoords(Chunk chunk, Set<BlockPos> coords, EntityPlayerMP player) {
        MalisisCore.network.sendTo(new Packet(chunk, coords), player);
    }

    public static class Packet
    implements IMessage {
        private int x;
        private int z;
        private Set<BlockPos> coords;

        public Packet() {
        }

        public Packet(Chunk chunk, Set<BlockPos> coords) {
            this.x = chunk.field_76635_g;
            this.z = chunk.field_76647_h;
            this.coords = coords;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.z = buf.readInt();
            this.coords = Sets.newHashSet();
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                this.coords.add(BlockPos.func_177969_a((long)buf.readLong()));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.z);
            buf.writeInt(this.coords.size());
            this.coords.forEach(p -> buf.writeLong(p.func_177986_g()));
        }
    }
}

