/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import java.util.Set;
import net.malisis.core.util.callback.CallbackRegistry;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public class ChunkCallbackRegistry<C extends IChunkCallback<V>, P extends IChunkCallbackPredicate, V>
extends CallbackRegistry<C, P, V> {
    public CallbackResult<V> processCallbacks(Chunk chunk, Object ... params) {
        Object coords = ChunkBlockHandler.get().chunks(chunk).get((Object)chunk);
        return this.processListeners((Set<BlockPos>)coords, chunk, params);
    }

    private CallbackResult<V> processListeners(Set<BlockPos> list, Chunk chunk, Object ... params) {
        CallbackResult result = CallbackResult.noResult();
        for (BlockPos listener : list) {
            CallbackResult tmp = super.processCallbacks(chunk, listener, params);
            if (!(result = (CallbackResult)this.reduce.apply(result, tmp)).isForcedCancelled()) continue;
            return result;
        }
        return result;
    }

    @FunctionalInterface
    public static interface IChunkCallbackPredicate
    extends ICallback.ICallbackPredicate {
        @Override
        default public boolean apply(Object ... params) {
            return this.apply((Chunk)params[0], (BlockPos)params[1], (Object[])params[2]);
        }

        public boolean apply(Chunk var1, BlockPos var2, Object ... var3);
    }

    public static interface IChunkCallback<V>
    extends ICallback<V> {
        @Override
        default public CallbackResult<V> call(Object ... params) {
            return this.call((Chunk)params[0], (BlockPos)params[1], (Object[])params[2]);
        }

        public CallbackResult<V> call(Chunk var1, BlockPos var2, Object ... var3);
    }
}

