/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.ModConstants;
import com.ferreusveritas.dynamictreesphc.blocks.BlockPamFruit;
import com.ferreusveritas.dynamictreesphc.blocks.BlockPamFruitPalm;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesFruit;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesPalm;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesPassionfruit;
import com.ferreusveritas.dynamictreesphc.trees.TreeCinnamon;
import com.ferreusveritas.dynamictreesphc.trees.TreeDragonfruit;
import com.ferreusveritas.dynamictreesphc.trees.TreeMaple;
import com.ferreusveritas.dynamictreesphc.trees.TreePalm;
import com.ferreusveritas.dynamictreesphc.trees.TreePaperBark;
import com.ferreusveritas.dynamictreesphc.worldgen.BiomeDataBasePopulator;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictreesphc")
public class ModTrees {
    public static boolean fruitTreeGen;
    public static ArrayList<TreeFamily> phcTrees;
    public static Map<String, Species> phcFruitSpecies;
    public static TreeFamily palmTrees;
    public static TreeFamily dragonfruitTree;
    public static TreeFamily cinnamonTree;
    public static TreeFamily mapleTree;
    public static TreeFamily paperBarkTree;
    public static Species passionfruit;

    public static void init() {
        fruitTreeGen = HarvestCraft.fruitTreeConfigManager.enableFruitTreeGeneration;
    }

    public static void preInit() {
        cinnamonTree = new TreeCinnamon();
        mapleTree = new TreeMaple();
        paperBarkTree = new TreePaperBark();
        palmTrees = new TreePalm();
        dragonfruitTree = new TreeDragonfruit();
        Collections.addAll(phcTrees, cinnamonTree, mapleTree, paperBarkTree, palmTrees, dragonfruitTree);
        cinnamonTree.registerSpecies(Species.REGISTRY);
        mapleTree.registerSpecies(Species.REGISTRY);
        paperBarkTree.registerSpecies(Species.REGISTRY);
        ISpeciesCreator fruitTreeCreator = SpeciesFruit::new;
        ISpeciesCreator palmTreeCreator = SpeciesPalm::new;
        HashMap saplingMap = new HashMap();
        saplingMap.putAll(FruitRegistry.registeringFruits);
        EnumMap<BlockPamSapling.SaplingType, TreeFamily> familyMap = new EnumMap<BlockPamSapling.SaplingType, TreeFamily>(BlockPamSapling.SaplingType.class);
        familyMap.put(BlockPamSapling.SaplingType.TEMPERATE, TreeRegistry.findSpeciesSloppy((String)"oak").getFamily());
        familyMap.put(BlockPamSapling.SaplingType.WARM, TreeRegistry.findSpeciesSloppy((String)"jungle").getFamily());
        familyMap.put(BlockPamSapling.SaplingType.COLD, TreeRegistry.findSpeciesSloppy((String)"spruce").getFamily());
        HashMap<String, ISpeciesCreator> creatorMap = new HashMap<String, ISpeciesCreator>();
        FruitRegistry.registeringFruits.forEach((species, sapling) -> {
            if (ModConstants.PALMS.contains(species)) {
                creatorMap.put((String)species, palmTreeCreator);
            } else {
                creatorMap.put((String)species, fruitTreeCreator);
            }
        });
        ModTrees.alterCreatorMap(creatorMap);
        for (Map.Entry entry : creatorMap.entrySet()) {
            ILeavesProperties leavesProperties;
            String fruitName = (String)entry.getKey();
            ISpeciesCreator creator = (ISpeciesCreator)entry.getValue();
            BlockPamSapling.SaplingType saplingType = (BlockPamSapling.SaplingType)saplingMap.get(fruitName);
            if (fruitName.equals("dragonfruit")) {
                phcFruitSpecies.put(fruitName, dragonfruitTree.getCommonSpecies());
                dragonfruitTree.registerSpecies(Species.REGISTRY);
                continue;
            }
            ResourceLocation resLoc = new ResourceLocation("dynamictreesphc", fruitName);
            TreeFamily family = ModConstants.PALMS.contains(fruitName) ? palmTrees : (TreeFamily)familyMap.get(saplingType);
            Species species2 = creator.createSpecies(resLoc, family, leavesProperties = ModConstants.PALMS.contains(fruitName) ? (ILeavesProperties)ModBlocks.palmLeavesProperties.get(fruitName) : family.getCommonSpecies().getLeavesProperties(), fruitName, saplingType);
            if (!species2.isValid()) continue;
            if (family.getCommonSpecies() == Species.NULLSPECIES) {
                family.setCommonSpecies(species2);
            }
            phcFruitSpecies.put(fruitName, species2);
            Species.REGISTRY.register((IForgeRegistryEntry)species2);
        }
        passionfruit = new SpeciesPassionfruit((TreeFamily)familyMap.get(BlockPamSapling.SaplingType.WARM));
        Species.REGISTRY.register((IForgeRegistryEntry)passionfruit);
        for (Map.Entry<Object, Object> entry : phcFruitSpecies.entrySet()) {
            if (ModConstants.NOFRUIT.contains(entry.getKey())) continue;
            BlockPamFruit fruit = ModConstants.SIDEDFRUIT.contains(entry.getKey()) ? new BlockPamFruitPalm(new ResourceLocation("dynamictreesphc", (String)entry.getKey())) : new BlockPamFruit(new ResourceLocation("dynamictreesphc", (String)entry.getKey()));
            ModBlocks.fruits.put((String)entry.getKey(), fruit);
            if (ModConstants.FRUITDROPSSEED.contains(entry.getKey())) {
                fruit.setDroppedItem(((Species)entry.getValue()).getSeedStack(1));
            } else {
                fruit.setDroppedItem(new ItemStack(FruitRegistry.getFood((String)((String)entry.getKey()))));
            }
            Species species3 = (Species)entry.getValue();
            fruit.setSpecies(species3);
            if (!(species3 instanceof SpeciesFruit)) continue;
            ((SpeciesFruit)species3).setFruitBlock(fruit);
        }
        for (Map.Entry<Object, Object> entry : phcFruitSpecies.entrySet()) {
            TreeRegistry.registerSaplingReplacer((IBlockState)FruitRegistry.getSapling((String)((String)entry.getKey())).func_176223_P(), (Species)((Species)entry.getValue()));
        }
    }

    private static void alterCreatorMap(Map<String, ISpeciesCreator> creatorMap) {
        creatorMap.remove("apple");
        creatorMap.remove("passionfruit");
        creatorMap.put("peppercorn", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(0.2f, 6.0f, 1, 3, 1.0f, 3);
            }
        });
        creatorMap.put("gooseberry", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(0.2f, 6.0f, 1, 3, 1.0f, 3);
            }
        });
        creatorMap.put("banana", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesPalm(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(0.8f, 5.0f, 1, 4, 0.6f, 5);
            }
        });
        creatorMap.put("date", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesPalm(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(1.0f, 12.0f, 1, 4, 0.3f, 7);
            }
        });
        creatorMap.put("walnut", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(0.4f, 12.0f, 1, 4, 0.7f, 8);
            }

            public boolean isThick() {
                return true;
            }

            public int maxBranchRadius() {
                return 24;
            }
        });
        creatorMap.put("chestnut", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(0.45f, 11.0f, 1, 4, 0.6f, 8);
            }

            public boolean isThick() {
                return true;
            }

            public int maxBranchRadius() {
                return 24;
            }
        });
        creatorMap.put("pecan", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults(String name) {
                this.setBasicGrowingParameters(0.45f, 11.0f, 1, 4, 0.6f, 8);
            }

            public boolean isThick() {
                return true;
            }

            public int maxBranchRadius() {
                return 24;
            }
        });
    }

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        if (fruitTreeGen) {
            event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
        }
    }

    static {
        phcTrees = new ArrayList();
        phcFruitSpecies = new HashMap<String, Species>();
    }

    protected static interface ISpeciesCreator {
        public Species createSpecies(ResourceLocation var1, TreeFamily var2, ILeavesProperties var3, String var4, BlockPamSapling.SaplingType var5);
    }
}

