/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictreesphc.blocks.BlockBranchPamSpecial;
import com.ferreusveritas.dynamictreesphc.trees.TreePaperBark;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockBranchPamPaper
extends BlockBranchPamSpecial {
    protected final double barkRegrowChance = 0.05;
    protected final double barkRegrowOutOfSeasonChance = 0.02;
    protected final int minStripRadius = 7;

    public BlockBranchPamPaper(String name, String logName, float yieldPerLog, boolean tick) {
        super(name, logName, yieldPerLog);
        this.func_149675_a(tick);
    }

    public double getBarkRegrowChance(World world, BlockPos pos) {
        Float season = SeasonHelper.getSeasonValue((World)world, (BlockPos)pos);
        if (season == null || SeasonHelper.isSeasonBetween((float)season.floatValue(), (float)2.0f, (float)3.0f)) {
            return Math.max(Math.min(0.05, 1.0), 0.0);
        }
        return Math.max(Math.min(0.02, 1.0), 0.0);
    }

    public int getMinStripRadius() {
        return Math.max(Math.min(7, 8), 1);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (state.func_177230_c() == TreePaperBark.paperbarkCutBranch && (double)worldIn.field_73012_v.nextFloat() <= this.getBarkRegrowChance(worldIn, pos)) {
            worldIn.func_175656_a(pos, TreePaperBark.paperbarkBranch.func_176223_P().func_177226_a((IProperty)RADIUS, state.func_177229_b((IProperty)RADIUS)));
        }
        super.func_180645_a(worldIn, pos, state, random);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof ItemAxe && state.func_177230_c() == TreePaperBark.paperbarkBranch && (Integer)state.func_177229_b((IProperty)RADIUS) >= this.getMinStripRadius()) {
            playerIn.func_191521_c(new ItemStack(Items.field_151121_aF, 1 + (int)(worldIn.field_73012_v.nextFloat() * 3.0f)));
            playerIn.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)playerIn);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187929_hc, SoundCategory.BLOCKS, 0.2f, 1.5f + worldIn.field_73012_v.nextFloat(), false);
            worldIn.func_175656_a(pos, TreePaperBark.paperbarkCutBranch.func_176223_P().func_177226_a((IProperty)RADIUS, state.func_177229_b((IProperty)RADIUS)));
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public int getRadius(IBlockState state) {
        if (state.func_177230_c() == TreePaperBark.paperbarkCutBranch && (Integer)state.func_177229_b((IProperty)RADIUS) >= this.getMinStripRadius()) {
            return super.getRadius(state) - 1;
        }
        return super.getRadius(state);
    }
}

