/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicLeavesPalm
extends BlockDynamicLeaves {
    public static final CoordUtils.Surround[][] hydroSurroundMap = new CoordUtils.Surround[][]{new CoordUtils.Surround[0], {CoordUtils.Surround.NE, CoordUtils.Surround.SE, CoordUtils.Surround.SW, CoordUtils.Surround.NW}, {CoordUtils.Surround.N, CoordUtils.Surround.E, CoordUtils.Surround.S, CoordUtils.Surround.W}, new CoordUtils.Surround[0], new CoordUtils.Surround[0]};
    public static final IUnlistedProperty<Boolean>[] CONNECTIONS = new Properties.PropertyAdapter[CoordUtils.Surround.values().length];

    public BlockDynamicLeavesPalm(String name) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(4)));
        this.setRegistryName("dynamictreesphc", name);
        this.func_149663_c(name);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{HYDRO, TREE}, CONNECTIONS);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (state.func_177230_c() == this && this.getProperties(state) == ModBlocks.dragonfruitLeavesProperties) {
            return SoundType.field_185854_g;
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (state.func_177230_c() == this && this.getProperties(state) == ModBlocks.dragonfruitLeavesProperties) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (ModConfigs.canopyCrash && entity instanceof EntityLivingBase) {
            entity.field_70143_R -= 1.0f;
            AxisAlignedBB aabb = entity.func_174813_aQ();
            int minX = MathHelper.func_76128_c((double)(aabb.field_72340_a + 0.001));
            int minZ = MathHelper.func_76128_c((double)(aabb.field_72339_c + 0.001));
            int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d - 0.001));
            int maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f - 0.001));
            boolean crushing = true;
            boolean hasLeaves = true;
            SoundType stepSound = this.getSoundType(world.func_180495_p(pos), world, pos, entity);
            float volume = MathHelper.func_76131_a((float)(stepSound.func_185843_a() / 16.0f * fallDistance), (float)0.0f, (float)3.0f);
            world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stepSound.func_185845_c(), SoundCategory.BLOCKS, volume, stepSound.func_185847_b(), false);
            int iy = 0;
            while (entity.field_70143_R > 3.0f && crushing && pos.func_177956_o() - iy > 0) {
                if (hasLeaves) {
                    entity.field_70143_R *= 0.66f;
                    hasLeaves = false;
                }
                for (int ix = minX; ix <= maxX; ++ix) {
                    for (int iz = minZ; iz <= maxZ; ++iz) {
                        BlockPos iPos = new BlockPos(ix, pos.func_177956_o() - iy, iz);
                        IBlockState state = world.func_180495_p(iPos);
                        if (TreeHelper.isLeaves((IBlockState)state)) {
                            hasLeaves = true;
                            DynamicTrees.proxy.crushLeavesBlock(world, iPos, state, entity);
                            world.func_175698_g(iPos);
                            continue;
                        }
                        if (world.func_175623_d(iPos)) continue;
                        crushing = false;
                    }
                }
                ++iy;
            }
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            for (CoordUtils.Surround surr : hydroSurroundMap[(Integer)state.func_177229_b((IProperty)BlockDynamicLeaves.HYDRO)]) {
                IBlockState scanState = access.func_180495_p(pos.func_177971_a(surr.getOffset()));
                if (scanState.func_177230_c() != this || (Integer)scanState.func_177229_b((IProperty)BlockDynamicLeaves.HYDRO) != 3) continue;
                extState = extState.withProperty(CONNECTIONS[surr.ordinal()], (Object)true);
            }
            return extState;
        }
        return state;
    }

    public int getRadiusForConnection(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return side == EnumFacing.UP && from.getFamily().isCompatibleDynamicLeaves(blockState, blockAccess, pos) ? fromRadius : 0;
    }

    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return branch.getFamily() == this.getFamily(blockState, blockAccess, pos) ? BlockBranch.setSupport((int)0, (int)1) : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB base = super.func_185496_a(state, source, pos);
        base.func_72321_a(1.0, 0.0, 1.0);
        base.func_72321_a(-1.0, 0.0, -1.0);
        return base;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    static {
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            BlockDynamicLeavesPalm.CONNECTIONS[surr.ordinal()] = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)("conn_" + surr.toString())));
        }
    }
}

