/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictreesphc.ModConfigs;
import com.ferreusveritas.dynamictreesphc.ModConstants;
import com.ferreusveritas.dynamictreesphc.ModItems;
import com.ferreusveritas.dynamictreesphc.ModSounds;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPamFruit
extends BlockFruit {
    public static final DamageSource FALLING_COCONUT = new DamageSource("fallingFruitCoconut");
    public static final DamageSource FALLING_DURIAN = new DamageSource("fallingFruitDurian");
    public static final DamageSource FALLING_JACKFRUIT = new DamageSource("fallingFruitJackfruit");
    public static final DamageSource FALLING_BREADFRUIT = new DamageSource("fallingFruitBreadfruit");
    protected final String fruitName;
    public static double randomFruitFallChance = ModConfigs.fallingFruitFallChance;
    private static final float distanceFromPlayerToFall = ModConfigs.fallingFruitDistanceFromPlayer;
    private static final double pepperRipenChance = (double)0.01f;

    public BlockPamFruit(ResourceLocation name) {
        super(new ResourceLocation(name.func_110624_b(), "fruit" + name.func_110623_a()).toString());
        this.fruitName = name.func_110623_a();
    }

    private double getPepperRipenChance(World world, BlockPos pos) {
        return (double)0.01f * (double)SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)ModConstants.fruitOffset.get("peppercorn").floatValue());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 2 && this.fruitName.equals("peppercorn")) {
            drops.add((Object)this.getFruitDrop());
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 3) {
            ItemStack toDrop = this.fruitName.equals("peppercorn") ? new ItemStack((Item)ModItems.ripePeppercorn) : this.getFruitDrop();
            if (world instanceof World) {
                if (this.fruitName.equals("banana")) {
                    toDrop.func_190920_e(1 + ((World)world).field_73012_v.nextInt(4));
                }
                if (this.fruitName.equals("pistachio") || this.fruitName.equals("starfruit")) {
                    toDrop.func_190920_e(1 + ((World)world).field_73012_v.nextInt(3));
                }
            }
            if (!toDrop.func_190926_b()) {
                drops.add((Object)toDrop);
            }
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        if (this.fruitName.equals("dragonfruit") || this.fruitName.equals("banana")) {
            return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLeaves || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLeaves;
        }
        return super.canBlockStay(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (ModConstants.FALLINGFRUIT.contains(this.fruitName) && (Integer)state.func_177229_b((IProperty)AGE) == 3) {
            if (!this.canBlockStay(worldIn, pos, state)) {
                this.blockFall(worldIn, pos, state);
            }
        } else {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 3 || (Integer)state.func_177229_b((IProperty)AGE) == 2 && this.fruitName.equals("peppercorn")) {
            this.dropBlock(worldIn, pos, state);
            return true;
        }
        return false;
    }

    private void dropBlock(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.func_176226_b(worldIn, pos, state, 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (ModConstants.FALLINGFRUIT.contains(this.fruitName) && (Integer)state.func_177229_b((IProperty)AGE) == 3 && (double)world.field_73012_v.nextFloat() <= randomFruitFallChance) {
            this.blockFall(world, pos, state);
        } else if (!this.fruitName.equals("peppercorn") || (Integer)state.func_177229_b((IProperty)AGE) != 2 || !((double)world.field_73012_v.nextFloat() >= this.getPepperRipenChance(world, pos))) {
            super.func_180650_b(world, pos, state, rand);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.fruitName.equals("peppercorn") && (Integer)state.func_177229_b((IProperty)AGE) == 3) {
            return new ItemStack((Item)ModItems.ripePeppercorn);
        }
        return this.getFruitDrop();
    }

    private void blockFall(World worldIn, BlockPos pos, final IBlockState state) {
        if (distanceFromPlayerToFall == 0.0f) {
            return;
        }
        if (distanceFromPlayerToFall != -1.0f && worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)distanceFromPlayerToFall, false) == null) {
            return;
        }
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0 && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32)) && !worldIn.field_72995_K) {
            EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state){

                public void func_70071_h_() {
                    Block block = state.func_177230_c();
                    if (state.func_185904_a() == Material.field_151579_a) {
                        this.func_70106_y();
                    } else {
                        this.field_70169_q = this.field_70165_t;
                        this.field_70167_r = this.field_70163_u;
                        this.field_70166_s = this.field_70161_v;
                        if (this.field_145812_b++ == 0) {
                            BlockPos blockpos = new BlockPos((Entity)this);
                            if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == block) {
                                this.field_70170_p.func_175698_g(blockpos);
                            } else if (!this.field_70170_p.field_72995_K) {
                                this.func_70106_y();
                                return;
                            }
                        }
                        if (!this.func_189652_ae()) {
                            this.field_70181_x -= 0.04;
                        }
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        if (!this.field_70170_p.field_72995_K) {
                            BlockPos blockpos1 = new BlockPos((Entity)this);
                            if (!this.field_70122_E) {
                                if (this.field_145812_b > 100 && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.field_145812_b > 600) {
                                    if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                                        ItemStack fruit = ((BlockPamFruit)block).droppedFruit;
                                        fruit.func_190920_e(1);
                                        this.func_70099_a(fruit, 0.0f);
                                    }
                                    this.func_70106_y();
                                }
                            } else {
                                if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - 0.01, this.field_70161_v)) && BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.01, this.field_70161_v)))) {
                                    this.field_70122_E = false;
                                    return;
                                }
                                this.field_70159_w *= 0.67;
                                this.field_70179_y *= 0.67;
                                this.field_70181_x *= -0.5;
                                ItemStack fruit = ((BlockPamFruit)block).droppedFruit;
                                fruit.func_190920_e(1);
                                this.func_70099_a(fruit, 0.0f);
                                this.func_70106_y();
                                return;
                            }
                        }
                        this.field_70159_w *= 0.98;
                        this.field_70181_x *= 0.98;
                        this.field_70179_y *= 0.98;
                    }
                }

                public void func_180430_e(float distance, float damageMultiplier) {
                    int i = MathHelper.func_76123_f((float)(distance - 1.0f));
                    if (i > 0) {
                        DamageSource source;
                        switch (BlockPamFruit.this.fruitName) {
                            case "coconut": {
                                source = FALLING_COCONUT;
                                break;
                            }
                            case "durian": {
                                source = FALLING_DURIAN;
                                break;
                            }
                            case "jackfruit": {
                                source = FALLING_JACKFRUIT;
                                break;
                            }
                            case "breadfruit": {
                                source = FALLING_BREADFRUIT;
                                break;
                            }
                            default: {
                                source = DamageSource.field_82729_p;
                            }
                        }
                        ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
                        for (Entity entity : list) {
                            if (!(entity instanceof EntityLivingBase)) continue;
                            entity.func_70097_a(source, (float)Math.min(MathHelper.func_76128_c((double)((double)i * 1.2)), 10));
                            entity.func_130014_f_().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.BLOCK_FRUIT_BONK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                }
            };
            worldIn.func_72838_d((Entity)entityfallingblock);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.fruitName.equals("spiderweb")) {
            AxisAlignedBB blockBox = this.func_185496_a(state, (IBlockAccess)worldIn, pos);
            if (blockBox == null) {
                return;
            }
            for (Entity entity : worldIn.func_72872_a(EntityPlayer.class, blockBox.func_186670_a(pos))) {
                entity.func_70110_aj();
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.fruitName.equals("spiderweb") || this.fruitName.equals("date")) {
            return field_185506_k;
        }
        if (this.fruitName.equals("banana")) {
            switch ((Integer)state.func_177229_b((IProperty)AGE)) {
                case 1: {
                    return ModConstants.fruitBoxes.BANANA[1];
                }
                case 2: {
                    return ModConstants.fruitBoxes.BANANA[1].func_72317_d(0.0, -0.5, 0.0);
                }
                case 0: 
                case 3: {
                    return field_185506_k;
                }
            }
            throw new IllegalArgumentException();
        }
        return super.func_180646_a(state, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        switch (this.fruitName) {
            case "almond": 
            case "starfruit": 
            case "lemon": 
            case "lime": 
            case "fig": 
            case "pawpaw": {
                return ModConstants.fruitBoxes.FRUIT_THIN[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "apricot": 
            case "guava": 
            case "pomegranate": 
            case "persimmon": {
                return ModConstants.fruitBoxes.FRUIT_SMALL[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "avocado": 
            case "pear": {
                return ModConstants.fruitBoxes.FRUIT_LONG[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "gooseberry": 
            case "lychee": 
            case "olive": {
                return ModConstants.fruitBoxes.FRUIT_BERRY[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "banana": {
                return ModConstants.fruitBoxes.BANANA[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "cashew": {
                return ModConstants.fruitBoxes.CASHEW[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "breadfruit": {
                return ModConstants.fruitBoxes.BREADFRUIT[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "dragonfruit": {
                return ModConstants.fruitBoxes.DRAGONFRUIT[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "durian": {
                return ModConstants.fruitBoxes.DURIAN[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "grapefruit": {
                return ModConstants.fruitBoxes.GRAPEFRUIT[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "hazelnut": {
                return ModConstants.fruitBoxes.HAZELNUT[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "jackfruit": {
                return ModConstants.fruitBoxes.JACKFRUIT[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "peppercorn": {
                return ModConstants.fruitBoxes.PEPPERCORN[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "mango": {
                return ModConstants.fruitBoxes.MANGO[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "cherry": {
                return ModConstants.fruitBoxes.CHERRY[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "pistachio": {
                return ModConstants.fruitBoxes.PISTACHIO[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "rambutan": {
                return ModConstants.fruitBoxes.RAMBUTAN[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "soursop": {
                return ModConstants.fruitBoxes.SOURSOP[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "spiderweb": {
                return ModConstants.fruitBoxes.SPIDERWEB[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "tamarind": {
                return ModConstants.fruitBoxes.TAMARIND[(Integer)state.func_177229_b((IProperty)AGE)];
            }
            case "vanillabean": {
                return ModConstants.fruitBoxes.VANILLABEAN[(Integer)state.func_177229_b((IProperty)AGE)];
            }
        }
        return super.func_185496_a(state, access, pos);
    }
}

