/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModConstants;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesFruit
extends Species {
    public final String fruitName;
    public final BlockPamSapling.SaplingType saplingType;
    public IBlockState fruitBlockState;
    protected int fruitingRadius = 5;
    private boolean isSeasonal = true;

    public SpeciesFruit(ResourceLocation name, TreeFamily treeFamily, ILeavesProperties leavesProperties, String fruitName, BlockPamSapling.SaplingType saplingType) {
        super(name, treeFamily, leavesProperties);
        this.fruitName = fruitName;
        this.saplingType = saplingType;
        this.fruitTreeDefaults(fruitName);
        this.setRequiresTileEntity(true);
        Float fruitingOffset = ModConstants.fruitOffset.get(fruitName);
        if (fruitingOffset == null) {
            this.isSeasonal = false;
        } else {
            this.setFlowerSeasonHold(fruitingOffset.floatValue() - 0.5f, fruitingOffset.floatValue() + 0.5f);
        }
        switch (saplingType) {
            default: {
                this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
                this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
                break;
            }
            case COLD: {
                this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
                break;
            }
            case WARM: {
                this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            }
        }
        this.generateSeed();
    }

    public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
        return this.isSeasonal && SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
    }

    public void setFruitBlock(BlockFruit fruitBlock) {
        this.fruitBlockState = fruitBlock.func_176223_P();
        this.addGenFeature((IGenFeature)new FeatureGenFruit(fruitBlock).setRayDistance(4.0f).setFruitingRadius(this.fruitingRadius));
        this.addDropCreator((IDropCreator)new DropCreatorSeed(){

            public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                float rarity = this.getHarvestRarity();
                rarity *= (float)(fortune + 1) / 128.0f;
                if ((rarity = (float)((double)rarity * Math.min((double)(species.seasonalSeedDropFactor(world, leafPos) + 0.15f), 1.0))) > random.nextFloat()) {
                    dropList.add(this.getFruit(species));
                }
                return dropList;
            }

            private ItemStack getFruit(Species species) {
                if (SpeciesFruit.this.fruitName.equals("spiderweb")) {
                    return species.getSeedStack(1);
                }
                return new ItemStack(FruitRegistry.getFood((String)SpeciesFruit.this.fruitName));
            }

            public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                int chance = 40;
                if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                    chance = 10;
                }
                float seasonFactor = 1.0f;
                if (access instanceof World) {
                    World world = (World)access;
                    if (!world.field_72995_K) {
                        seasonFactor = species.seasonalSeedDropFactor(world, breakPos);
                    }
                }
                if (random.nextInt((int)((float)chance / this.getLeavesRarity())) == 0 && seasonFactor > random.nextFloat()) {
                    dropList.add(this.getFruit(species));
                }
                return dropList;
            }
        });
    }

    public ResourceLocation getSaplingName() {
        String dtModId = "dynamictrees";
        switch (this.saplingType) {
            default: {
                return new ResourceLocation(dtModId, "oak");
            }
            case COLD: {
                return new ResourceLocation(dtModId, "spruce");
            }
            case WARM: 
        }
        return new ResourceLocation(dtModId, "jungle");
    }

    public float seasonalFruitProductionFactor(World world, BlockPos pos) {
        Float offset = ModConstants.fruitOffset.get(this.fruitName);
        if (offset == null) {
            return 1.0f;
        }
        return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset.floatValue());
    }

    protected void fruitTreeDefaults(String name) {
        this.setBasicGrowingParameters(0.3f, 8.0f, 1, 4, 1.0f, this.fruitingRadius);
    }

    protected SpeciesFruit setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate, int fruitingRadius) {
        this.setBasicGrowingParameters(tapering, energy, upProbability, lowestBranchHeight, growthRate);
        this.fruitingRadius = fruitingRadius;
        return this;
    }

    public BlockFruit getFruitBlock() {
        return (BlockFruit)this.fruitBlockState.func_177230_c();
    }

    public void addJoCodes() {
        this.joCodeStore.addCodesFromFile((Species)this, "assets/" + this.getRegistryName().func_110624_b() + "/trees/fruit.txt");
    }
}

