/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.blocks.BlockPamFruitPalm;
import com.ferreusveritas.dynamictreesphc.dropcreators.FeatureGenFruitPalm;
import com.ferreusveritas.dynamictreesphc.dropcreators.FeatureGenSuckers;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesFruit;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class SpeciesPalm
extends SpeciesFruit {
    public SpeciesPalm(ResourceLocation name, TreeFamily treeFamily, ILeavesProperties leavesProperties, String fruitName, BlockPamSapling.SaplingType saplingType) {
        super(name, treeFamily, leavesProperties, fruitName, saplingType);
        if (fruitName.equals("banana")) {
            this.addGenFeature((IGenFeature)new FeatureGenSuckers(ModBlocks.bananaSucker));
        }
    }

    protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
        EnumFacing originDir = signal.dir.func_176734_d();
        probMap[0] = 0;
        probMap[1] = 10;
        probMap[5] = 0;
        probMap[4] = 0;
        probMap[3] = 0;
        probMap[2] = 0;
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public float getEnergy(World world, BlockPos pos) {
        long day = world.func_72820_D() / 24000L;
        int month = (int)day / 30;
        return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 3);
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean natural) {
        IBlockState trunkBlockState = world.func_180495_p(treePos);
        BlockBranch branch = TreeHelper.getBranch((IBlockState)trunkBlockState);
        NodeFindEnds endFinder = new NodeFindEnds();
        MapSignal signal = new MapSignal(new INodeInspector[]{endFinder});
        branch.analyse(trunkBlockState, world, treePos, EnumFacing.DOWN, signal);
        List endPoints = endFinder.getEnds();
        for (BlockPos endPoint : endPoints) {
            TreeHelper.ageVolume((World)world, (BlockPos)endPoint, (int)2, (int)3, (int)3, (SafeChunkBounds)SafeChunkBounds.ANY);
        }
        int radius = branch.getRadius(world.func_180495_p(treePos.func_177984_a()));
        if (radius != 0) {
            branch.setRadius(world, treePos, radius + 1, null);
        }
        return super.postGrow(world, rootPos, treePos, soilLife, natural);
    }

    public boolean transitionToTree(World world, BlockPos pos) {
        TreeFamily family = this.getFamily();
        if (world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
            family.getDynamicBranch().setRadius(world, pos, (int)family.getPrimaryThickness(), null);
            world.func_175656_a(pos.func_177984_a(), this.getLeavesProperties().getDynamicLeavesState());
            world.func_175656_a(pos.func_177981_b(2), this.getLeavesProperties().getDynamicLeavesState().func_177226_a((IProperty)BlockDynamicLeaves.HYDRO, (Comparable)Integer.valueOf(3)));
            this.placeRootyDirtBlock(world, pos.func_177977_b(), 15);
            return true;
        }
        return false;
    }

    public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        for (BlockPos endPoint : endPoints) {
            TreeHelper.ageVolume((World)world, (BlockPos)endPoint, (int)1, (int)2, (int)3, (SafeChunkBounds)safeBounds);
        }
        super.postGeneration(world, rootPos, biome, radius, endPoints, safeBounds, initialDirtState);
    }

    public int maxBranchRadius() {
        return 6;
    }

    @Override
    public void setFruitBlock(BlockFruit fruitBlock) {
        this.fruitBlockState = fruitBlock.func_176223_P();
        int growHeightOptions = 1;
        if (this.fruitName.equals("papaya")) {
            growHeightOptions = 2;
        }
        FeatureGenFruitPalm fruitFeatureGen = this.fruitName.equals("banana") ? new FeatureGenFruitPalm(fruitBlock, growHeightOptions, fruitBlock instanceof BlockPamFruitPalm, true) : new FeatureGenFruitPalm(fruitBlock, growHeightOptions, fruitBlock instanceof BlockPamFruitPalm);
        fruitFeatureGen.setFruitingRadius(this.fruitingRadius);
        this.addGenFeature((IGenFeature)fruitFeatureGen);
        this.addDropCreator((IDropCreator)new DropCreatorSeed(){

            public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                float rarity = this.getHarvestRarity();
                rarity *= (float)(fortune + 1) / 16.0f;
                if ((rarity = (float)((double)rarity * Math.min((double)(species.seasonalSeedDropFactor(world, leafPos) + 0.15f), 1.0))) > random.nextFloat()) {
                    dropList.add(this.getFruit(species));
                }
                return dropList;
            }

            private ItemStack getFruit(Species species) {
                if (SpeciesPalm.this.fruitName.equals("coconut")) {
                    return species.getSeedStack(1);
                }
                return new ItemStack(FruitRegistry.getFood((String)SpeciesPalm.this.fruitName));
            }

            public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                int chance = 20;
                if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                    chance = 10;
                }
                float seasonFactor = 1.0f;
                if (access instanceof World) {
                    World world = (World)access;
                    if (!world.field_72995_K) {
                        seasonFactor = species.seasonalSeedDropFactor(world, breakPos);
                    }
                }
                if (random.nextInt((int)((float)chance / this.getLeavesRarity())) == 0 && seasonFactor > random.nextFloat()) {
                    dropList.add(this.getFruit(species));
                }
                return dropList;
            }
        });
    }

    @Override
    protected void fruitTreeDefaults(String name) {
        this.setBasicGrowingParameters(0.4f, 8.0f, 1, 4, 0.3f, 5);
    }

    @Override
    public void addJoCodes() {
        this.joCodeStore.addCodesFromFile((Species)this, "assets/" + this.getRegistryName().func_110624_b() + "/trees/palm.txt");
    }
}

