/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import logisticspipes.LPBlocks;
import logisticspipes.LPItems;
import logisticspipes.LogisticsEventListener;
import logisticspipes.asm.LogisticsPipesClassInjector;
import logisticspipes.asm.LogisticsPipesCoreLoader;
import logisticspipes.asm.wrapper.LogisticsWrapperHandler;
import logisticspipes.blocks.BlockDummy;
import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSolidBlock;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.blocks.powertile.LogisticsIC2PowerProviderTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.blocks.powertile.LogisticsRFPowerProviderTileEntity;
import logisticspipes.blocks.stats.LogisticsStatisticsTileEntity;
import logisticspipes.commands.LogisticsPipesCommand;
import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.config.Configs;
import logisticspipes.datafixer.LPDataFixer;
import logisticspipes.items.ItemBlankModule;
import logisticspipes.items.ItemDisk;
import logisticspipes.items.ItemHUDArmor;
import logisticspipes.items.ItemLogisticsChips;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.items.ItemLogisticsProgrammer;
import logisticspipes.items.ItemModule;
import logisticspipes.items.ItemParts;
import logisticspipes.items.ItemPipeController;
import logisticspipes.items.ItemPipeManager;
import logisticspipes.items.ItemPipeSignCreator;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.items.LogisticsBrokenItem;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.items.LogisticsItemCard;
import logisticspipes.items.LogisticsSolidBlockItem;
import logisticspipes.items.RemoteOrderer;
import logisticspipes.logistics.LogisticsFluidManager;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.network.GuiHandler;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.PipeFluidBasic;
import logisticspipes.pipes.PipeFluidExtractor;
import logisticspipes.pipes.PipeFluidInsertion;
import logisticspipes.pipes.PipeFluidProvider;
import logisticspipes.pipes.PipeFluidRequestLogistics;
import logisticspipes.pipes.PipeFluidSatellite;
import logisticspipes.pipes.PipeFluidSupplierMk2;
import logisticspipes.pipes.PipeItemsBasicLogistics;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.PipeItemsFluidSupplier;
import logisticspipes.pipes.PipeItemsInvSysConnector;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.pipes.PipeItemsRemoteOrdererLogistics;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.PipeItemsRequestLogisticsMk2;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.PipeItemsSupplierLogistics;
import logisticspipes.pipes.PipeItemsSystemDestinationLogistics;
import logisticspipes.pipes.PipeItemsSystemEntranceLogistics;
import logisticspipes.pipes.PipeLogisticsChassisMk1;
import logisticspipes.pipes.PipeLogisticsChassisMk2;
import logisticspipes.pipes.PipeLogisticsChassisMk3;
import logisticspipes.pipes.PipeLogisticsChassisMk4;
import logisticspipes.pipes.PipeLogisticsChassisMk5;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericSubMultiBlock;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.pipes.tubes.HSTubeCurve;
import logisticspipes.pipes.tubes.HSTubeGain;
import logisticspipes.pipes.tubes.HSTubeLine;
import logisticspipes.pipes.tubes.HSTubeSCurve;
import logisticspipes.pipes.tubes.HSTubeSpeedup;
import logisticspipes.pipes.unrouted.PipeItemsBasicTransport;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.ProxyManager;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.SpecialInventoryHandlerManager;
import logisticspipes.proxy.SpecialTankHandlerManager;
import logisticspipes.proxy.computers.objects.LPGlobalCCAccess;
import logisticspipes.proxy.endercore.EnderCoreProgressProvider;
import logisticspipes.proxy.ic2.IC2ProgressProvider;
import logisticspipes.proxy.progressprovider.MachineProgressProvider;
import logisticspipes.proxy.recipeproviders.LogisticsCraftingTable;
import logisticspipes.proxy.specialconnection.EnderIOTransceiverConnection;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.proxy.specialconnection.SpecialTileConnection;
import logisticspipes.proxy.specialtankhandler.SpecialTankHandler;
import logisticspipes.proxy.te.ThermalExpansionProgressProvider;
import logisticspipes.recipes.CraftingRecipes;
import logisticspipes.recipes.LPChipRecipes;
import logisticspipes.recipes.ModuleChippedCraftingRecipes;
import logisticspipes.recipes.PipeChippedCraftingRecipes;
import logisticspipes.recipes.RecipeManager;
import logisticspipes.recipes.UpgradeChippedCraftingRecipes;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.LogisticsNewSolidBlockWorldRenderer;
import logisticspipes.renderer.newpipe.tube.CurveTubeRenderer;
import logisticspipes.renderer.newpipe.tube.GainTubeRenderer;
import logisticspipes.renderer.newpipe.tube.LineTubeRenderer;
import logisticspipes.renderer.newpipe.tube.SCurveTubeRenderer;
import logisticspipes.renderer.newpipe.tube.SpeedupTubeRenderer;
import logisticspipes.routing.RouterManager;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.channels.ChannelManagerProvider;
import logisticspipes.routing.pathfinder.PipeInformationManager;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.ClientPacketBufferHandlerThread;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.ticks.LPTickHandler;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.ticks.RenderTickHandler;
import logisticspipes.ticks.RoutingTableUpdateThread;
import logisticspipes.ticks.ServerPacketBufferHandlerThread;
import logisticspipes.ticks.VersionChecker;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.InventoryUtilFactory;
import logisticspipes.utils.RoutedItemHelper;
import logisticspipes.utils.StaticResolverUtil;
import logisticspipes.utils.TankUtilFactory;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import network.rs485.grow.ServerTickDispatcher;
import network.rs485.logisticspipes.compat.TheOneProbeIntegration;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.config.ServerConfigurationManager;
import network.rs485.logisticspipes.gui.LPFontRenderer;
import network.rs485.logisticspipes.gui.PropertyUpdaterEventListener;
import network.rs485.logisticspipes.guidebook.ItemGuideBook;
import org.apache.logging.log4j.Logger;

@Mod(name="Logistics Pipes", modid="logisticspipes", certificateFingerprint="e0c86912b2f7cc0cc646ad57799574aea43dbd45", useMetadata=true)
public class LogisticsPipes {
    public static final String UNKNOWN = "unknown";
    private static boolean DEBUG = true;
    private Consumer<FMLServerStartedEvent> minecraftTestStartMethod = null;
    private static String VERSION = "unknown";
    private static String VENDOR = "unknown";
    private static String TARGET = "unknown";
    @Mod.Instance(value="logisticspipes")
    public static LogisticsPipes instance;
    private static boolean certificateError;
    public static Textures textures;
    public static Logger log;
    public static ExecutorService singleThreadExecutor;
    public static VersionChecker versionChecker;
    public static final CreativeTabs CREATIVE_TAB_LP;
    private Queue<Runnable> postInitRun = new LinkedList<Runnable>();
    private static LPGlobalCCAccess generalAccess;
    private static ClientConfiguration playerConfig;
    private static ServerConfigurationManager serverConfigManager;
    private List<Supplier<Pair<Item, Item>>> resetRecipeList = new ArrayList<Supplier<Pair<Item, Item>>>();
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY;
    @CapabilityInject(value=IFluidHandler.class)
    public static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY;

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public LogisticsPipes() {
        LaunchClassLoader loader = Launch.classLoader;
        LogisticsPipes.loadManifestValues((ClassLoader)loader);
        if (!LogisticsPipesCoreLoader.isCoremodLoaded()) {
            if (DEBUG) {
                throw new RuntimeException("LogisticsPipes FMLLoadingPlugin wasn't loaded. If you are running MC from an IDE make sure to add '-Dfml.coreMods.load=logisticspipes.asm.LogisticsPipesCoreLoader' to the VM arguments. If you are running MC normal please report this as a bug at 'https://github.com/RS485/LogisticsPipes/issues'.");
            }
            throw new RuntimeException("LogisticsPipes FMLLoadingPlugin wasn't loaded. Your download seems to be corrupt/modified. Please redownload LP from our Jenkins [http://ci.rs485.network] and move it into your mods folder.");
        }
        try {
            Field fTransformers = LaunchClassLoader.class.getDeclaredField("transformers");
            fTransformers.setAccessible(true);
            List transformers = (List)fTransformers.get(loader);
            LogisticsPipesClassInjector lpClassInjector = new LogisticsPipesClassInjector();
            transformers.add(lpClassInjector);
            for (int i = transformers.size() - 1; i > 0; --i) {
                transformers.set(i, transformers.get(i - 1));
            }
            transformers.set(0, lpClassInjector);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            loader.registerTransformer("logisticspipes.asm.LogisticsPipesClassInjector");
            e.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void loadManifestValues(ClassLoader loader) {
        try {
            boolean foundLp;
            Enumeration<URL> resources = loader.getResources("META-INF/MANIFEST.MF");
            do {
                Manifest manifest;
                if (!(foundLp = "LogisticsPipes".equals((manifest = new Manifest(resources.nextElement().openStream())).getMainAttributes().getValue("Specification-Title")))) continue;
                DEBUG = false;
                VERSION = manifest.getMainAttributes().getValue("Implementation-Version");
                VENDOR = manifest.getMainAttributes().getValue("Implementation-Vendor");
                TARGET = manifest.getMainAttributes().getValue("Implementation-Target");
            } while (resources.hasMoreElements() && !foundLp);
        }
        catch (IOException e) {
            log.error("There was a problem loading our MANIFEST file, Logistics Pipes will not know about its origin");
        }
    }

    public static String getVersionString() {
        return Stream.of("Logistics Pipes " + VERSION, certificateError ? "certificate error" : "", DEBUG ? "debug mode" : "", "target " + TARGET, "vendor " + VENDOR).filter(str -> !str.isEmpty()).collect(Collectors.joining(", "));
    }

    public static boolean isDevelopmentEnvironment() {
        if (!LogisticsPipes.isDEBUG()) {
            return false;
        }
        boolean eclipseCheck = new File(".classpath").exists();
        boolean ideaCheck = System.getProperty("java.class.path").contains("idea_rt.jar");
        return eclipseCheck || ideaCheck;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerRecipes();
        MainProxy.createChannels();
        RouterManager manager = new RouterManager();
        SimpleServiceLocator.setRouterManager(manager);
        SimpleServiceLocator.setChannelConnectionManager(manager);
        SimpleServiceLocator.setSecurityStationManager(manager);
        SimpleServiceLocator.setLogisticsManager(new LogisticsManager());
        SimpleServiceLocator.setInventoryUtilFactory(new InventoryUtilFactory());
        SimpleServiceLocator.setTankUtilFactory(new TankUtilFactory());
        SimpleServiceLocator.setSpecialConnectionHandler(new SpecialPipeConnection());
        SimpleServiceLocator.setSpecialConnectionHandler(new SpecialTileConnection());
        SimpleServiceLocator.setSpecialTankHandler(new SpecialTankHandler());
        SimpleServiceLocator.setMachineProgressProvider(new MachineProgressProvider());
        SimpleServiceLocator.setRoutedItemHelper(new RoutedItemHelper());
        SimpleServiceLocator.setChannelManagerProvider(new ChannelManagerProvider());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LPTickHandler());
        if (event.getSide().equals((Object)Side.CLIENT)) {
            RenderTickHandler sub = new RenderTickHandler();
            MinecraftForge.EVENT_BUS.register((Object)sub);
        }
        MinecraftForge.EVENT_BUS.register((Object)new QueuedTasks());
        if (event.getSide() == Side.CLIENT) {
            SimpleServiceLocator.setClientPacketBufferHandlerThread(new ClientPacketBufferHandlerThread());
        }
        SimpleServiceLocator.setServerPacketBufferHandlerThread(new ServerPacketBufferHandlerThread());
        for (int i = 0; i < Configs.MULTI_THREAD_NUMBER; ++i) {
            new RoutingTableUpdateThread(i);
        }
        MinecraftForge.EVENT_BUS.register((Object)new LogisticsEventListener());
        MinecraftForge.EVENT_BUS.register((Object)new LPChatListener());
        MinecraftForge.EVENT_BUS.register((Object)PropertyUpdaterEventListener.INSTANCE);
        LPDataFixer.INSTANCE.init();
        if (event.getSide() == Side.SERVER) {
            textures.registerBlockIcons(null);
        } else if (event.getSide() == Side.CLIENT) {
            LPFontRenderer.Factory.asyncPreload();
        }
        LogisticsNewRenderPipe.loadModels();
        LogisticsNewSolidBlockWorldRenderer.loadModels();
        CurveTubeRenderer.loadModels();
        GainTubeRenderer.loadModels();
        LineTubeRenderer.loadModels();
        SpeedupTubeRenderer.loadModels();
        SCurveTubeRenderer.loadModels();
        if (LogisticsPipes.isTesting()) {
            Object minecraftTestInstance;
            Class<?> testClass;
            try {
                testClass = Class.forName("network.rs485.logisticspipes.integration.MinecraftTest");
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Error loading minecraft test class", e);
            }
            try {
                minecraftTestInstance = testClass.getDeclaredField("INSTANCE").get(null);
                Method serverStartMethod = testClass.getDeclaredMethod("serverStart", FMLServerStartedEvent.class);
                this.minecraftTestStartMethod = serverStartedEvent -> {
                    try {
                        serverStartMethod.invoke(minecraftTestInstance, serverStartedEvent);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException("Could not run server started hook in " + minecraftTestInstance, e);
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Error accessing minecraft test instance", e);
            }
            MinecraftForge.EVENT_BUS.register(minecraftTestInstance);
        }
    }

    public static boolean isTesting() {
        String testSetting = System.getProperty("logisticspipes.test");
        return testSetting != null && testSetting.equalsIgnoreCase("true");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        StaticResolverUtil.useASMDataTable(evt.getAsmData());
        PacketHandler.initialize();
        NewGuiHandler.initialize();
        log = evt.getModLog();
        log.info("====================================================");
        log.info(" LogisticsPipes Logger initialized, enabled levels: ");
        log.info("----------------------------------------------------");
        log.info("    Fatal: " + log.isFatalEnabled());
        log.info("    Error: " + log.isErrorEnabled());
        log.info("    Warn:  " + log.isWarnEnabled());
        log.info("    Info:  " + log.isInfoEnabled());
        log.info("    Trace: " + log.isTraceEnabled());
        log.info("    Debug: " + log.isDebugEnabled());
        log.info("====================================================");
        this.loadClasses();
        ProxyManager.load();
        Configs.load();
        if (certificateError) {
            log.fatal("Certificate not correct");
            log.fatal("This in not a LogisticsPipes version from RS485.");
        }
        if (UNKNOWN.equals(VERSION)) {
            log.warn("Could not determine Logistics Pipes version, we do need that META-INF/MANIFEST.MF, don't you know?");
        }
        log.info("Running " + LogisticsPipes.getVersionString());
        SimpleServiceLocator.setPipeInformationManager(new PipeInformationManager());
        SimpleServiceLocator.setLogisticsFluidManager(new LogisticsFluidManager());
        if (Loader.isModLoaded((String)"theoneprobe")) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)TheOneProbeIntegration.class.getName());
        }
        MainProxy.proxy.initModelLoader();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.postInitRun.forEach(Runnable::run);
        this.postInitRun = null;
        SpecialInventoryHandlerManager.load();
        SpecialTankHandlerManager.load();
        SimpleServiceLocator.buildCraftProxy.registerPipeInformationProvider();
        SimpleServiceLocator.buildCraftProxy.initProxy();
        SimpleServiceLocator.thermalDynamicsProxy.registerPipeInformationProvider();
        SimpleServiceLocator.specialtileconnection.registerHandler(new EnderIOTransceiverConnection());
        if (SimpleServiceLocator.buildCraftProxy.getAssemblyTableProviderClass() != null) {
            SimpleServiceLocator.addCraftingRecipeProvider(LogisticsWrapperHandler.getWrappedRecipeProvider("buildcraftsilicon", "AssemblyTable", SimpleServiceLocator.buildCraftProxy.getAssemblyTableProviderClass()));
        }
        SimpleServiceLocator.addCraftingRecipeProvider(new LogisticsCraftingTable());
        SimpleServiceLocator.machineProgressProvider.registerProgressProvider(LogisticsWrapperHandler.getWrappedProgressProvider("thermalexpansion", "Generic", ThermalExpansionProgressProvider.class));
        SimpleServiceLocator.machineProgressProvider.registerProgressProvider(LogisticsWrapperHandler.getWrappedProgressProvider("ic2", "Generic", IC2ProgressProvider.class));
        SimpleServiceLocator.machineProgressProvider.registerProgressProvider(LogisticsWrapperHandler.getWrappedProgressProvider("endercore", "Generic", EnderCoreProgressProvider.class));
        GameRegistry.registerTileEntity(LogisticsPowerJunctionTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "power_junction"));
        GameRegistry.registerTileEntity(LogisticsRFPowerProviderTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "power_provider_rf"));
        GameRegistry.registerTileEntity(LogisticsIC2PowerProviderTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "power_provider_ic2"));
        GameRegistry.registerTileEntity(LogisticsSecurityTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "security_station"));
        GameRegistry.registerTileEntity(LogisticsCraftingTableTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "logistics_crafting_table"));
        GameRegistry.registerTileEntity(LogisticsTileGenericPipe.class, (ResourceLocation)new ResourceLocation("logisticspipes", "pipe"));
        GameRegistry.registerTileEntity(LogisticsStatisticsTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "statistics_table"));
        GameRegistry.registerTileEntity(LogisticsProgramCompilerTileEntity.class, (ResourceLocation)new ResourceLocation("logisticspipes", "program_compiler"));
        GameRegistry.registerTileEntity(LogisticsTileGenericSubMultiBlock.class, (ResourceLocation)new ResourceLocation("logisticspipes", "submultiblock"));
        MainProxy.proxy.registerTileEntities();
        SimpleServiceLocator.mcmpProxy.registerTileEntities();
        MainProxy.proxy.registerParticles();
        FluidIdentifier.initFromForge(false);
        versionChecker = VersionChecker.runVersionCheck();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureLoad(TextureStitchEvent.Pre event) {
        if (!event.getMap().getBasePath().equals("textures")) {
            return;
        }
        MainProxy.proxy.registerTextures();
    }

    @SubscribeEvent
    public void initItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ItemPipeSignCreator.registerPipeSignTypes();
        ItemModule.loadModules((IForgeRegistry<Item>)registry);
        ItemUpgrade.loadUpgrades((IForgeRegistry<Item>)registry);
        this.registerPipes((IForgeRegistry<Item>)registry);
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsItemCard(), "item_card"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new RemoteOrderer(), "remote_orderer"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemPipeSignCreator(), "sign_creator"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemHUDArmor(), "hud_glasses"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemParts(), "parts"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemBlankModule(), "module_blank"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemDisk(), "disk"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsFluidContainer(), "fluid_container"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsBrokenItem(), "broken_item"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemGuideBook(), "guide_book"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemPipeController(), "pipe_controller"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemPipeManager(), "pipe_manager"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsProgrammer(), "logistics_programmer"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsChips(0), "chip_basic"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsChips(1), "chip_basic_raw"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsChips(2), "chip_advanced"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsChips(3), "chip_advanced_raw"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsChips(4), "chip_fpga"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new ItemLogisticsChips(5), "chip_fpga_raw"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.frame), "frame"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.powerJunction), "power_junction"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.securityStation), "security_station"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.crafter), "crafting_table"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.crafterFuzzy), "crafting_table_fuzzy"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.statisticsTable), "statistics_table"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.powerProviderRF), "power_provider_rf"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.powerProviderEU), "power_provider_eu"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.powerProviderMJ), "power_provider_mj"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlockItem(LPBlocks.programCompiler), "program_compiler"));
    }

    public static <T extends Item> T setName(T item, String name) {
        return LogisticsPipes.setName(item, name, "logisticspipes");
    }

    public static <T extends Item> T setName(T item, String name, String modID) {
        item.setRegistryName(modID, name);
        item.func_77655_b(String.format("%s.%s", modID, name));
        return item;
    }

    public static <T extends Block> T setName(T block, String name) {
        block.setRegistryName("logisticspipes", name);
        block.func_149663_c(String.format("%s.%s", "logisticspipes", name));
        return block;
    }

    @SubscribeEvent
    public void initBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_BLOCK_FRAME), "frame"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_POWER_JUNCTION), "power_junction"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_SECURITY_STATION), "security_station"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_AUTOCRAFTING_TABLE), "crafting_table"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_FUZZYCRAFTING_TABLE), "crafting_table_fuzzy"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_STATISTICS_TABLE), "statistics_table"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_RF_POWERPROVIDER), "power_provider_rf"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_IC2_POWERPROVIDER), "power_provider_eu"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_BC_POWERPROVIDER), "power_provider_mj"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsSolidBlock(LogisticsSolidBlock.Type.LOGISTICS_PROGRAM_COMPILER), "program_compiler"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new BlockDummy(), "solid_block"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsBlockGenericPipe(), "pipe"));
        registry.register((IForgeRegistryEntry)LogisticsPipes.setName(new LogisticsBlockGenericSubMultiBlock(), "sub_multiblock"));
    }

    @SubscribeEvent
    public void onModelLoad(ModelRegistryEvent e) {
        MainProxy.proxy.registerModels();
    }

    private void registerRecipes() {
        RecipeManager.recipeProvider.add(new LPChipRecipes());
        RecipeManager.recipeProvider.add(new UpgradeChippedCraftingRecipes());
        RecipeManager.recipeProvider.add(new ModuleChippedCraftingRecipes());
        RecipeManager.recipeProvider.add(new PipeChippedCraftingRecipes());
        RecipeManager.recipeProvider.add(new CraftingRecipes());
        RecipeManager.loadRecipes();
        this.resetRecipeList.stream().map(Supplier::get).forEach(itemItemPair -> this.registerShapelessResetRecipe((Item)itemItemPair.getValue1(), (Item)itemItemPair.getValue2()));
    }

    private void loadClasses() {
        this.forName("net.minecraft.tileentity.TileEntity");
        this.forName("net.minecraft.world.World");
        this.forName("net.minecraft.item.ItemStack");
        this.forName("net.minecraftforge.fluids.FluidStack");
        this.forName("net.minecraftforge.fluids.Fluid");
        this.forName("cofh.thermaldynamics.block.TileTDBase");
        this.forName("cofh.thermaldynamics.duct.item.TravelingItem");
        this.forName("crazypants.enderio.conduit.item.ItemConduit");
        this.forName("crazypants.enderio.conduit.item.NetworkedInventory");
        this.forName("crazypants.enderio.conduit.liquid.AbstractLiquidConduit");
        this.forName("mcmultipart.block.BlockMultipartContainer");
    }

    private void forName(String string) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void beforeStart(FMLServerAboutToStartEvent event) {
        ServerTickDispatcher.INSTANCE.serverStart();
    }

    @Mod.EventHandler
    public void cleanup(FMLServerStoppingEvent event) {
        SimpleServiceLocator.routerManager.serverStopClean();
        QueuedTasks.clearAllTasks();
        HudUpdateTick.clearUpdateFlags();
        PipeItemsSatelliteLogistics.cleanup();
        PipeFluidSatellite.cleanup();
        ServerRouter.cleanup();
        if (event.getSide().equals((Object)Side.CLIENT)) {
            LogisticsHUDRenderer.instance().clear();
        }
        ServerTickDispatcher.INSTANCE.cleanup();
        serverConfigManager = null;
    }

    @Mod.EventHandler
    public void registerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new LogisticsPipesCommand());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (this.minecraftTestStartMethod != null) {
            this.minecraftTestStartMethod.accept(event);
        }
    }

    @Mod.EventHandler
    public void certificateWarning(FMLFingerprintViolationEvent warning) {
        certificateError = true;
        if (!LogisticsPipes.isDEBUG()) {
            System.out.println("[LogisticsPipes|Certificate] Certificate not correct");
            System.out.println("[LogisticsPipes|Certificate] Expected: " + warning.getExpectedFingerprint());
            System.out.println("[LogisticsPipes|Certificate] File: " + warning.getSource().getAbsolutePath());
            System.out.println("[LogisticsPipes|Certificate] This in not a LogisticsPipes version from RS485.");
        }
    }

    public static Object getComputerLP() {
        if (generalAccess == null) {
            generalAccess = new LPGlobalCCAccess();
        }
        return generalAccess;
    }

    public void registerPipes(IForgeRegistry<Item> registry) {
        this.registerPipe(registry, "basic", PipeItemsBasicLogistics::new);
        this.registerPipe(registry, "request", PipeItemsRequestLogistics::new);
        this.registerPipe(registry, "provider", PipeItemsProviderLogistics::new);
        this.registerPipe(registry, "crafting", PipeItemsCraftingLogistics::new);
        this.registerPipe(registry, "satellite", PipeItemsSatelliteLogistics::new);
        this.registerPipe(registry, "supplier", PipeItemsSupplierLogistics::new);
        this.registerPipe(registry, "chassis_mk1", PipeLogisticsChassisMk1::new);
        this.registerPipe(registry, "chassis_mk2", PipeLogisticsChassisMk2::new);
        this.registerPipe(registry, "chassis_mk3", PipeLogisticsChassisMk3::new);
        this.registerPipe(registry, "chassis_mk4", PipeLogisticsChassisMk4::new);
        this.registerPipe(registry, "chassis_mk5", PipeLogisticsChassisMk5::new);
        this.registerPipe(registry, "request_mk2", PipeItemsRequestLogisticsMk2::new);
        this.registerPipe(registry, "remote_orderer", PipeItemsRemoteOrdererLogistics::new);
        this.registerPipe(registry, "inventory_system_connector", PipeItemsInvSysConnector::new);
        this.registerPipe(registry, "system_entrance", PipeItemsSystemEntranceLogistics::new);
        this.registerPipe(registry, "system_destination", PipeItemsSystemDestinationLogistics::new);
        this.registerPipe(registry, "firewall", PipeItemsFirewall::new);
        this.registerPipe(registry, "fluid_basic", PipeFluidBasic::new);
        this.registerPipe(registry, "fluid_supplier", PipeItemsFluidSupplier::new);
        this.registerPipe(registry, "fluid_insertion", PipeFluidInsertion::new);
        this.registerPipe(registry, "fluid_provider", PipeFluidProvider::new);
        this.registerPipe(registry, "fluid_request", PipeFluidRequestLogistics::new);
        this.registerPipe(registry, "fluid_extractor", PipeFluidExtractor::new);
        this.registerPipe(registry, "fluid_satellite", PipeFluidSatellite::new);
        this.registerPipe(registry, "fluid_supplier_mk2", PipeFluidSupplierMk2::new);
        this.registerPipe(registry, "request_table", PipeBlockRequestTable::new);
        this.registerPipe(registry, "transport_basic", PipeItemsBasicTransport::new);
        this.registerPipe(registry, "hs_curve", HSTubeCurve::new);
        this.registerPipe(registry, "hs_speedup", HSTubeSpeedup::new);
        this.registerPipe(registry, "hs_s_curve", HSTubeSCurve::new);
        this.registerPipe(registry, "hs_line", HSTubeLine::new);
        this.registerPipe(registry, "hs_gain", HSTubeGain::new);
    }

    protected void registerPipe(IForgeRegistry<Item> registry, String name, Function<Item, ? extends CoreUnroutedPipe> constructor) {
        ItemLogisticsPipe res = LogisticsBlockGenericPipe.registerPipe(registry, name, constructor);
        CoreUnroutedPipe pipe = Objects.requireNonNull(LogisticsBlockGenericPipe.createPipe(res), "created a null pipe from " + res.toString());
        if (pipe instanceof CoreRoutedPipe) {
            this.postInitRun.add(() -> res.setPipeIconIndex(((CoreRoutedPipe)pipe).getTextureType(null).normal, ((CoreRoutedPipe)pipe).getTextureType(null).newTexture));
        }
        if (pipe.getClass() != PipeItemsBasicLogistics.class && CoreRoutedPipe.class.isAssignableFrom(pipe.getClass())) {
            if (pipe.getClass() != PipeFluidBasic.class && PipeFluidBasic.class.isAssignableFrom(pipe.getClass())) {
                this.resetRecipeList.add(() -> new Pair<ItemLogisticsPipe, Item>(res, LPItems.pipeFluidBasic));
            } else if (pipe.getClass() != PipeBlockRequestTable.class) {
                this.resetRecipeList.add(() -> new Pair<ItemLogisticsPipe, Item>(res, LPItems.pipeBasic));
            }
        }
    }

    protected void registerShapelessResetRecipe(Item fromItem, Item toItem) {
        ResourceLocation baseLoc;
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)CraftingHelper.getIngredient((Object)new ItemStack(fromItem, 1, 0)));
        ItemStack output = new ItemStack(toItem, 1, 0);
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation("logisticspipes", fromItem.getRegistryName().func_110623_a() + ".resetrecipe");
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation("logisticspipes", baseLoc.func_110623_a() + "_" + ++index);
        }
        ShapelessRecipes recipe = new ShapelessRecipes("logisticspipes.resetrecipe.pipe", output, list);
        recipe.setRegistryName(recipeLoc);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static ClientConfiguration getClientPlayerConfig() {
        if (playerConfig == null) {
            playerConfig = new ClientConfiguration();
        }
        return playerConfig;
    }

    public static ServerConfigurationManager getServerConfigManager() {
        if (serverConfigManager == null) {
            serverConfigManager = new ServerConfigurationManager();
        }
        return serverConfigManager;
    }

    public static String getVERSION() {
        return VERSION;
    }

    public static String getVENDOR() {
        return VENDOR;
    }

    public static String getTARGET() {
        return TARGET;
    }

    static {
        certificateError = false;
        textures = new Textures();
        singleThreadExecutor = Executors.newSingleThreadExecutor();
        CREATIVE_TAB_LP = new CreativeTabs("Logistics_Pipes"){

            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack(LPItems.pipeBasic);
            }
        };
        ITEM_HANDLER_CAPABILITY = null;
        FLUID_HANDLER_CAPABILITY = null;
    }
}

