/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.items.LogisticsItem;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.modules.ModuleCreativeTabBasedItemSink;
import logisticspipes.modules.ModuleEnchantmentSink;
import logisticspipes.modules.ModuleEnchantmentSinkMK2;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.ModuleModBasedItemSink;
import logisticspipes.modules.ModuleOreDictItemSink;
import logisticspipes.modules.ModulePassiveSupplier;
import logisticspipes.modules.ModulePolymorphicItemSink;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.modules.ModuleTerminus;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.DummyWorldProvider;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import network.rs485.logisticspipes.module.AsyncAdvancedExtractor;
import network.rs485.logisticspipes.module.AsyncExtractorModule;
import network.rs485.logisticspipes.module.AsyncQuicksortModule;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Keyboard;

public class ItemModule
extends LogisticsItem {
    private final Module moduleType;

    public ItemModule(Module moduleType) {
        this.moduleType = moduleType;
        this.func_77627_a(false);
    }

    public static void loadModules(IForgeRegistry<Item> registry) {
        ItemModule.registerModule(registry, ModuleItemSink.getName(), ModuleItemSink::new);
        ItemModule.registerModule(registry, ModulePassiveSupplier.getName(), ModulePassiveSupplier::new);
        ItemModule.registerModule(registry, AsyncExtractorModule.getName(), AsyncExtractorModule::new);
        ItemModule.registerModule(registry, ModulePolymorphicItemSink.getName(), ModulePolymorphicItemSink::new);
        ItemModule.registerModule(registry, AsyncQuicksortModule.getName(), AsyncQuicksortModule::new);
        ItemModule.registerModule(registry, ModuleTerminus.getName(), ModuleTerminus::new);
        ItemModule.registerModule(registry, AsyncAdvancedExtractor.getName(), AsyncAdvancedExtractor::new);
        ItemModule.registerModule(registry, ModuleProvider.getName(), ModuleProvider::new);
        ItemModule.registerModule(registry, ModuleModBasedItemSink.getName(), ModuleModBasedItemSink::new);
        ItemModule.registerModule(registry, ModuleOreDictItemSink.getName(), ModuleOreDictItemSink::new);
        ItemModule.registerModule(registry, ModuleEnchantmentSink.getName(), ModuleEnchantmentSink::new);
        ItemModule.registerModule(registry, ModuleEnchantmentSinkMK2.getName(), ModuleEnchantmentSinkMK2::new);
        ItemModule.registerModule(registry, ModuleCrafter.getName(), ModuleCrafter::new);
        ItemModule.registerModule(registry, ModuleActiveSupplier.getName(), ModuleActiveSupplier::new);
        ItemModule.registerModule(registry, ModuleCreativeTabBasedItemSink.getName(), ModuleCreativeTabBasedItemSink::new);
    }

    public static void registerModule(IForgeRegistry<Item> registry, String name, @Nonnull Supplier<? extends LogisticsModule> moduleConstructor) {
        ItemModule.registerModule(registry, name, moduleConstructor, "logisticspipes");
    }

    public static void registerModule(IForgeRegistry<Item> registry, String name, @Nonnull Supplier<? extends LogisticsModule> moduleConstructor, String modID) {
        ItemModule module = LogisticsPipes.setName(new ItemModule(new Module(moduleConstructor)), String.format("module_%s", name), modID);
        LPItems.modules.put((Object)name, (Object)module.getRegistryName());
        registry.register((IForgeRegistryEntry)module);
    }

    @Nullable
    public static LogisticsModule getLogisticsModule(@Nonnull EntityPlayer player, int invSlot) {
        ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(invSlot);
        if (item.func_190926_b() || !(item.func_77973_b() instanceof ItemModule)) {
            return null;
        }
        LogisticsModule module = ((ItemModule)item.func_77973_b()).getModuleForItem(item, null, new DummyWorldProvider(player.func_130014_f_()), null);
        if (module == null) {
            return null;
        }
        module.registerPosition(LogisticsModule.ModulePositionType.IN_HAND, invSlot);
        ItemModuleInformationManager.readInformation(item, module);
        return module;
    }

    private void openConfigGui(@Nonnull ItemStack stack, EntityPlayer player, World world) {
        LogisticsModule module = this.getModuleForItem(stack, null, new DummyWorldProvider(world), null);
        if (module instanceof Gui && !stack.func_190926_b()) {
            module.registerPosition(LogisticsModule.ModulePositionType.IN_HAND, player.field_71071_by.field_70461_c);
            ItemModuleInformationManager.readInformation(stack, module);
            Gui.getInHandGuiProvider((Gui)((Object)module)).open(player);
        }
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        LogisticsModule module = this.getModuleForItem(stack, null, null, null);
        if (module != null && stack.func_190916_E() > 0) {
            return module.hasEffect();
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            this.openConfigGui(player.func_184586_b(hand), player, world);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof LogisticsTileGenericPipe) {
                CoreUnroutedPipe pipe;
                if (player.func_145748_c_().func_150260_c().equals("ComputerCraft") && LogisticsBlockGenericPipe.isValid(pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos))) {
                    pipe.blockActivated(player);
                }
                return EnumActionResult.PASS;
            }
            this.openConfigGui(player.field_71071_by.func_70448_g(), player, world);
        }
        return EnumActionResult.PASS;
    }

    @Nullable
    public LogisticsModule getModule(@Nullable LogisticsModule currentModule, @Nullable IWorldProvider world, @Nullable IPipeServiceProvider service) {
        if (currentModule != null && this.moduleType.getILogisticsModuleClass().equals(currentModule.getClass())) {
            return currentModule;
        }
        LogisticsModule newmodule = this.moduleType.getILogisticsModule();
        if (newmodule == null) {
            return null;
        }
        newmodule.registerHandler(world, service);
        return newmodule;
    }

    @Nullable
    public LogisticsModule getModuleForItem(@Nonnull ItemStack itemStack, @Nullable LogisticsModule currentModule, @Nullable IWorldProvider world, @Nullable IPipeServiceProvider service) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (itemStack.func_77973_b() != this) {
            return null;
        }
        return this.getModule(currentModule, world, service);
    }

    @Override
    public String getModelSubdir() {
        return "module";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            assert (nbt != null);
            if (nbt.func_74764_b("informationList")) {
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    NBTTagList nbttaglist = nbt.func_150295_c("informationList", 8);
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        NBTBase nbttag = nbttaglist.func_179238_g(i);
                        String data = ((NBTTagString)nbttag).func_150285_a_();
                        if (data.equals("<inventory>") && i + 1 < nbttaglist.func_74745_c()) {
                            nbttag = nbttaglist.func_179238_g(i + 1);
                            data = ((NBTTagString)nbttag).func_150285_a_();
                            if (data.startsWith("<that>")) {
                                String prefix = data.substring(6);
                                NBTTagCompound module = nbt.func_74775_l("moduleInformation");
                                int size = module.func_150295_c(prefix + "items", (int)module.func_74732_a()).func_74745_c();
                                if (module.func_74764_b(prefix + "itemsCount")) {
                                    size = module.func_74762_e(prefix + "itemsCount");
                                }
                                ItemIdentifierInventory inv = new ItemIdentifierInventory(size, "InformationTempInventory", Integer.MAX_VALUE);
                                inv.readFromNBT(module, prefix);
                                for (int pos = 0; pos < inv.func_70302_i_(); ++pos) {
                                    ItemIdentifierStack identStack = inv.getIDStackInSlot(pos);
                                    if (identStack == null) continue;
                                    if (identStack.getStackSize() > 1) {
                                        tooltip.add("  " + identStack.getStackSize() + "x " + identStack.getFriendlyName());
                                        continue;
                                    }
                                    tooltip.add("  " + identStack.getFriendlyName());
                                }
                            }
                            ++i;
                            continue;
                        }
                        tooltip.add(data);
                    }
                } else {
                    TextUtil.addTooltipInformation(stack, tooltip, false);
                }
            } else {
                TextUtil.addTooltipInformation(stack, tooltip, Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
            }
        } else {
            TextUtil.addTooltipInformation(stack, tooltip, Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
        }
    }

    private static class Module {
        private final Supplier<? extends LogisticsModule> moduleConstructor;
        private final Class<? extends LogisticsModule> moduleClass;

        private Module(Supplier<? extends LogisticsModule> moduleConstructor) {
            this.moduleConstructor = moduleConstructor;
            this.moduleClass = moduleConstructor.get().getClass();
        }

        private LogisticsModule getILogisticsModule() {
            if (this.moduleConstructor == null) {
                return null;
            }
            return this.moduleConstructor.get();
        }

        private Class<? extends LogisticsModule> getILogisticsModuleClass() {
            return this.moduleClass;
        }
    }
}

