/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.util.EnumFacing;

public class ChassisTransportLayer
extends TransportLayer {
    private final PipeLogisticsChassis _chassiPipe;

    public ChassisTransportLayer(PipeLogisticsChassis chassiPipe) {
        this._chassiPipe = chassiPipe;
    }

    @Override
    public EnumFacing itemArrived(IRoutedItem item, EnumFacing blocked) {
        if (item.getItemIdentifierStack() != null) {
            this._chassiPipe.recievedItem(item.getItemIdentifierStack().getStackSize());
        }
        return this._chassiPipe.getPointedOrientation();
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        LogisticsModule module = this._chassiPipe.getLogisticsModule();
        if (module == null) {
            this._chassiPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        if (!this._chassiPipe.isEnabled()) {
            this._chassiPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        ItemIdentifierStack itemidStack = item.getItemIdentifierStack();
        SinkReply reply = module.sinksItem(itemidStack.makeNormalStack(), itemidStack.getItem(), -1, 0, true, false, false);
        if (reply == null || reply.maxNumberOfItems < 0) {
            this._chassiPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        if (reply.maxNumberOfItems > 0 && itemidStack.getStackSize() > reply.maxNumberOfItems) {
            EnumFacing o = this._chassiPipe.getPointedOrientation();
            if (o == null) {
                o = EnumFacing.UP;
            }
            item.split(reply.maxNumberOfItems, o);
        }
        return true;
    }
}

