/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.modules.HUDItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ItemSinkInHand;
import logisticspipes.network.guis.module.inpipe.ItemSinkSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.network.packets.modules.ItemSinkDefault;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.module.SimpleFilter;
import network.rs485.logisticspipes.property.BitSetProperty;
import network.rs485.logisticspipes.property.BooleanProperty;
import network.rs485.logisticspipes.property.InventoryProperty;
import network.rs485.logisticspipes.property.Property;

@CCType(name="ItemSink Module")
public class ModuleItemSink
extends LogisticsModule
implements SimpleFilter,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive,
Gui {
    public final InventoryProperty filterInventory = new InventoryProperty(new ItemIdentifierInventory(9, "Requested items", 1), "");
    public final BooleanProperty defaultRoute = new BooleanProperty(false, "defaultdestination");
    public final BitSetProperty ignoreData = new BitSetProperty(new BitSet(this.filterInventory.func_70302_i_()), "ignoreData");
    public final BitSetProperty ignoreNBT = new BitSetProperty(new BitSet(this.filterInventory.func_70302_i_()), "ignoreNBT");
    private final List<Property<?>> properties = ImmutableList.builder().add((Object)this.filterInventory).add((Object)this.defaultRoute).add((Object)this.ignoreData).add((Object)this.ignoreNBT).build();
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final IHUDModuleRenderer HUD = new HUDItemSink(this);
    private SinkReply _sinkReply;
    private SinkReply _sinkReplyDefault;

    public ModuleItemSink() {
        this.filterInventory.addListener(this);
    }

    public static String getName() {
        return "item_sink";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleItemSink.getName();
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    @CCCommand(description="Returns the FilterInventory of this Module")
    @Nonnull
    public IItemIdentifierInventory getFilterInventory() {
        return this.filterInventory;
    }

    @CCCommand(description="Returns true if the module is a default route")
    public boolean isDefaultRoute() {
        return (Boolean)this.defaultRoute.getValue();
    }

    @CCCommand(description="Sets the default route status of this module")
    public void setDefaultRoute(Boolean isDefaultRoute) {
        this.defaultRoute.setValue(isDefaultRoute);
        if (!this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ItemSinkDefault.class).setFlag(isDefaultRoute).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
        this._sinkReplyDefault = new SinkReply(SinkReply.FixedPriority.DefaultRoute, 0, true, true, 1, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    public Stream<ItemIdentifier> getAdjacentInventoriesItems() {
        return Objects.requireNonNull(this._service).getAvailableAdjacent().inventories().stream().map(LPNeighborTileEntityKt::getInventoryUtil).filter(Objects::nonNull).flatMap(invUtil -> invUtil.getItems().stream()).distinct();
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (((Boolean)this.defaultRoute.getValue()).booleanValue() && !allowDefault) {
            return null;
        }
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return null;
        }
        if (this.filterInventory.containsUndamagedItem(item.getUndamaged())) {
            if (service.canUseEnergy(1)) {
                return this._sinkReply;
            }
            return null;
        }
        ISlotUpgradeManager upgradeManager = this.getUpgradeManager();
        if (upgradeManager.isFuzzyUpgrade()) {
            for (Pair<ItemIdentifierStack, Integer> filter2 : this.filterInventory.contents()) {
                if (filter2 == null || filter2.getValue1() == null) continue;
                ItemIdentifier ident1 = item;
                ItemIdentifier ident2 = filter2.getValue1().getItem();
                if (this.ignoreData.get(filter2.getValue2())) {
                    ident1 = ident1.getIgnoringData();
                    ident2 = ident2.getIgnoringData();
                }
                if (this.ignoreNBT.get(filter2.getValue2())) {
                    ident1 = ident1.getIgnoringNBT();
                    ident2 = ident2.getIgnoringNBT();
                }
                if (!ident1.equals(ident2)) continue;
                if (service.canUseEnergy(5)) {
                    return this._sinkReply;
                }
                return null;
            }
        }
        if (((Boolean)this.defaultRoute.getValue()).booleanValue()) {
            if (bestPriority > this._sinkReplyDefault.fixedPriority.ordinal() || bestPriority == this._sinkReplyDefault.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReplyDefault.customPriority) {
                return null;
            }
            if (service.canUseEnergy(1)) {
                return this._sinkReplyDefault;
            }
            return null;
        }
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Default: " + (this.isDefaultRoute() ? "Yes" : "No"));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.filterInventory)).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ItemSinkDefault.class).setFlag((Boolean)this.defaultRoute.getValue()).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        MainProxy.runOnServer((IBlockAccess)this.getWorld(), () -> () -> MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers));
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(@Nonnull Collection<ItemIdentifierStack> list) {
        this.filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return (Boolean)this.defaultRoute.getValue();
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        if (((Boolean)this.defaultRoute.getValue()).booleanValue()) {
            return;
        }
        Map<ItemIdentifier, Integer> mapIC = this.filterInventory.getItemsAndCount();
        itemidCollection.addAll(mapIC.keySet());
        mapIC.keySet().stream().map(ItemIdentifier::getUndamaged).forEach(itemidCollection::add);
        if (this.getUpgradeManager().isFuzzyUpgrade()) {
            for (Pair<ItemIdentifierStack, Integer> stack : this.filterInventory.contents()) {
                if (stack.getValue1() == null) continue;
                ItemIdentifier ident = stack.getValue1().getItem();
                if (this.ignoreData.get(stack.getValue2())) {
                    itemidCollection.add(ident.getIgnoringData());
                }
                if (this.ignoreNBT.get(stack.getValue2())) {
                    itemidCollection.add(ident.getIgnoringNBT());
                }
                if (!this.ignoreData.get(stack.getValue2()) || !this.ignoreNBT.get(stack.getValue2())) continue;
                itemidCollection.add(ident.getIgnoringData().getIgnoringNBT());
            }
        }
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    public void setIgnoreData(BitSet ignoreData) {
        this.ignoreData.replaceWith(ignoreData);
    }

    public void setIgnoreNBT(BitSet ignoreNBT) {
        this.ignoreNBT.replaceWith(ignoreNBT);
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ItemSinkSlot.class).setDefaultRoute((Boolean)this.defaultRoute.getValue()).setIgnoreData(this.ignoreData.copyValue()).setIgnoreNBT(this.ignoreNBT.copyValue()).setHasFuzzyUpgrade(this.getUpgradeManager().isFuzzyUpgrade());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ItemSinkInHand.class);
    }
}

